/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.transform;

import io.lucenia.indexmanagement.indexstatemanagement.action.TransformAction;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformAction;
import io.lucenia.indexmanagement.transform.action.index.IndexTransformRequest;
import io.lucenia.indexmanagement.transform.action.start.StartTransformAction;
import io.lucenia.indexmanagement.transform.action.start.StartTransformRequest;
import io.lucenia.indexmanagement.transform.model.Transform;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionProperties;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import io.skylite.indexmanagement.model.TransformActionProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptCreateTransformJobStep
extends Step {
    private final TransformAction action;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    private String transformId = null;
    private CompletableFuture<Step> future;
    public static final String name = "attempt_create_transform";

    public AttemptCreateTransformJobStep(TransformAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        this.future = new CompletableFuture();
        StepContext context = this.getContext();
        if (context == null) {
            this.future.complete(this);
            return this.future;
        }
        String indexName = context.getMetadata().getIndex();
        ManagedIndexMetaData managedIndexMetadata = context.getMetadata();
        String startedTransformId = managedIndexMetadata.getActionMetaData() != null && managedIndexMetadata.getActionMetaData().getActionProperties() != null && managedIndexMetadata.getActionMetaData().getActionProperties().getTransformActionProperties() != null ? managedIndexMetadata.getActionMetaData().getActionProperties().getTransformActionProperties().getTransformId() : null;
        Transform transform = this.action.getIsmTransform().toTransform(indexName, context.getUser());
        this.transformId = transform.getId();
        this.logger.info("Attempting to create a transform job " + this.transformId + " for index " + indexName);
        IndexTransformRequest indexTransformRequest = new IndexTransformRequest(transform, WriteRequest.RefreshPolicy.IMMEDIATE);
        context.getClient().execute((ActionType)IndexTransformAction.INSTANCE, (ActionRequest)indexTransformRequest, ActionListener.wrap(response -> {
            this.logger.info("Received status " + response.getStatus().getStatus() + " on trying to create transform job " + this.transformId);
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptCreateTransformJobStep.getSuccessMessage(transform.getId(), indexName));
            this.future.complete(this);
        }, e -> {
            if (e instanceof VersionConflictEngineException) {
                String message = AttemptCreateTransformJobStep.getTransformJobAlreadyExistsMessage(transform.getId(), indexName);
                this.logger.info(message);
                if (startedTransformId == null) {
                    this.startTransformJob(transform.getId(), context);
                } else {
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = Map.of("info", message);
                    this.future.complete(this);
                }
            } else if (e instanceof RemoteTransportException) {
                this.processFailure(transform.getId(), indexName, (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                this.future.complete(this);
            } else if (e instanceof SkyliteException) {
                this.processFailure(transform.getId(), indexName, (Exception)((Object)((SkyliteException)((Object)((Object)e)))));
                this.future.complete(this);
            } else {
                this.processFailure(transform.getId(), indexName, (Exception)e);
                this.future.complete(this);
            }
        }));
        return this.future;
    }

    public void processFailure(String transformId, String indexName, Exception e) {
        String message = AttemptCreateTransformJobStep.getFailedMessage(transformId, indexName);
        this.logger.error(message, (Throwable)e);
        this.transformId = null;
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        mutableInfo.put("cause", e.getMessage() != null ? e.getMessage() : "");
        this.info = mutableInfo;
    }

    private void startTransformJob(String transformId, StepContext context) {
        String indexName = context.getMetadata().getIndex();
        this.logger.info("Attempting to re-start the transform job " + transformId);
        StartTransformRequest startTransformRequest = new StartTransformRequest(transformId);
        context.getClient().execute((ActionType)StartTransformAction.INSTANCE, (ActionRequest)startTransformRequest, ActionListener.wrap(response -> {
            this.stepStatus = Step.StepStatus.COMPLETED;
            this.info = Map.of("message", AttemptCreateTransformJobStep.getSuccessRestartMessage(transformId, indexName));
            this.future.complete(this);
        }, e -> {
            String message = AttemptCreateTransformJobStep.getFailedToStartMessage(transformId, indexName);
            this.logger.error(message, (Throwable)e);
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", message);
            this.future.complete(this);
        }));
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        ActionMetaData currentActionMetaData = currentMetadata.getActionMetaData();
        TransformActionProperties transformActionProperties = new TransformActionProperties(this.transformId);
        ActionMetaData updatedActionMetaData = currentActionMetaData != null ? new ActionMetaData.Builder(currentActionMetaData).actionProperties(new ActionProperties(null, null, null, null, null, transformActionProperties)).build() : null;
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(updatedActionMetaData).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String transformId, String index) {
        return "Failed to create the transform job [" + transformId + "] [index=" + index + "]";
    }

    public static String getTransformJobAlreadyExistsMessage(String transformId, String index) {
        return "Transform job [" + transformId + "] already exists, skipping creation [index=" + index + "]";
    }

    public static String getFailedToStartMessage(String transformId, String index) {
        return "Failed to start the transform job [" + transformId + "] [index=" + index + "]";
    }

    public static String getSuccessMessage(String transformId, String index) {
        return "Successfully created the transform job [" + transformId + "] [index=" + index + "]";
    }

    public static String getSuccessRestartMessage(String transformId, String index) {
        return "Successfully restarted the transform job [" + transformId + "] [index=" + index + "]";
    }
}

