/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.transform;

import io.lucenia.indexmanagement.transform.action.explain.ExplainTransformAction;
import io.lucenia.indexmanagement.transform.action.explain.ExplainTransformRequest;
import io.lucenia.indexmanagement.transform.model.ExplainTransform;
import io.lucenia.indexmanagement.transform.model.TransformMetadata;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaitForTransformCompletionStep
extends Step {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private Map<String, Object> info = null;
    public static final String name = "wait_for_transform_completion";
    public static final String JOB_STOPPED_MESSAGE = "Transform job was stopped";
    private CompletableFuture<Step> future;

    public WaitForTransformCompletionStep() {
        super(name);
    }

    public CompletableFuture<Step> execute() {
        String transformJobId;
        this.future = new CompletableFuture();
        StepContext context = this.getContext();
        if (context == null) {
            this.future.complete(this);
            return this.future;
        }
        String indexName = context.getMetadata().getIndex();
        ManagedIndexMetaData managedIndexMetadata = context.getMetadata();
        String string = transformJobId = managedIndexMetadata.getActionMetaData() != null && managedIndexMetadata.getActionMetaData().getActionProperties() != null && managedIndexMetadata.getActionMetaData().getActionProperties().getTransformActionProperties() != null ? managedIndexMetadata.getActionMetaData().getActionProperties().getTransformActionProperties().getTransformId() : null;
        if (transformJobId == null) {
            this.logger.error("No transform job id passed down.");
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = Map.of("message", WaitForTransformCompletionStep.getMissingTransformJobMessage(indexName));
            this.future.complete(this);
            return this.future;
        }
        this.explainTransformJob(transformJobId, indexName, context);
        return this.future;
    }

    private void explainTransformJob(String transformJobId, String indexName, StepContext context) {
        ExplainTransformRequest explainTransformRequest = new ExplainTransformRequest(Collections.singletonList(transformJobId));
        context.getClient().execute((ActionType)ExplainTransformAction.INSTANCE, (ActionRequest)explainTransformRequest, ActionListener.wrap(response -> {
            this.logger.info("Received the status for jobs [" + String.valueOf(response.getIdsToExplain().keySet()) + "]");
            ExplainTransform explainTransform = response.getIdsToExplain().get(transformJobId);
            if (explainTransform == null) {
                this.logger.warn("Job " + transformJobId + " is not found, mark step as COMPLETED.");
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", WaitForTransformCompletionStep.getJobNotFoundMessage(transformJobId, indexName));
                this.future.complete(this);
                return;
            }
            if (explainTransform.getMetadata() == null || explainTransform.getMetadata().getStatus() == null) {
                this.logger.warn("Job " + transformJobId + " has not started yet");
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = Map.of("message", WaitForTransformCompletionStep.getJobProcessingMessage(transformJobId, indexName));
                this.future.complete(this);
                return;
            }
            this.processTransformMetadataStatus(transformJobId, indexName, explainTransform.getMetadata());
            this.future.complete(this);
        }, e -> {
            if (e instanceof RemoteTransportException) {
                this.processFailure(transformJobId, indexName, (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            } else {
                this.processFailure(transformJobId, indexName, (Exception)e);
            }
            this.future.complete(this);
        }));
    }

    public void processTransformMetadataStatus(String transformJobId, String indexName, TransformMetadata transformMetadata) {
        switch (transformMetadata.getStatus()) {
            case INIT: 
            case STARTED: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = Map.of("message", WaitForTransformCompletionStep.getJobProcessingMessage(transformJobId, indexName));
                break;
            }
            case FAILED: {
                this.stepStatus = Step.StepStatus.FAILED;
                HashMap<String, Object> failedInfo = new HashMap<String, Object>();
                failedInfo.put("message", WaitForTransformCompletionStep.getJobFailedMessage(transformJobId, indexName));
                failedInfo.put("cause", transformMetadata.getFailureReason() != null ? transformMetadata.getFailureReason() : "");
                this.info = failedInfo;
                break;
            }
            case FINISHED: {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = Map.of("message", WaitForTransformCompletionStep.getJobCompletionMessage(transformJobId, indexName));
                break;
            }
            case STOPPED: {
                this.stepStatus = Step.StepStatus.FAILED;
                HashMap<String, Object> stoppedInfo = new HashMap<String, Object>();
                stoppedInfo.put("message", WaitForTransformCompletionStep.getJobFailedMessage(transformJobId, indexName));
                stoppedInfo.put("cause", JOB_STOPPED_MESSAGE);
                this.info = stoppedInfo;
            }
        }
    }

    public void processFailure(String transformJobId, String indexName, Exception e) {
        this.stepStatus = Step.StepStatus.FAILED;
        String message = WaitForTransformCompletionStep.getFailedMessage(transformJobId, indexName);
        this.logger.error(message, (Throwable)e);
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = mutableInfo;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(currentMetadata.getActionMetaData()).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(null).info(this.info).build();
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String transformJob, String index) {
        return "Failed to get the status of transform job [" + transformJob + "] [index=" + index + "]";
    }

    public static String getJobProcessingMessage(String transformJob, String index) {
        return "Transform job [" + transformJob + "] is still processing [index=" + index + "]";
    }

    public static String getJobCompletionMessage(String transformJob, String index) {
        return "Transform job [" + transformJob + "] completed [index=" + index + "]";
    }

    public static String getJobFailedMessage(String transformJob, String index) {
        return "Transform job [" + transformJob + "] failed [index=" + index + "]";
    }

    public static String getMissingTransformJobMessage(String index) {
        return "Transform job was not found [index=" + index + "]";
    }

    public static String getJobNotFoundMessage(String transformJob, String index) {
        return "Transform job [" + transformJob + "] is not found [index=" + index + "]";
    }
}

