/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.step.transition;

import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.action.TransitionsAction;
import io.lucenia.indexmanagement.indexstatemanagement.model.Transition;
import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.StepContext;
import io.skylite.indexmanagement.model.StepMetaData;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttemptTransitionStep
extends Step {
    private final TransitionsAction action;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private String stateName = null;
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    private boolean policyCompleted = false;
    private Map<String, Object> info = null;
    public static final String name = "attempt_transition_step";

    public AttemptTransitionStep(TransitionsAction action) {
        super(name);
        this.action = action;
    }

    public CompletableFuture<Step> execute() {
        CompletableFuture<Step> future = new CompletableFuture<Step>();
        StepContext context = this.getContext();
        if (context == null) {
            future.complete(this);
            return future;
        }
        String indexName = context.getMetadata().getIndex();
        ClusterService clusterService = context.getClusterService();
        List<Transition> transitions = this.action.getTransitions();
        IndexMetadataProvider indexMetadataProvider = this.action.getIndexMetadataProvider();
        try {
            if (transitions.isEmpty()) {
                this.logger.info(indexName + " transitions are empty, completing policy");
                this.policyCompleted = true;
                this.stepStatus = Step.StepStatus.COMPLETED;
                future.complete(this);
                return future;
            }
            Metadata metadata = clusterService.state().metadata();
            IndexMetadata indexMetadata = metadata.index(indexName);
            boolean inCluster = metadata.hasIndex(indexName) && indexMetadata != null && indexMetadata.getIndexUUID().equals(context.getMetadata().getIndexUuid());
            long indexCreationDate = this.getIndexCreationDate(context.getMetadata(), indexMetadataProvider, clusterService, indexName, inCluster);
            Instant indexCreationDateInstant = Instant.ofEpochMilli(indexCreationDate);
            if (indexCreationDate == -1L) {
                this.logger.warn(indexName + " had an indexCreationDate=-1L, cannot use for comparison");
            }
            Instant stepStartTime = this.getStepStartTime(context.getMetadata());
            Instant rolloverDate = inCluster ? ISMIndexMetadataExtensions.getOldestRolloverTime(indexMetadata) : null;
            boolean hasRolloverAgeCondition = transitions.stream().anyMatch(t -> t.getConditions() != null && t.getConditions().getRolloverAge() != null);
            if (hasRolloverAgeCondition && rolloverDate == null) {
                String message = AttemptTransitionStep.getFailedRolloverDateMessage(indexName);
                this.logger.warn(message);
                this.stepStatus = Step.StepStatus.FAILED;
                this.info = Map.of("message", message);
                future.complete(this);
                return future;
            }
            boolean hasStatsConditions = transitions.stream().anyMatch(ManagedIndexUtils::hasStatsConditions);
            if (hasStatsConditions && inCluster) {
                IndicesStatsRequest statsRequest = ((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{indexName})).clear().docs(true);
                context.getClient().admin().indices().stats(statsRequest, ActionListener.wrap(statsResponse -> this.processStatsResponse((IndicesStatsResponse)statsResponse, indexName, transitions, indexCreationDateInstant, stepStartTime, rolloverDate, indexMetadata, context, future), e -> {
                    if (e instanceof RemoteTransportException) {
                        this.handleException(indexName, (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    } else {
                        this.handleException(indexName, (Exception)e);
                    }
                    future.complete(this);
                }));
            } else {
                if (hasStatsConditions && !inCluster) {
                    this.logger.warn("Cannot use index size/doc count transition conditions for index [" + indexName + "] that does not exist in cluster");
                }
                this.evaluateTransitions(transitions, indexCreationDateInstant, null, null, stepStartTime, rolloverDate, indexMetadata, context, indexName);
                future.complete(this);
            }
        }
        catch (Exception e2) {
            this.handleException(indexName, e2);
            future.complete(this);
        }
        return future;
    }

    private void processStatsResponse(IndicesStatsResponse statsResponse, String indexName, List<Transition> transitions, Instant indexCreationDateInstant, Instant stepStartTime, Instant rolloverDate, IndexMetadata indexMetadata, StepContext context, CompletableFuture<Step> future) {
        if (statsResponse.getStatus() != RestStatus.OK) {
            String message = AttemptTransitionStep.getFailedStatsMessage(indexName);
            this.logger.warn(message + " - " + String.valueOf(statsResponse.getStatus()));
            this.stepStatus = Step.StepStatus.FAILED;
            HashMap<String, Object> failureInfo = new HashMap<String, Object>();
            failureInfo.put("message", message);
            List shardFailures = Arrays.stream(statsResponse.getShardFailures()).map(LuceniaExtensions::getUsefulCauseString).collect(Collectors.toList());
            failureInfo.put("shard_failures", shardFailures);
            this.info = failureInfo;
            future.complete(this);
            return;
        }
        Long numDocs = statsResponse.getPrimaries().getDocs() != null ? statsResponse.getPrimaries().getDocs().getCount() : 0L;
        ByteSizeValue indexSize = new ByteSizeValue(statsResponse.getPrimaries().getDocs() != null ? statsResponse.getPrimaries().getDocs().getTotalSizeInBytes() : 0L);
        this.evaluateTransitions(transitions, indexCreationDateInstant, numDocs, indexSize, stepStartTime, rolloverDate, indexMetadata, context, indexName);
        future.complete(this);
    }

    private void evaluateTransitions(List<Transition> transitions, Instant indexCreationDate, Long numDocs, ByteSizeValue indexSize, Instant stepStartTime, Instant rolloverDate, IndexMetadata indexMetadata, StepContext context, String indexName) {
        String message;
        int indexAliasesCount = indexMetadata != null ? indexMetadata.getAliases().size() : 0;
        Instant stateStartInstant = null;
        if (context.getMetadata().getStateMetaData() != null) {
            stateStartInstant = Instant.ofEpochMilli(context.getMetadata().getStateMetaData().getStartTime());
        }
        ManagedIndexUtils.TransitionConditionContext conditionContext = new ManagedIndexUtils.TransitionConditionContext(indexCreationDate, numDocs, indexSize, stepStartTime, rolloverDate, indexAliasesCount, stateStartInstant);
        this.stateName = transitions.stream().filter(t -> ManagedIndexUtils.evaluateConditions(t, conditionContext)).map(Transition::getStateName).findFirst().orElse(null);
        if (this.stateName != null) {
            this.logger.info(indexName + " transition conditions evaluated to true [indexCreationDate=" + String.valueOf(indexCreationDate) + ", numDocs=" + numDocs + ", indexSize=" + (indexSize != null ? Long.valueOf(indexSize.getBytes()) : null) + ", stepStartTime=" + stepStartTime.toEpochMilli() + "]");
            this.stepStatus = Step.StepStatus.COMPLETED;
            message = AttemptTransitionStep.getSuccessMessage(indexName, this.stateName);
        } else {
            this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
            message = AttemptTransitionStep.getEvaluatingMessage(indexName);
        }
        this.info = Map.of("message", message);
    }

    private void handleException(String indexName, Exception e) {
        String message = AttemptTransitionStep.getFailedMessage(indexName);
        this.logger.error(message, (Throwable)e);
        this.stepStatus = Step.StepStatus.FAILED;
        HashMap<String, Object> mutableInfo = new HashMap<String, Object>();
        mutableInfo.put("message", message);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = mutableInfo;
    }

    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(ManagedIndexMetaData currentMetadata) {
        return new ManagedIndexMetaData.Builder(currentMetadata).actionMetaData(currentMetadata.getActionMetaData()).stepMetaData(new StepMetaData(name, this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus)).transitionTo(this.stateName).info(this.info).policyCompleted(Boolean.valueOf(this.policyCompleted)).build();
    }

    private long getIndexCreationDate(ManagedIndexMetaData metadata, IndexMetadataProvider indexMetadataProvider, ClusterService clusterService, String indexName, boolean inCluster) {
        try {
            if (metadata.getIndexCreationDate() != null) {
                return metadata.getIndexCreationDate();
            }
            if (inCluster) {
                Metadata clusterStateMetadata = clusterService.state().metadata();
                if (clusterStateMetadata.hasIndex(indexName)) {
                    return clusterStateMetadata.index(indexName).getCreationDate();
                }
                return -1L;
            }
            List<String> nonDefaultIndexTypes = indexMetadataProvider.getServices().keySet().stream().filter(type -> !type.equals("_default")).collect(Collectors.toList());
            Map<String, Map<String, ISMIndexMetadata>> multiTypeIndexNameToMetaData = indexMetadataProvider.getMultiTypeISMIndexMetadata(nonDefaultIndexTypes, List.of(indexName)).join();
            for (Map<String, ISMIndexMetadata> indexMetadataMap : multiTypeIndexNameToMetaData.values()) {
                Long creationDate;
                ISMIndexMetadata ismIndexMetadata = indexMetadataMap.get(indexName);
                if (ismIndexMetadata == null || !metadata.getIndexUuid().equals(ismIndexMetadata.getIndexUuid()) || (creationDate = Long.valueOf(ismIndexMetadata.getIndexCreationDate())) == null) continue;
                return creationDate;
            }
            return -1L;
        }
        catch (Exception e) {
            this.logger.error("Failed to get index creation date for " + indexName, (Throwable)e);
            return -1L;
        }
    }

    public boolean isIdempotent() {
        return true;
    }

    public static String getFailedMessage(String index) {
        return "Failed to transition index [index=" + index + "]";
    }

    public static String getFailedStatsMessage(String index) {
        return "Failed to get stats information for the index [index=" + index + "]";
    }

    public static String getFailedRolloverDateMessage(String index) {
        return "Failed to transition index as min_rollover_age condition was used, but the index has never been rolled over [index=" + index + "]";
    }

    public static String getEvaluatingMessage(String index) {
        return "Evaluating transition conditions [index=" + index + "]";
    }

    public static String getSuccessMessage(String index, String state) {
        return "Transitioning to " + state + " [index=" + index + "]";
    }
}

