/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.addpolicy;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.List;

public class AddPolicyRequest
extends ActionRequest {
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot add policy to more than one index name/pattern when using a custom index type";
    private final List<String> indices;
    private final String policyID;
    private final String indexType;

    public AddPolicyRequest(List<String> indices, String policyID, String indexType) {
        this.indices = indices;
        this.policyID = policyID;
        this.indexType = indexType;
    }

    public AddPolicyRequest(StreamInput in) throws IOException {
        this.indices = in.readStringList();
        this.policyID = in.readString();
        this.indexType = in.readString();
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing indices", validationException);
        } else if (!this.indexType.equals("_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indices);
        out.writeString(this.policyID);
        out.writeString(this.indexType);
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public String getIndexType() {
        return this.indexType;
    }
}

