/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.addpolicy;

import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.addpolicy.AddPolicyRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.luceniaapi.IndexManagementSecurityContext;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.SkyliteStatusException;
import io.skylite.SkyliteTimeoutException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportAddPolicyAction
extends HandledTransportAction<AddPolicyRequest, ISMStatusResponse> {
    private static final Logger log = LogManager.getLogger(TransportAddPolicyAction.class);
    public static final long ADD_POLICY_TIMEOUT_IN_MILLIS = 30000L;
    private final NodeClient client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndexMetadataProvider indexMetadataProvider;
    private volatile int jobInterval;
    private volatile Double jobJitter;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportAddPolicyAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, IndexMetadataProvider indexMetadataProvider) {
        super("cluster:admin/lucenia/ism/managedindex/add", transportService, actionFilters, AddPolicyRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexMetadataProvider = indexMetadataProvider;
        this.jobInterval = (Integer)ManagedIndexSettings.JOB_INTERVAL.get(settings);
        this.jobJitter = (Double)ManagedIndexSettings.JITTER.get(settings);
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.JOB_INTERVAL, it -> {
            this.jobInterval = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.JITTER, it -> {
            this.jobJitter = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, AddPolicyRequest request, ActionListener<ISMStatusResponse> listener) {
        AddPolicyHandler handler = new AddPolicyHandler(this.client, listener, request);
        handler.start();
    }

    class AddPolicyHandler {
        private final NodeClient client;
        private final ActionListener<ISMStatusResponse> actionListener;
        private final AddPolicyRequest request;
        private final User user;
        private final Map<String, String> indicesToAdd;
        private final List<RestHandlerUtils.FailedIndex> failedIndices;
        private Instant startTime;
        private Policy policy;

        AddPolicyHandler(NodeClient client, ActionListener<ISMStatusResponse> listener, AddPolicyRequest request) {
            this.client = client;
            this.actionListener = listener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
            this.indicesToAdd = new HashMap<String, String>();
            this.failedIndices = new ArrayList<RestHandlerUtils.FailedIndex>();
        }

        void start() {
            log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            if (!SecurityUtils.validateUserConfiguration(this.user, TransportAddPolicyAction.this.filterByEnabled, this.actionListener)) {
                return;
            }
            this.getClusterState();
        }

        void getClusterState() {
            HashMap<String, ISMIndexMetadata> indexNameToMetadata;
            this.startTime = Instant.now();
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                indexNameToMetadata = new HashMap<String, ISMIndexMetadata>(TransportAddPolicyAction.this.indexMetadataProvider.getISMIndexMetadataByType(this.request.getIndexType(), this.request.getIndices()).get());
            }
            catch (Exception e) {
                this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                return;
            }
            log.info("[UUID TRACKING] TransportAddPolicyAction received metadata for {} indices from IndexMetadataProvider", (Object)indexNameToMetadata.size());
            for (Map.Entry entry : indexNameToMetadata.entrySet()) {
                String indexName = (String)entry.getKey();
                ISMIndexMetadata indexMetadata = (ISMIndexMetadata)entry.getValue();
                String uuid = indexMetadata.getIndexUuid();
                log.info("[UUID TRACKING] IndexMetadataProvider returned: index='{}', UUID='{}'", (Object)indexName, (Object)uuid);
                this.indicesToAdd.putIfAbsent(uuid, indexName);
            }
            if (this.indicesToAdd.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return;
            }
            if (this.user != null) {
                try (IndexManagementSecurityContext securityContext = new IndexManagementSecurityContext("AddPolicyHandler", TransportAddPolicyAction.this.settings, this.client.threadPool().getThreadContext(), this.user);){
                    this.validateIndexPermissions(new ArrayList<String>(this.indicesToAdd.values()));
                }
                catch (Exception e) {
                    this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    return;
                }
            }
            this.removeClosedIndices();
        }

        void validateIndexPermissions(List<String> indices) {
            ArrayList permittedIndices = new ArrayList();
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (String index : indices) {
                ManagedIndexRequest managedIndexRequest = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(new String[]{index});
                CompletionStage future = ((CompletableFuture)LuceniaExtensions.suspendUntil(this.client, (c, listener) -> c.execute((ActionType)ManagedIndexAction.INSTANCE, (ActionRequest)managedIndexRequest, listener)).thenAccept(response -> permittedIndices.add(index))).exceptionally(e -> {
                    Throwable cause;
                    Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
                    if (cause instanceof SkyliteSecurityException) {
                        log.debug("No permissions for index [{}]", (Object)index);
                    }
                    return null;
                });
                futures.add(future);
            }
            ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
                if (permittedIndices.isEmpty()) {
                    this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                    return;
                }
                this.indicesToAdd.values().removeIf(it -> !permittedIndices.contains(it));
                this.removeClosedIndices();
            })).exceptionally(e -> {
                this.actionListener.onFailure(new Exception("Failed to validate index permissions", (Throwable)e));
                return null;
            });
        }

        void removeClosedIndices() {
            if (this.request.getIndexType().equals("_default")) {
                IndicesOptions strictExpandOptions = IndicesOptions.strictExpand();
                ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(this.indicesToAdd.values().toArray(new String[0])).metadata(true).local(false)).waitForTimeout(TimeValue.timeValueMillis((long)30000L)).indicesOptions(strictExpandOptions);
                try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                    this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

                        public void onResponse(ClusterStateResponse response) {
                            DefaultIndexMetadataService defaultIndexMetadataService = (DefaultIndexMetadataService)TransportAddPolicyAction.this.indexMetadataProvider.getServices().get("_default");
                            List<String> closedIndexUuids = ISMIndexMetadataExtensions.getUuidsForClosedIndices(response.getState(), defaultIndexMetadataService);
                            for (String uuid : closedIndexUuids) {
                                String indexName = AddPolicyHandler.this.indicesToAdd.get(uuid);
                                if (indexName == null) continue;
                                AddPolicyHandler.this.failedIndices.add(new RestHandlerUtils.FailedIndex(indexName, uuid, "This index is closed"));
                                AddPolicyHandler.this.indicesToAdd.remove(uuid);
                            }
                            AddPolicyHandler.this.getPolicy();
                        }

                        public void onFailure(Exception t) {
                            AddPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                        }
                    });
                }
            } else {
                this.getPolicy();
            }
        }

        void getPolicy() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getPolicyID());
            if (!SecurityUtils.validateUserConfiguration(this.user, TransportAddPolicyAction.this.filterByEnabled, this.actionListener)) {
                return;
            }
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                this.client.get(getRequest, ActionListener.wrap(this::onGetPolicyResponse, this::onFailure));
            }
        }

        void onGetPolicyResponse(GetResponse response) throws IOException {
            if (!response.isExists() || response.isSourceEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Could not find policy=" + this.request.getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                this.policy = LuceniaExtensions.parseFromGetResponse(response, TransportAddPolicyAction.this.xContentRegistry, Policy::parse);
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Could not find policy=" + this.request.getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            if (!SecurityUtils.userHasPermissionForResource(this.user, this.policy.getUser(), TransportAddPolicyAction.this.filterByEnabled, "policy", this.request.getPolicyID(), this.actionListener)) {
                return;
            }
            IndexUtils.checkAndUpdateConfigIndexMapping(TransportAddPolicyAction.this.clusterService.state(), this.client.admin().indices(), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(this::onUpdateMapping, this::onFailure));
        }

        void onUpdateMapping(AcknowledgedResponse response) {
            if (response.isAcknowledged()) {
                log.info("Successfully created or updated {} with newest mappings.", (Object)".opendistro-ism-config");
                this.getExistingManagedIndices();
            } else {
                log.error("Unable to create or update {} with newest mapping.", (Object)".opendistro-ism-config");
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        void getExistingManagedIndices() {
            this.indicesToAdd.entrySet().removeIf(entry -> {
                String uuid = (String)entry.getKey();
                String indexName = (String)entry.getValue();
                boolean shouldRemove = TransportAddPolicyAction.this.indexMetadataProvider.isUnManageableIndex(indexName);
                if (shouldRemove) {
                    this.failedIndices.add(new RestHandlerUtils.FailedIndex(indexName, uuid, "Matches restricted index pattern defined in the cluster setting"));
                }
                return shouldRemove;
            });
            if (this.indicesToAdd.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return;
            }
            MultiGetRequest multiGetReq = new MultiGetRequest();
            for (String uuid : this.indicesToAdd.keySet()) {
                multiGetReq.add(".opendistro-ism-config", uuid);
            }
            this.client.multiGet(multiGetReq, (ActionListener)new ActionListener<MultiGetResponse>(){

                public void onResponse(MultiGetResponse response) {
                    for (MultiGetItemResponse item : response.getResponses()) {
                        String docId;
                        String indexName;
                        if (!item.getResponse().isExists() || (indexName = AddPolicyHandler.this.indicesToAdd.get(docId = item.getId())) == null) continue;
                        AddPolicyHandler.this.failedIndices.add(new RestHandlerUtils.FailedIndex(indexName, docId, "This index already has a policy, use the update policy API to update index policies"));
                        AddPolicyHandler.this.indicesToAdd.remove(docId);
                    }
                    AddPolicyHandler.this.createManagedIndices();
                }

                public void onFailure(Exception t) {
                    AddPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        void createManagedIndices() {
            if (!this.indicesToAdd.isEmpty()) {
                Duration timeSinceClusterStateRequest = Duration.between(this.startTime, Instant.now());
                long bulkReqTimeout = 30000L - timeSinceClusterStateRequest.toMillis();
                if (bulkReqTimeout < 0L) {
                    this.actionListener.onFailure((Exception)new SkyliteTimeoutException("Add policy API timed out after ClusterStateResponse", new Object[0]));
                    return;
                }
                BulkRequest bulkReq = new BulkRequest().timeout(TimeValue.timeValueMillis((long)bulkReqTimeout));
                log.info("[UUID TRACKING] TransportAddPolicyAction creating ManagedIndexConfig documents for {} indices", (Object)this.indicesToAdd.size());
                for (Map.Entry<String, String> entry : this.indicesToAdd.entrySet()) {
                    String uuid = entry.getKey();
                    String name = entry.getValue();
                    log.info("[UUID TRACKING] Creating ManagedIndexConfig for index '{}' with UUID '{}', policyID '{}'", (Object)name, (Object)uuid, (Object)this.request.getPolicyID());
                    Policy policyWithUser = new Policy.Builder(this.policy).user(this.user).build();
                    bulkReq.add(ManagedIndexUtils.managedIndexConfigIndexRequest(name, uuid, this.request.getPolicyID(), TransportAddPolicyAction.this.jobInterval, policyWithUser, TransportAddPolicyAction.this.jobJitter));
                }
                this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(){

                    public void onResponse(BulkResponse response) {
                        for (BulkItemResponse item : response.getItems()) {
                            String indexName;
                            String docId = item.getId();
                            if (!item.isFailed() || (indexName = AddPolicyHandler.this.indicesToAdd.get(docId)) == null) continue;
                            AddPolicyHandler.this.failedIndices.add(new RestHandlerUtils.FailedIndex(indexName, docId, "Failed to add policy due to: " + item.getFailureMessage()));
                            AddPolicyHandler.this.indicesToAdd.remove(docId);
                        }
                        AddPolicyHandler.this.actionListener.onResponse((Object)new ISMStatusResponse(AddPolicyHandler.this.indicesToAdd.size(), AddPolicyHandler.this.failedIndices));
                        List<Index> indices = AddPolicyHandler.this.indicesToAdd.entrySet().stream().map(e -> new Index((String)e.getValue(), (String)e.getKey())).collect(Collectors.toList());
                        AddPolicyHandler.this.removeMetadatas(indices);
                    }

                    public void onFailure(Exception t) {
                        if (t instanceof ClusterBlockException) {
                            for (Map.Entry<String, String> entry : AddPolicyHandler.this.indicesToAdd.entrySet()) {
                                AddPolicyHandler.this.failedIndices.add(new RestHandlerUtils.FailedIndex(entry.getValue(), entry.getKey(), "Failed to add policy due to ClusterBlockingException: " + t.getMessage()));
                            }
                            AddPolicyHandler.this.actionListener.onResponse((Object)new ISMStatusResponse(0, AddPolicyHandler.this.failedIndices));
                        } else {
                            AddPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                        }
                    }
                });
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        void onFailure(Exception t) {
            this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
        }

        void removeMetadatas(final List<Index> indices) {
            BulkRequest bulkReq = new BulkRequest();
            for (Index index : indices) {
                bulkReq.add(ManagedIndexUtils.deleteManagedIndexMetadataRequest(index.getUUID()));
            }
            this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(this){

                public void onResponse(BulkResponse response) {
                    log.debug("Successfully cleaned metadata for remove policy indices: {}", (Object)indices);
                }

                public void onFailure(Exception e) {
                    log.error("Failed to clean metadata for remove policy indices.", (Throwable)e);
                }
            });
        }
    }
}

