/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.changepolicy;

import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.List;

public class ChangePolicyRequest
extends ActionRequest {
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot change policy on more than one index name/pattern when using a custom index type";
    private final List<String> indices;
    private final ChangePolicy changePolicy;
    private final String indexType;

    public ChangePolicyRequest(List<String> indices, ChangePolicy changePolicy, String indexType) {
        this.indices = indices;
        this.changePolicy = changePolicy;
        this.indexType = indexType;
    }

    public ChangePolicyRequest(StreamInput in) throws IOException {
        this.indices = in.readStringList();
        this.changePolicy = new ChangePolicy(in);
        this.indexType = in.readString();
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing indices", validationException);
        } else if (!this.indexType.equals("_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indices);
        this.changePolicy.writeTo(out);
        out.writeString(this.indexType);
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public ChangePolicy getChangePolicy() {
        return this.changePolicy;
    }

    public String getIndexType() {
        return this.indexType;
    }
}

