/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.changepolicy;

import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.model.StateFilter;
import io.lucenia.indexmanagement.indexstatemanagement.model.coordinator.SweptManagedIndexConfig;
import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.changepolicy.ChangePolicyRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.IndexManagementException;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportChangePolicyAction
extends HandledTransportAction<ChangePolicyRequest, ISMStatusResponse> {
    private static final Logger log = LogManager.getLogger(TransportChangePolicyAction.class);
    private final NodeClient client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final IndexMetadataProvider indexMetadataProvider;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportChangePolicyAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry, IndexMetadataProvider indexMetadataProvider) {
        super("cluster:admin/lucenia/ism/managedindex/change", transportService, actionFilters, ChangePolicyRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.indexMetadataProvider = indexMetadataProvider;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, ChangePolicyRequest request, ActionListener<ISMStatusResponse> listener) {
        ChangePolicyHandler handler = new ChangePolicyHandler(this.client, listener, request);
        handler.start();
    }

    class ChangePolicyHandler {
        private final NodeClient client;
        private final ActionListener<ISMStatusResponse> actionListener;
        private final ChangePolicyRequest request;
        private final User user;
        private final List<RestHandlerUtils.FailedIndex> failedIndices = new ArrayList<RestHandlerUtils.FailedIndex>();
        private final List<IndexPair> managedIndicesToUpdate = new ArrayList<IndexPair>();
        private final Map<String, String> indexUuidToCurrentState = new HashMap<String, String>();
        private final Map<String, String> indicesToUpdate = new HashMap<String, String>();
        private final Map<String, IndexMetadata> indexUuidToIndexMetadata = new HashMap<String, IndexMetadata>();
        private final ChangePolicy changePolicy;
        private Policy policy;
        private int updated = 0;

        ChangePolicyHandler(NodeClient client, ActionListener<ISMStatusResponse> actionListener, ChangePolicyRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
            this.changePolicy = request.getChangePolicy();
        }

        void start() {
            log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            if (this.user == null) {
                this.getPolicy();
            } else {
                this.validateAndGetPolicy();
            }
        }

        private void validateAndGetPolicy() {
            ManagedIndexRequest managedIndexRequest = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(this.request.getIndices().toArray(new String[0]));
            this.client.execute((ActionType)ManagedIndexAction.INSTANCE, (ActionRequest)managedIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    ChangePolicyHandler.this.getPolicy();
                }

                public void onFailure(Exception e) {
                    ChangePolicyHandler.this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap((Exception)(e instanceof SkyliteSecurityException ? new SkyliteStatusException("User doesn't have required index permissions on one or more requested indices: " + e.getLocalizedMessage(), RestStatus.FORBIDDEN, new Object[0]) : e))));
                }
            });
        }

        private void getPolicy() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.changePolicy.getPolicyID());
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                if (!SecurityUtils.validateUserConfiguration(this.user, TransportChangePolicyAction.this.filterByEnabled, this.actionListener)) {
                    return;
                }
                this.client.get(getRequest, ActionListenerHelper.wrap(this::onGetPolicyResponse, this::onFailure));
            }
        }

        private void onGetPolicyResponse(GetResponse response) {
            if (!response.isExists() || response.isSourceEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Could not find policy=" + this.request.getChangePolicy().getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                this.policy = LuceniaExtensions.parseFromGetResponse(response, TransportChangePolicyAction.this.xContentRegistry, Policy::parse);
            }
            catch (IOException | IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Could not find policy=" + this.request.getChangePolicy().getPolicyID(), RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            if (!SecurityUtils.userHasPermissionForResource(this.user, this.policy.getUser(), TransportChangePolicyAction.this.filterByEnabled, "policy", this.request.getChangePolicy().getPolicyID(), this.actionListener)) {
                return;
            }
            IndexUtils.checkAndUpdateConfigIndexMapping(TransportChangePolicyAction.this.clusterService.state(), this.client.admin().indices(), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(this::onUpdateMapping, this::onFailure));
        }

        private void onUpdateMapping(AcknowledgedResponse acknowledgedResponse) {
            if (!acknowledgedResponse.isAcknowledged()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Could not update .opendistro-ism-config with new mapping.", RestStatus.FAILED_DEPENDENCY, new Object[0])));
                return;
            }
            this.getIndicesToUpdate();
        }

        private void getIndicesToUpdate() {
            CompletableFuture.runAsync(() -> {
                HashMap<String, ISMIndexMetadata> indexNameToMetadata = new HashMap<String, ISMIndexMetadata>();
                try {
                    indexNameToMetadata.putAll(TransportChangePolicyAction.this.indexMetadataProvider.getISMIndexMetadataByType(this.request.getIndexType(), this.request.getIndices()).join());
                }
                catch (Exception e) {
                    this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    return;
                }
                for (Map.Entry entry : indexNameToMetadata.entrySet()) {
                    this.indicesToUpdate.putIfAbsent(((ISMIndexMetadata)entry.getValue()).getIndexUuid(), (String)entry.getKey());
                }
                if ("_default".equals(this.request.getIndexType())) {
                    this.getClusterState();
                } else {
                    this.getManagedIndexMetadata();
                }
            });
        }

        private void getClusterState() {
            IndicesOptions strictExpandOptions = IndicesOptions.strictExpand();
            ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(this.request.getIndices().toArray(new String[0])).metadata(true).local(false)).indicesOptions(strictExpandOptions);
            this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

                public void onResponse(ClusterStateResponse response) {
                    DefaultIndexMetadataService defaultService = (DefaultIndexMetadataService)TransportChangePolicyAction.this.indexMetadataProvider.getServices().get("_default");
                    for (Map.Entry entry : response.getState().metadata().indices().entrySet()) {
                        String indexUUID = defaultService.getIndexUUID((IndexMetadata)entry.getValue());
                        ChangePolicyHandler.this.indexUuidToIndexMetadata.put(indexUUID, (IndexMetadata)entry.getValue());
                    }
                    HashMap<String, String> filtered = new HashMap<String, String>();
                    for (Map.Entry<String, String> entry : ChangePolicyHandler.this.indicesToUpdate.entrySet()) {
                        if (!ChangePolicyHandler.this.indexUuidToIndexMetadata.containsKey(entry.getKey())) continue;
                        filtered.put(entry.getKey(), entry.getValue());
                    }
                    ChangePolicyHandler.this.indicesToUpdate.clear();
                    ChangePolicyHandler.this.indicesToUpdate.putAll(filtered);
                    ChangePolicyHandler.this.getManagedIndexMetadata();
                }

                public void onFailure(Exception t) {
                    ChangePolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        private void getManagedIndexMetadata() {
            ArrayList<String> indexUuids = new ArrayList<String>(this.indicesToUpdate.keySet());
            this.client.multiGet(ISMIndexMetadataExtensions.buildMgetMetadataRequest(indexUuids), ActionListener.wrap(this::onMgetMetadataResponse, this::onFailure));
        }

        private void onMgetMetadataResponse(MultiGetResponse mgetResponse) {
            Map<String, ISMIndexMetadataExtensions.Pair<ManagedIndexMetaData, Exception>> metadataMap = ISMIndexMetadataExtensions.mgetResponseToMap(mgetResponse);
            Set includedStates = this.changePolicy.getInclude().stream().map(StateFilter::getState).collect(Collectors.toSet());
            for (Map.Entry<String, String> entry : this.indicesToUpdate.entrySet()) {
                String currentState;
                String indexUuid = entry.getKey();
                String indexName = entry.getValue();
                ISMIndexMetadataExtensions.Pair<ManagedIndexMetaData, Exception> metadataPair = metadataMap.get(ManagedIndexUtils.managedIndexMetadataID(indexUuid));
                Exception mgetFailure = metadataPair != null ? metadataPair.getSecond() : null;
                ManagedIndexMetaData managedIndexMetadata = metadataPair != null ? metadataPair.getFirst() : null;
                String string = currentState = managedIndexMetadata != null && managedIndexMetadata.getStateMetaData() != null ? managedIndexMetadata.getStateMetaData().getName() : null;
                if (currentState != null) {
                    this.indexUuidToCurrentState.put(indexUuid, currentState);
                }
                if (mgetFailure != null) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "Failed to get managed index metadata, " + String.valueOf(mgetFailure)));
                    continue;
                }
                if (managedIndexMetadata != null && managedIndexMetadata.getTransitionTo() != null) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "Cannot change policy while transitioning to new state"));
                    continue;
                }
                if (managedIndexMetadata == null) {
                    this.managedIndicesToUpdate.add(new IndexPair(indexName, indexUuid));
                    continue;
                }
                if (includedStates.isEmpty()) {
                    this.managedIndicesToUpdate.add(new IndexPair(indexName, indexUuid));
                    continue;
                }
                if (managedIndexMetadata.getStateMetaData() != null && includedStates.contains(managedIndexMetadata.getStateMetaData().getName())) {
                    this.managedIndicesToUpdate.add(new IndexPair(indexName, indexUuid));
                    continue;
                }
                log.debug("Skipping {} as it does not match any of the include state filters", (Object)indexName);
            }
            if (this.managedIndicesToUpdate.isEmpty()) {
                this.updated = 0;
                this.actionListener.onResponse((Object)new ISMStatusResponse(this.updated, this.failedIndices));
            } else {
                String[] uuids = (String[])this.managedIndicesToUpdate.stream().map(IndexPair::getSecond).toArray(String[]::new);
                this.client.multiGet(this.mgetManagedIndexConfigRequest(uuids), ActionListener.wrap(this::onMultiGetResponse, this::onFailure));
            }
        }

        private void onMultiGetResponse(MultiGetResponse response) {
            HashSet<String> foundManagedIndices = new HashSet<String>();
            ArrayList<SweptManagedIndexConfig> sweptConfigs = new ArrayList<SweptManagedIndexConfig>();
            for (MultiGetItemResponse item : response.getResponses()) {
                if (!item.getResponse().isExists()) {
                    String indexUuid = item.getResponse().getId();
                    String indexName = this.managedIndicesToUpdate.stream().filter(pair -> pair.getSecond().equals(indexUuid)).map(IndexPair::getFirst).findFirst().orElse(null);
                    if (indexName != null) {
                        this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index is not being managed"));
                    }
                }
                if (item.isFailed() || item.getResponse().isSourceEmpty()) continue;
                foundManagedIndices.add(item.getResponse().getId());
                try {
                    SweptManagedIndexConfig config = LuceniaExtensions.parseWithType(LuceniaExtensions.contentParser(item.getResponse().getSourceAsBytesRef()), "", item.getResponse().getSeqNo(), item.getResponse().getPrimaryTerm(), SweptManagedIndexConfig::parse);
                    sweptConfigs.add(config);
                }
                catch (IOException e) {
                    log.error("Failed to parse SweptManagedIndexConfig", (Throwable)e);
                }
            }
            if (sweptConfigs.isEmpty()) {
                this.updated = 0;
                this.actionListener.onResponse((Object)new ISMStatusResponse(this.updated, this.failedIndices));
            } else {
                this.updateManagedIndexConfig(sweptConfigs);
            }
        }

        private void updateManagedIndexConfig(List<SweptManagedIndexConfig> sweptConfigs) {
            final HashMap<Integer, Index> mapOfItemIdToIndex = new HashMap<Integer, Index>();
            BulkRequest bulkUpdateManagedIndexRequest = new BulkRequest();
            for (int id = 0; id < sweptConfigs.size(); ++id) {
                SweptManagedIndexConfig sweptConfig = sweptConfigs.get(id);
                String currentStateName = this.indexUuidToCurrentState.get(sweptConfig.getUuid());
                boolean isSafe = sweptConfig.getPolicy() != null && ManagedIndexUtils.isSafeToChange(sweptConfig.getPolicy(), currentStateName, this.policy, this.changePolicy);
                ChangePolicy updatedChangePolicy = new ChangePolicy.Builder(this.changePolicy).isSafe(isSafe).user(this.user).build();
                SweptManagedIndexConfig updatedConfig = new SweptManagedIndexConfig.Builder(sweptConfig).changePolicy(updatedChangePolicy).build();
                bulkUpdateManagedIndexRequest.add(ManagedIndexUtils.updateManagedIndexRequest(updatedConfig));
                mapOfItemIdToIndex.put(id, new Index(sweptConfig.getIndex(), sweptConfig.getUuid()));
            }
            this.client.bulk(bulkUpdateManagedIndexRequest, (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse response) {
                    ChangePolicyHandler.this.onBulkResponse(response, mapOfItemIdToIndex);
                }

                public void onFailure(Exception t) {
                    ChangePolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        private void onBulkResponse(BulkResponse bulkResponse, Map<Integer, Index> mapOfItemIdToIndex) {
            ArrayList<BulkItemResponse> failedResponses = new ArrayList<BulkItemResponse>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedResponses.add(item);
            }
            for (BulkItemResponse failedResponse : failedResponses) {
                Index indexPair = mapOfItemIdToIndex.get(failedResponse.getItemId());
                if (indexPair == null) continue;
                this.failedIndices.add(new FailedIndex(indexPair.getName(), indexPair.getUUID(), failedResponse.getFailureMessage()));
            }
            this.updated = bulkResponse.getItems().length - failedResponses.size();
            this.actionListener.onResponse((Object)new ISMStatusResponse(this.updated, this.failedIndices));
        }

        private MultiGetRequest mgetManagedIndexConfigRequest(String[] managedIndexUuids) {
            MultiGetRequest request = new MultiGetRequest();
            String[] includes = new String[]{"managed_index.index", "managed_index.index_uuid", "managed_index.policy_id", "managed_index.policy", "managed_index.change_policy"};
            String[] excludes = new String[]{};
            FetchSourceContext fetchSourceContext = new FetchSourceContext(true, includes, excludes);
            for (String uuid : managedIndexUuids) {
                request.add(new MultiGetRequest.Item(".opendistro-ism-config", uuid).fetchSourceContext(fetchSourceContext).routing(uuid));
            }
            return request;
        }

        private void onFailure(Exception t) {
            this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
        }
    }

    static class IndexPair {
        private final String first;
        private final String second;

        IndexPair(String first, String second) {
            this.first = first;
            this.second = second;
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }
    }

    static class FailedIndex
    extends RestHandlerUtils.FailedIndex {
        public FailedIndex(String name, String uuid, String reason) {
            super(name, uuid, reason);
        }
    }
}

