/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.deletepolicy;

import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.deletepolicy.DeletePolicyRequest;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeletePolicyAction
extends HandledTransportAction<DeletePolicyRequest, DeleteResponse> {
    private static final Logger log = LogManager.getLogger(TransportDeletePolicyAction.class);
    private final NodeClient client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportDeletePolicyAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/ism/policy/delete", transportService, actionFilters, DeletePolicyRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, DeletePolicyRequest request, ActionListener<DeleteResponse> listener) {
        DeletePolicyHandler handler = new DeletePolicyHandler((Client)this.client, listener, request);
        handler.start();
    }

    class DeletePolicyHandler {
        private final Client client;
        private final ActionListener<DeleteResponse> actionListener;
        private final DeletePolicyRequest request;
        private final User user;

        DeletePolicyHandler(Client client, ActionListener<DeleteResponse> listener, DeletePolicyRequest request) {
            this.client = client;
            this.actionListener = listener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
        }

        void start() {
            log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                this.getPolicy();
            }
        }

        void getPolicy() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getPolicyID());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    Policy policy;
                    if (!response.isExists()) {
                        DeletePolicyHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Policy " + DeletePolicyHandler.this.request.getPolicyID() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        policy = LuceniaExtensions.parseFromGetResponse(response, TransportDeletePolicyAction.this.xContentRegistry, Policy::parse);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        DeletePolicyHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Policy " + DeletePolicyHandler.this.request.getPolicyID() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    if (!SecurityUtils.userHasPermissionForResource(DeletePolicyHandler.this.user, policy.getUser(), TransportDeletePolicyAction.this.filterByEnabled, "policy", DeletePolicyHandler.this.request.getPolicyID(), DeletePolicyHandler.this.actionListener)) {
                        return;
                    }
                    DeletePolicyHandler.this.delete();
                }

                public void onFailure(Exception t) {
                    DeletePolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        void delete() {
            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-ism-config", this.request.getPolicyID()).setRefreshPolicy(this.request.getRefreshPolicy());
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                this.client.delete(deleteRequest, this.actionListener);
            }
        }
    }
}

