/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.explain;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.indexstatemanagement.model.ExplainFilter;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.List;

public class ExplainRequest
extends ActionRequest {
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot call explain on more than one index name/pattern when using a custom index type";
    private final List<String> indices;
    private final boolean local;
    private final TimeValue clusterManagerTimeout;
    private final SearchParams searchParams;
    private final ExplainFilter explainFilter;
    private final boolean showPolicy;
    private final boolean validateAction;
    private final String indexType;

    public ExplainRequest(List<String> indices, boolean local, TimeValue clusterManagerTimeout, SearchParams searchParams, ExplainFilter explainFilter, boolean showPolicy, boolean validateAction, String indexType) {
        this.indices = indices;
        this.local = local;
        this.clusterManagerTimeout = clusterManagerTimeout;
        this.searchParams = searchParams;
        this.explainFilter = explainFilter;
        this.showPolicy = showPolicy;
        this.validateAction = validateAction;
        this.indexType = indexType;
    }

    public ExplainRequest(StreamInput in) throws IOException {
        this.indices = in.readStringList();
        this.local = in.readBoolean();
        this.clusterManagerTimeout = in.readTimeValue();
        this.searchParams = new SearchParams(in);
        this.explainFilter = (ExplainFilter)in.readOptionalWriteable(ExplainFilter::new);
        this.showPolicy = in.readBoolean();
        this.validateAction = in.readBoolean();
        this.indexType = in.readString();
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!this.indexType.equals("_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indices);
        out.writeBoolean(this.local);
        out.writeTimeValue(this.clusterManagerTimeout);
        this.searchParams.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.explainFilter);
        out.writeBoolean(this.showPolicy);
        out.writeBoolean(this.validateAction);
        out.writeString(this.indexType);
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public boolean isLocal() {
        return this.local;
    }

    public TimeValue getClusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    public SearchParams getSearchParams() {
        return this.searchParams;
    }

    public ExplainFilter getExplainFilter() {
        return this.explainFilter;
    }

    public boolean isShowPolicy() {
        return this.showPolicy;
    }

    public boolean isValidateAction() {
        return this.validateAction;
    }

    public String getIndexType() {
        return this.indexType;
    }
}

