/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.explain;

import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.lucenia.indexmanagement.indexstatemanagement.settings.LegacyOpenDistroManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.ValidationResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ExplainResponse
extends ActionResponse
implements ToXContentObject {
    private final List<String> indexNames;
    private final List<String> indexPolicyIDs;
    private final List<ManagedIndexMetaData> indexMetadatas;
    private final int totalManagedIndices;
    private final Map<String, Boolean> enabledState;
    private final Map<String, Policy> policies;
    private final List<ValidationResult> validationResults;

    public ExplainResponse(List<String> indexNames, List<String> indexPolicyIDs, List<ManagedIndexMetaData> indexMetadatas, int totalManagedIndices, Map<String, Boolean> enabledState, Map<String, Policy> policies, List<ValidationResult> validationResults) {
        this.indexNames = indexNames;
        this.indexPolicyIDs = indexPolicyIDs;
        this.indexMetadatas = indexMetadatas;
        this.totalManagedIndices = totalManagedIndices;
        this.enabledState = enabledState;
        this.policies = policies;
        this.validationResults = validationResults;
    }

    public ExplainResponse(StreamInput in) throws IOException {
        super(in);
        this.indexNames = in.readStringList();
        this.indexPolicyIDs = in.readStringList();
        this.indexMetadatas = in.readList(ManagedIndexMetaData::fromStreamInput);
        this.totalManagedIndices = in.readInt();
        this.enabledState = in.readMap(StreamInput::readString, StreamInput::readBoolean);
        this.policies = in.readMap(StreamInput::readString, Policy::new);
        this.validationResults = in.readList(ValidationResult::fromStreamInput);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indexNames);
        out.writeStringCollection(this.indexPolicyIDs);
        out.writeCollection(this.indexMetadatas);
        out.writeInt(this.totalManagedIndices);
        out.writeMap(this.enabledState, StreamOutput::writeString, StreamOutput::writeBoolean);
        out.writeMap(this.policies, StreamOutput::writeString, (o, policy) -> policy.writeTo(o));
        out.writeCollection(this.validationResults);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (int ind = 0; ind < this.indexNames.size(); ++ind) {
            String name = this.indexNames.get(ind);
            builder.startObject(name);
            builder.field(ManagedIndexSettings.POLICY_ID_SETTING.getKey(), this.indexPolicyIDs.get(ind));
            builder.field(LegacyOpenDistroManagedIndexSettings.POLICY_ID_SETTING.getKey(), this.indexPolicyIDs.get(ind));
            if (this.indexMetadatas.get(ind) != null) {
                this.indexMetadatas.get(ind).toXContent(builder, ToXContent.EMPTY_PARAMS);
            }
            builder.field("enabled", this.enabledState.get(name));
            Policy policy = this.policies.get(name);
            if (policy != null) {
                builder.field("policy", (ToXContent)policy, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITHOUT_TYPE_AND_USER);
            }
            if (this.validationResults.get(ind) != null) {
                ISMIndexMetadataExtensions.addObject(builder, "validate", (ToXContentFragment)this.validationResults.get(ind), params, true);
            }
            builder.endObject();
        }
        builder.field("total_managed_indices", this.totalManagedIndices);
        return builder.endObject();
    }

    public List<String> getIndexNames() {
        return this.indexNames;
    }

    public List<String> getIndexPolicyIDs() {
        return this.indexPolicyIDs;
    }

    public List<ManagedIndexMetaData> getIndexMetadatas() {
        return this.indexMetadatas;
    }

    public int getTotalManagedIndices() {
        return this.totalManagedIndices;
    }

    public Map<String, Boolean> getEnabledState() {
        return this.enabledState;
    }

    public Map<String, Policy> getPolicies() {
        return this.policies;
    }

    public List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }
}

