/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.explain;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.ManagedIndexRunner;
import io.lucenia.indexmanagement.indexstatemanagement.model.ExplainFilterUtil;
import io.lucenia.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.model.State;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.explain.ExplainRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.explain.ExplainResponse;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.Operator;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.ValidationResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class TransportExplainAction
extends HandledTransportAction<ExplainRequest, ExplainResponse> {
    private static final Logger log = LogManager.getLogger(TransportExplainAction.class);
    public static final String MANAGED_INDEX_NAME_KEYWORD_FIELD = "managed_index.name.keyword";
    public static final String MANAGED_INDEX_INDEX_UUID_FIELD = "managed_index.index_uuid";
    private final NodeClient client;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndexMetadataProvider indexMetadataProvider;

    @Inject
    public TransportExplainAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedXContentRegistry xContentRegistry, IndexMetadataProvider indexMetadataProvider) {
        super("cluster:admin/lucenia/ism/managedindex/explain", transportService, actionFilters, ExplainRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.indexMetadataProvider = indexMetadataProvider;
    }

    protected void doExecute(Task task, ExplainRequest request, ActionListener<ExplainResponse> listener) {
        ExplainHandler handler = new ExplainHandler(this.client, listener, request);
        handler.start();
    }

    class ExplainHandler {
        private final NodeClient client;
        private final ActionListener<ExplainResponse> actionListener;
        private final ExplainRequest request;
        private final User user;
        private final List<String> indices;
        private final boolean explainAll;
        private final boolean showPolicy;
        private final boolean validateAction;
        private final Map<String, Map<String, String>> managedIndicesMetaDataMap = new HashMap<String, Map<String, String>>();
        private final List<String> managedIndices = new ArrayList<String>();
        private final List<String> indexNames = new ArrayList<String>();
        private final Map<String, String> indexNamesToUUIDs = new HashMap<String, String>();
        private final Map<String, Boolean> enabledState = new HashMap<String, Boolean>();
        private final List<String> indexPolicyIDs = new ArrayList<String>();
        private final List<ManagedIndexMetaData> indexMetadatas = new ArrayList<ManagedIndexMetaData>();
        private final List<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        private int totalManagedIndices = 0;
        private final Map<String, Policy> appliedPolicies = new HashMap<String, Policy>();
        private final Map<String, Policy> policiesforValidation = new HashMap<String, Policy>();

        ExplainHandler(NodeClient client, ActionListener<ExplainResponse> actionListener, ExplainRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
            this.indices = request.getIndices();
            this.explainAll = this.indices.isEmpty();
            this.showPolicy = request.isShowPolicy();
            this.validateAction = request.isValidateAction();
        }

        void start() {
            log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            CompletableFuture.runAsync(() -> {
                HashMap<String, ISMIndexMetadata> indexNameToMetadata = new HashMap<String, ISMIndexMetadata>();
                try {
                    if (this.explainAll) {
                        indexNameToMetadata.putAll(TransportExplainAction.this.indexMetadataProvider.getAllISMIndexMetadataByType(this.request.getIndexType()).join());
                    } else {
                        indexNameToMetadata.putAll(TransportExplainAction.this.indexMetadataProvider.getISMIndexMetadataByType(this.request.getIndexType(), this.indices).join());
                    }
                }
                catch (Exception e) {
                    this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    return;
                }
                this.indexNames.addAll(indexNameToMetadata.keySet());
                for (Map.Entry entry : indexNameToMetadata.entrySet()) {
                    String indexName = (String)entry.getKey();
                    String indexUuid = ((ISMIndexMetadata)entry.getValue()).getIndexUuid();
                    this.indexNamesToUUIDs.put(indexName, indexUuid);
                }
                SearchParams params = this.request.getSearchParams();
                int searchSize = this.explainAll ? params.getSize() : 10000;
                SearchRequest searchRequest = this.getSearchMetadataRequest(params, new ArrayList<String>(this.indexNamesToUUIDs.values()), searchSize);
                this.searchForMetadata(searchRequest);
            });
        }

        private SearchRequest getSearchMetadataRequest(SearchParams params, List<String> indexUUIDs, int searchSize) {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.queryStringQuery((String)params.getQueryString()).field(TransportExplainAction.MANAGED_INDEX_NAME_KEYWORD_FIELD).defaultOperator(Operator.AND)).filter((QueryBuilder)QueryBuilders.termsQuery((String)TransportExplainAction.MANAGED_INDEX_INDEX_UUID_FIELD, indexUUIDs));
            ExplainFilterUtil.filterByPolicyID(queryBuilder, this.request.getExplainFilter());
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().from(params.getFrom()).fetchSource(FetchSourceContext.FETCH_SOURCE).seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).sort((BaseSortBuilder)params.getSortBuilder()).size(searchSize).query((QueryBuilder)queryBuilder);
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{".opendistro-ism-config"}).source(searchSourceBuilder).preference(Preference.PRIMARY_FIRST.type());
            log.info("Built search request for index: {} with routing: {}", (Object)".opendistro-ism-config", indexUUIDs);
            return searchRequest;
        }

        private void searchForMetadata(SearchRequest searchRequest) {
            log.info("searchForMetadata called, executing search on index: {}", (Object)".opendistro-ism-config");
            try (final ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        log.info("searchForMetadata onResponse - totalHits: {}, hits count: {}", (Object)response.getHits().getTotalHits(), (Object)response.getHits().getHits().length);
                        if (response.getHits().getTotalHits() != null) {
                            ExplainHandler.this.totalManagedIndices = (int)response.getHits().getTotalHits().value();
                            log.info("Set totalManagedIndices to: {}", (Object)ExplainHandler.this.totalManagedIndices);
                        }
                        log.info("About to parse {} search hits", (Object)response.getHits().getHits().length);
                        for (ManagedIndexConfig managedIndex : ExplainHandler.this.parseSearchHits(response.getHits().getHits())) {
                            log.info("Found ManagedIndexConfig: index={}, indexUuid={}, policyID={}", (Object)managedIndex.getIndex(), (Object)managedIndex.getIndexUuid(), (Object)managedIndex.getPolicyID());
                            ExplainHandler.this.managedIndices.add(managedIndex.getIndex());
                            ExplainHandler.this.enabledState.put(managedIndex.getIndex(), managedIndex.isEnabled());
                            HashMap<String, String> metadataMap = new HashMap<String, String>();
                            metadataMap.put("index", managedIndex.getIndex());
                            metadataMap.put("index_uuid", managedIndex.getIndexUuid());
                            metadataMap.put("policy_id", managedIndex.getPolicyID());
                            metadataMap.put("enabled", String.valueOf(managedIndex.isEnabled()));
                            ExplainHandler.this.managedIndicesMetaDataMap.put(managedIndex.getIndex(), metadataMap);
                            if (ExplainHandler.this.showPolicy && managedIndex.getPolicy() != null) {
                                ExplainHandler.this.appliedPolicies.put(managedIndex.getIndex(), managedIndex.getPolicy());
                            }
                            if (!ExplainHandler.this.validateAction || managedIndex.getPolicy() == null) continue;
                            ExplainHandler.this.policiesforValidation.put(managedIndex.getIndex(), managedIndex.getPolicy());
                        }
                        log.info("After parsing all hits - managedIndices.size()={}, explainAll={}, indexNames.size()={}", (Object)ExplainHandler.this.managedIndices.size(), (Object)ExplainHandler.this.explainAll, (Object)ExplainHandler.this.indexNames.size());
                        if (ExplainHandler.this.explainAll) {
                            if (ExplainHandler.this.managedIndices.size() == 0) {
                                ExplainHandler.this.indexNames.clear();
                                ExplainHandler.this.sendResponse(ExplainHandler.this.indexNames, ExplainHandler.this.indexMetadatas, ExplainHandler.this.indexPolicyIDs, ExplainHandler.this.enabledState, ExplainHandler.this.totalManagedIndices, ExplainHandler.this.appliedPolicies, ExplainHandler.this.validationResults);
                                return;
                            }
                            ExplainHandler.this.indexNames.clear();
                            ExplainHandler.this.indexNames.addAll(ExplainHandler.this.managedIndices);
                            HashMap<String, String> filtered = new HashMap<String, String>();
                            for (String name : ExplainHandler.this.indexNames) {
                                if (!ExplainHandler.this.indexNamesToUUIDs.containsKey(name)) continue;
                                filtered.put(name, ExplainHandler.this.indexNamesToUUIDs.get(name));
                            }
                            ExplainHandler.this.indexNamesToUUIDs.clear();
                            ExplainHandler.this.indexNamesToUUIDs.putAll(filtered);
                            ExplainHandler.this.getMetadata(ExplainHandler.this.indexNames, threadContext);
                            return;
                        }
                        ExplainHandler.this.getMetadata(ExplainHandler.this.indexNames, threadContext);
                    }

                    public void onFailure(Exception t) {
                        if (t instanceof IndexNotFoundException) {
                            if (!ExplainHandler.this.explainAll) {
                                ExplainHandler.this.getMetadata(ExplainHandler.this.indexNames, threadContext);
                                return;
                            }
                            ExplainHandler.this.indexNames.clear();
                            ExplainHandler.this.sendResponse(ExplainHandler.this.indexNames, ExplainHandler.this.indexMetadatas, ExplainHandler.this.indexPolicyIDs, ExplainHandler.this.enabledState, ExplainHandler.this.totalManagedIndices, ExplainHandler.this.appliedPolicies, ExplainHandler.this.validationResults);
                            return;
                        }
                        ExplainHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                    }
                });
            }
        }

        void getMetadata(List<String> indexNames, final ThreadContext.StoredContext threadContext) {
            if ("_default".equals(this.request.getIndexType())) {
                ClusterStateRequest clusterStateRequest = (ClusterStateRequest)((ClusterStateRequest)new ClusterStateRequest().clear().indices(indexNames.toArray(new String[0])).metadata(true).local(this.request.isLocal())).clusterManagerNodeTimeout(this.request.getClusterManagerTimeout());
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

                    public void onResponse(ClusterStateResponse response) {
                        Map clusterStateIndexMetadatas = response.getState().metadata().indices();
                        ExplainHandler.this.getMetadataMap(clusterStateIndexMetadatas, threadContext);
                    }

                    public void onFailure(Exception t) {
                        ExplainHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                    }
                });
            } else {
                this.getMetadataMap(null, threadContext);
            }
        }

        private void getMetadataMap(final Map<String, IndexMetadata> clusterStateIndexMetadatas, final ThreadContext.StoredContext threadContext) {
            MultiGetRequest mgetMetadataReq = new MultiGetRequest();
            for (String uuid : this.indexNamesToUUIDs.values()) {
                mgetMetadataReq.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(uuid)).routing(uuid));
            }
            this.client.multiGet(mgetMetadataReq, (ActionListener)new ActionListener<MultiGetResponse>(){

                public void onResponse(MultiGetResponse response) {
                    HashMap<String, Map<String, String>> metadataMap = new HashMap<String, Map<String, String>>();
                    for (MultiGetItemResponse item : response.getResponses()) {
                        ManagedIndexMetaData metadata = ExplainHandler.this.getMetadata(item.getResponse());
                        if (metadata == null) continue;
                        metadataMap.put(item.getId(), metadata.toMap());
                    }
                    try {
                        if (ExplainHandler.this.request.getExplainFilter() != null) {
                            HashMap<String, Map> filtered = new HashMap<String, Map>();
                            for (Map.Entry entry : metadataMap.entrySet()) {
                                if (entry.getValue() != null) {
                                    ManagedIndexMetaData metaData = ManagedIndexMetaData.fromMap((Map)((Map)entry.getValue()));
                                    if (ExplainHandler.this.request.getExplainFilter().byMetaData(metaData)) {
                                        filtered.put((String)entry.getKey(), (Map)entry.getValue());
                                        continue;
                                    }
                                    ExplainHandler.this.indexNames.remove(metaData.getIndex());
                                    ExplainHandler.this.indexNamesToUUIDs.remove(metaData.getIndex());
                                    if (!ExplainHandler.this.managedIndices.contains(metaData.getIndex())) continue;
                                    --ExplainHandler.this.totalManagedIndices;
                                    continue;
                                }
                                filtered.put((String)entry.getKey(), (Map)entry.getValue());
                            }
                            metadataMap = filtered;
                        }
                        ExplainHandler.this.buildResponse(ExplainHandler.this.indexNamesToUUIDs, metadataMap, clusterStateIndexMetadatas, threadContext);
                    }
                    catch (IOException e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception t) {
                    ExplainHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        private void buildResponse(Map<String, String> indices, Map<String, Map<String, String>> metadataMap, Map<String, IndexMetadata> clusterStateIndexMetadatas, ThreadContext.StoredContext threadContext) throws IOException {
            for (String indexName : this.indexNames) {
                Map<String, String> configIndexMetadataMap;
                Map<String, String> metadataMapFromManagedIndex = this.managedIndicesMetaDataMap.get(indexName);
                this.indexPolicyIDs.add(metadataMapFromManagedIndex != null ? metadataMapFromManagedIndex.get("policy_id") : null);
                ManagedIndexMetaData managedIndexMetadata = null;
                String managedIndexMetadataDocUUID = indices.get(indexName) != null ? ManagedIndexUtils.managedIndexMetadataID(indices.get(indexName)) : null;
                Map<String, String> map = configIndexMetadataMap = managedIndexMetadataDocUUID != null ? metadataMap.get(managedIndexMetadataDocUUID) : null;
                if (metadataMapFromManagedIndex != null) {
                    if (configIndexMetadataMap != null) {
                        metadataMapFromManagedIndex = configIndexMetadataMap;
                    }
                    if (!metadataMapFromManagedIndex.isEmpty()) {
                        managedIndexMetadata = ManagedIndexMetaData.fromMap(metadataMapFromManagedIndex);
                    }
                    if (clusterStateIndexMetadatas != null) {
                        IndexMetadata indexMetadata = clusterStateIndexMetadatas.get(indexName);
                    }
                }
                if (this.validateAction) {
                    ValidationResult validationResult;
                    Policy policy = this.policiesforValidation.get(indexName);
                    if (policy != null && managedIndexMetadata != null) {
                        State state = policy.getStateToExecute(managedIndexMetadata);
                        Action action = state != null ? state.getActionToExecute(managedIndexMetadata, TransportExplainAction.this.indexMetadataProvider) : null;
                        String actionName = action != null ? action.getType() : "nothing";
                        validationResult = ManagedIndexRunner.INSTANCE.actionValidation.validate(actionName, indexName);
                    } else {
                        validationResult = ManagedIndexRunner.INSTANCE.actionValidation.validate("nothing", indexName);
                    }
                    this.validationResults.add(validationResult);
                } else {
                    this.validationResults.add(null);
                }
                this.indexMetadatas.add(managedIndexMetadata);
            }
            this.managedIndicesMetaDataMap.clear();
            if (this.user == null || this.indexNames.isEmpty()) {
                this.sendResponse(this.indexNames, this.indexMetadatas, this.indexPolicyIDs, this.enabledState, this.totalManagedIndices, this.appliedPolicies, this.validationResults);
            } else {
                this.filterAndSendResponse(threadContext);
            }
        }

        private void filterAndSendResponse(ThreadContext.StoredContext threadContext) {
            threadContext.restore();
            ArrayList filteredIndices = new ArrayList();
            ArrayList filteredMetadata = new ArrayList();
            ArrayList filteredValidationResult = new ArrayList();
            ArrayList filteredPolicies = new ArrayList();
            HashMap enabledStatus = new HashMap();
            HashMap filteredAppliedPolicies = new HashMap();
            CompletableFuture.runAsync(() -> {
                for (int i = 0; i < this.indexNames.size(); ++i) {
                    ManagedIndexRequest managedIndexRequest = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(new String[]{this.indexNames.get(i)});
                    try {
                        CompletableFuture future = LuceniaExtensions.suspendUntil(this.client, (c, listener) -> c.execute((ActionType)ManagedIndexAction.INSTANCE, (ActionRequest)managedIndexRequest, listener));
                        future.get();
                        filteredIndices.add(this.indexNames.get(i));
                        filteredMetadata.add(this.indexMetadatas.get(i));
                        filteredPolicies.add(this.indexPolicyIDs.get(i));
                        filteredValidationResult.add(this.validationResults.get(i));
                        if (this.enabledState.get(this.indexNames.get(i)) != null) {
                            enabledStatus.put(this.indexNames.get(i), this.enabledState.get(this.indexNames.get(i)));
                        }
                        if (this.appliedPolicies.get(this.indexNames.get(i)) == null) continue;
                        filteredAppliedPolicies.put(this.indexNames.get(i), this.appliedPolicies.get(this.indexNames.get(i)));
                        continue;
                    }
                    catch (SkyliteSecurityException e) {
                        --this.totalManagedIndices;
                        continue;
                    }
                    catch (Exception e) {
                        this.actionListener.onFailure(e);
                        return;
                    }
                }
                this.sendResponse(filteredIndices, filteredMetadata, filteredPolicies, enabledStatus, this.totalManagedIndices, filteredAppliedPolicies, filteredValidationResult);
            });
        }

        private void sendResponse(List<String> indices, List<ManagedIndexMetaData> metadata, List<String> policyIDs, Map<String, Boolean> enabledStatus, int totalIndices, Map<String, Policy> policies, List<ValidationResult> validationResult) {
            this.actionListener.onResponse((Object)new ExplainResponse(indices, policyIDs, metadata, totalIndices, enabledStatus, policies, validationResult));
        }

        private ManagedIndexMetaData getMetadata(GetResponse response) {
            log.info("getMetadata called for response: exists={}, id={}, source={}", (Object)(response != null && response.isExists() ? 1 : 0), (Object)(response != null ? response.getId() : "null"), (Object)(response != null && response.getSourceAsBytesRef() != null ? "present" : "null"));
            if (response == null || response.getSourceAsBytesRef() == null) {
                log.info("getMetadata returning null because response or source is null");
                return null;
            }
            try {
                log.info("Attempting to parse metadata {} for id={}", (Object)response.getSourceAsString(), (Object)response.getId());
                ManagedIndexMetaData metadata = ManagedIndexMetaData.parseWithType((XContentParser)XContentHelper.createParser((NamedXContentRegistry)TransportExplainAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON), (String)response.getId(), (long)response.getSeqNo(), (long)response.getPrimaryTerm());
                log.info("Successfully parsed metadata for id={}, metadata index={}", (Object)response.getId(), (Object)(metadata != null ? metadata.getIndex() : "null"));
                return metadata;
            }
            catch (Exception e) {
                log.error("Failed to parse the ManagedIndexMetadata for {} {}", (Object)response.getId(), (Object)e);
                return null;
            }
        }

        private List<ManagedIndexConfig> parseSearchHits(SearchHit[] hits) {
            ArrayList<ManagedIndexConfig> configs = new ArrayList<ManagedIndexConfig>();
            for (SearchHit hit : hits) {
                try {
                    ManagedIndexConfig config = LuceniaExtensions.parseWithType(XContentHelper.createParser((NamedXContentRegistry)TransportExplainAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)hit.getSourceRef(), (MediaType)MediaTypeRegistry.JSON), ManagedIndexConfig::parse);
                    configs.add(config);
                }
                catch (IOException e) {
                    log.error("Failed to parse ManagedIndexConfig", (Throwable)e);
                }
            }
            return configs;
        }
    }
}

