/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;

public class GetPolicyRequest
extends ActionRequest {
    private final String policyID;
    private final long version;
    private final FetchSourceContext fetchSrcContext;

    public GetPolicyRequest(String policyID, long version, FetchSourceContext fetchSrcContext) {
        this.policyID = policyID;
        this.version = version;
        this.fetchSrcContext = fetchSrcContext;
    }

    public GetPolicyRequest(StreamInput in) throws IOException {
        this.policyID = in.readString();
        this.version = in.readLong();
        this.fetchSrcContext = new FetchSourceContext(in);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.policyID.isBlank()) {
            validationException = ValidateActions.addValidationError((String)"Missing policy ID", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.policyID);
        out.writeLong(this.version);
        this.fetchSrcContext.writeTo(out);
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public long getVersion() {
        return this.version;
    }

    public FetchSourceContext getFetchSrcContext() {
        return this.fetchSrcContext;
    }
}

