/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPoliciesRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPoliciesResponse;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.Operator;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.FieldSortBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class TransportGetPoliciesAction
extends HandledTransportAction<GetPoliciesRequest, GetPoliciesResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetPoliciesAction.class);
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetPoliciesAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/ism/policy/search", transportService, actionFilters, GetPoliciesRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, GetPoliciesRequest getPoliciesRequest, final ActionListener<GetPoliciesResponse> actionListener) {
        log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        SearchParams params = getPoliciesRequest.getSearchParams();
        User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        FieldSortBuilder sortBuilder = params.getSortBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"policy"));
        SecurityUtils.addUserFilter(user, queryBuilder, this.filterByEnabled, "policy.user");
        queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)params.getQueryString()).defaultOperator(Operator.AND).field("policy.policy_id.keyword"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).sort((BaseSortBuilder)sortBuilder).from(params.getFrom()).size(params.getSize()).seqNoAndPrimaryTerm(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{".opendistro-ism-config"}).preference(Preference.PRIMARY_FIRST.type());
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    try {
                        long totalPolicies = response.getHits().getTotalHits() != null ? response.getHits().getTotalHits().value() : 0L;
                        List<Policy> policies = LuceniaExtensions.parseFromSearchResponse(response, TransportGetPoliciesAction.this.xContentRegistry, Policy::parse);
                        actionListener.onResponse((Object)new GetPoliciesResponse(policies, (int)totalPolicies));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception t) {
                    if (t instanceof IndexNotFoundException) {
                        actionListener.onResponse((Object)new GetPoliciesResponse(Collections.emptyList(), 0));
                        return;
                    }
                    actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }
    }
}

