/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy;

import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPolicyRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPolicyResponse;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportGetPolicyAction
extends HandledTransportAction<GetPolicyRequest, GetPolicyResponse> {
    private final NodeClient client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetPolicyAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/ism/policy/get", transportService, actionFilters, GetPolicyRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, GetPolicyRequest request, ActionListener<GetPolicyResponse> listener) {
        GetPolicyHandler handler = new GetPolicyHandler(this.client, listener, request);
        handler.start();
    }

    class GetPolicyHandler {
        private final NodeClient client;
        private final ActionListener<GetPolicyResponse> actionListener;
        private final GetPolicyRequest request;
        private final User user;

        GetPolicyHandler(NodeClient client, ActionListener<GetPolicyResponse> listener, GetPolicyRequest request) {
            this.client = client;
            this.actionListener = listener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
        }

        void start() {
            TransportGetPolicyAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getPolicyID()).version(this.request.getVersion());
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                    public void onResponse(GetResponse response) {
                        GetPolicyHandler.this.onGetResponse(response);
                    }

                    public void onFailure(Exception t) {
                        GetPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                    }
                });
            }
        }

        void onGetResponse(GetResponse response) {
            Policy policy;
            if (!response.isExists()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Policy not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                policy = LuceniaExtensions.parseFromGetResponse(response, TransportGetPolicyAction.this.xContentRegistry, Policy::parse);
            }
            catch (IOException | IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Policy not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            if (!SecurityUtils.userHasPermissionForResource(this.user, policy.getUser(), TransportGetPolicyAction.this.filterByEnabled, "policy", this.request.getPolicyID(), this.actionListener)) {
                return;
            }
            GetPolicyResponse policyResponse = !this.request.getFetchSrcContext().fetchSource() ? new GetPolicyResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), null) : new GetPolicyResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), policy);
            this.actionListener.onResponse((Object)policyResponse);
        }
    }
}

