/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.indexpolicy;

import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class IndexPolicyRequest
extends ActionRequest {
    private final String policyID;
    private final Policy policy;
    private final long seqNo;
    private final long primaryTerm;
    private final WriteRequest.RefreshPolicy refreshPolicy;

    public IndexPolicyRequest(String policyID, Policy policy, long seqNo, long primaryTerm, WriteRequest.RefreshPolicy refreshPolicy) {
        this.policyID = policyID;
        this.policy = policy;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.refreshPolicy = refreshPolicy;
    }

    public IndexPolicyRequest(StreamInput in) throws IOException {
        this.policyID = in.readString();
        this.policy = new Policy(in);
        this.seqNo = in.readLong();
        this.primaryTerm = in.readLong();
        this.refreshPolicy = (WriteRequest.RefreshPolicy)in.readEnum(WriteRequest.RefreshPolicy.class);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if ("".equals(this.policyID)) {
            validationException = ValidateActions.addValidationError((String)"Missing policyID", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.policyID);
        this.policy.writeTo(out);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeEnum((Enum)this.refreshPolicy);
    }

    public String getPolicyID() {
        return this.policyID;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }
}

