/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.indexpolicy;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.indexstatemanagement.ISMTemplateService;
import io.lucenia.indexmanagement.indexstatemanagement.action.ReplicaCountAction;
import io.lucenia.indexmanagement.indexstatemanagement.model.ISMTemplate;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.model.State;
import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.indexpolicy.IndexPolicyResponse;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.IndexManagementException;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.ValidationException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.indexmanagement.Action;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.AutoExpandReplicas;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.index.query.QueryBuilders;

public class TransportIndexPolicyAction
extends HandledTransportAction<IndexPolicyRequest, IndexPolicyResponse> {
    private static final Logger log = LogManager.getLogger(TransportIndexPolicyAction.class);
    public static final String ISM_TEMPLATE_FIELD = "policy.ism_template";
    private final NodeClient client;
    private final IndexManagementIndices ismIndices;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final AwarenessReplicaBalance awarenessReplicaBalance;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportIndexPolicyAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, IndexManagementIndices ismIndices, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry, AwarenessReplicaBalance awarenessReplicaBalance) {
        super("cluster:admin/lucenia/ism/policy/write", transportService, actionFilters, IndexPolicyRequest::new);
        this.client = client;
        this.ismIndices = ismIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.awarenessReplicaBalance = awarenessReplicaBalance;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, IndexPolicyRequest request, ActionListener<IndexPolicyResponse> listener) {
        IndexPolicyHandler handler = new IndexPolicyHandler(this.client, listener, request);
        handler.start();
    }

    class IndexPolicyHandler {
        private final NodeClient client;
        private final ActionListener<IndexPolicyResponse> actionListener;
        private final IndexPolicyRequest request;
        private final User user;

        IndexPolicyHandler(NodeClient client, ActionListener<IndexPolicyResponse> actionListener, IndexPolicyRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
        }

        void start() {
            this.validate();
            log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                if (!SecurityUtils.validateUserConfiguration(this.user, TransportIndexPolicyAction.this.filterByEnabled, this.actionListener)) {
                    return;
                }
                TransportIndexPolicyAction.this.ismIndices.checkAndUpdateIMConfigIndex(new ActionListener<AcknowledgedResponse>(){

                    public void onResponse(AcknowledgedResponse response) {
                        IndexPolicyHandler.this.onCreateMappingsResponse(response);
                    }

                    public void onFailure(Exception t) {
                        if (t instanceof ResourceAlreadyExistsException) {
                            IndexPolicyHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException(t.getLocalizedMessage(), RestStatus.CONFLICT, new Object[0])));
                        } else {
                            IndexPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                        }
                    }
                });
            }
        }

        private void validate() {
            AutoExpandReplicas autoExpandReplica = (AutoExpandReplicas)AutoExpandReplicas.SETTING.get(Settings.EMPTY);
            for (State state : this.request.getPolicy().getStates()) {
                for (Action action : state.getActions()) {
                    ReplicaCountAction replicaCountAction;
                    Optional error;
                    if (!(action instanceof ReplicaCountAction) || !(error = TransportIndexPolicyAction.this.awarenessReplicaBalance.validate((replicaCountAction = (ReplicaCountAction)action).getNumOfReplicas(), autoExpandReplica)).isPresent()) continue;
                    ValidationException ex = new ValidationException();
                    ex.addValidationError((String)error.get());
                    this.actionListener.onFailure((Exception)ex);
                    return;
                }
            }
        }

        private void onCreateMappingsResponse(AcknowledgedResponse response) {
            if (response.isAcknowledged()) {
                log.info("Successfully created or updated {} with newest mappings.", (Object)".opendistro-ism-config");
                List<ISMTemplate> reqTemplates = this.request.getPolicy().getISMTemplate();
                if (reqTemplates != null) {
                    this.validateISMTemplates(reqTemplates);
                } else {
                    this.putPolicy();
                }
            } else {
                log.error("Unable to create or update {} with newest mapping.", (Object)".opendistro-ism-config");
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        private void validateISMTemplates(final List<ISMTemplate> ismTemplateList) {
            ArrayList<String> allPatterns = new ArrayList<String>();
            for (ISMTemplate template : ismTemplateList) {
                allPatterns.addAll(template.getIndexPatterns());
            }
            SkyliteException possibleEx = ISMTemplateService.validateFormat(allPatterns);
            if (possibleEx != null) {
                this.actionListener.onFailure((Exception)((Object)possibleEx));
                return;
            }
            Map.Entry<List<String>, List<String>> selfOverlap = ISMTemplateService.findSelfConflictingTemplates(ismTemplateList);
            if (selfOverlap != null) {
                String errorMessage = "New policy " + this.request.getPolicyID() + " has an ISM template with index pattern " + String.valueOf(selfOverlap.getKey()) + " matching this policy's other ISM templates with index patterns " + String.valueOf(selfOverlap.getValue()) + ", please use different priority";
                this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap(new IllegalArgumentException(errorMessage))));
                return;
            }
            SearchRequest searchRequest = new SearchRequest().source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.existsQuery((String)TransportIndexPolicyAction.ISM_TEMPLATE_FIELD)).size(10000).seqNoAndPrimaryTerm(Boolean.valueOf(true))).indices(new String[]{".opendistro-ism-config"}).preference(Preference.PRIMARY_FIRST.type());
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    List<Policy> policies;
                    try {
                        policies = LuceniaExtensions.parseFromSearchResponse(response, TransportIndexPolicyAction.this.xContentRegistry, Policy::parse);
                    }
                    catch (IOException e) {
                        IndexPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                        return;
                    }
                    HashMap<String, List<ISMTemplate>> policyToTemplateMap = new HashMap<String, List<ISMTemplate>>();
                    for (Policy policy : policies) {
                        if (policy.getISMTemplate() == null) continue;
                        policyToTemplateMap.put(policy.getId(), policy.getISMTemplate());
                    }
                    Map<String, List<ISMTemplate>> filteredMap = ISMIndexMetadataExtensions.filterNotNullValues(policyToTemplateMap);
                    for (ISMTemplate template : ismTemplateList) {
                        Map<String, List<String>> conflictingPolicyTemplates = ISMTemplateService.findConflictingPolicyTemplates(filteredMap, IndexPolicyHandler.this.request.getPolicyID(), template.getIndexPatterns(), template.getPriority());
                        if (conflictingPolicyTemplates.isEmpty()) continue;
                        String errorMessage = "New policy " + IndexPolicyHandler.this.request.getPolicyID() + " has an ISM template with index pattern " + String.valueOf(template.getIndexPatterns()) + " matching existing policy templates, please use a different priority than " + template.getPriority();
                        IndexPolicyHandler.this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap(new IllegalArgumentException(errorMessage))));
                        return;
                    }
                    IndexPolicyHandler.this.putPolicy();
                }

                public void onFailure(Exception t) {
                    IndexPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        private void putPolicy() {
            Policy policy = new Policy.Builder(this.request.getPolicy()).schemaVersion(IndexUtils.getIndexManagementConfigSchemaVersion()).user(this.user).build();
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opendistro-ism-config").setRefreshPolicy(this.request.getRefreshPolicy())).id(this.request.getPolicyID()).timeout(IndexRequest.DEFAULT_TIMEOUT);
            try {
                indexRequest.source(policy.toXContent(XContentFactory.jsonBuilder()));
            }
            catch (IOException e) {
                this.actionListener.onFailure((Exception)e);
                return;
            }
            if (this.request.getSeqNo() == -2L || this.request.getPrimaryTerm() == 0L) {
                indexRequest.opType(DocWriteRequest.OpType.CREATE);
            } else {
                indexRequest.setIfSeqNo(this.request.getSeqNo()).setIfPrimaryTerm(this.request.getPrimaryTerm());
            }
            this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    String failureReasons = IndexPolicyHandler.this.checkShardsFailure(response);
                    if (failureReasons != null) {
                        IndexPolicyHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException(failureReasons, response.status(), new Object[0])));
                        return;
                    }
                    IndexPolicyHandler.this.actionListener.onResponse((Object)new IndexPolicyResponse(response.getId(), response.getVersion(), response.getPrimaryTerm(), response.getSeqNo(), IndexPolicyHandler.this.request.getPolicy(), response.status()));
                }

                public void onFailure(Exception t) {
                    IndexPolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        private String checkShardsFailure(IndexResponse response) {
            if (response.getShardInfo().getFailed() > 0) {
                StringBuilder failureReasons = new StringBuilder();
                for (ReplicationResponse.ShardInfo.Failure failure : response.getShardInfo().getFailures()) {
                    failureReasons.append(failure.reason());
                }
                return failureReasons.toString();
            }
            return null;
        }
    }
}

