/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.removepolicy;

import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.removepolicy.RemovePolicyRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.util.IndexManagementException;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportRemovePolicyAction
extends HandledTransportAction<RemovePolicyRequest, ISMStatusResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final NodeClient client;
    private final IndexMetadataProvider indexMetadataProvider;

    @Inject
    public TransportRemovePolicyAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, IndexMetadataProvider indexMetadataProvider) {
        super("cluster:admin/lucenia/ism/managedindex/remove", transportService, actionFilters, RemovePolicyRequest::new);
        this.client = client;
        this.indexMetadataProvider = indexMetadataProvider;
    }

    protected void doExecute(Task task, RemovePolicyRequest request, ActionListener<ISMStatusResponse> listener) {
        RemovePolicyHandler handler = new RemovePolicyHandler(this.client, listener, request);
        handler.start();
    }

    class RemovePolicyHandler {
        private final NodeClient client;
        private final ActionListener<ISMStatusResponse> actionListener;
        private final RemovePolicyRequest request;
        private final User user;
        private final List<RestHandlerUtils.FailedIndex> failedIndices = new ArrayList<RestHandlerUtils.FailedIndex>();
        private final Map<String, String> indicesToRemove = new HashMap<String, String>();
        private final Set<String> indicesWithAutoManageFalseBlock = new HashSet<String>();
        private final Set<String> indicesWithReadOnlyBlock = new HashSet<String>();
        private final Set<String> indicesWithReadOnlyAllowDeleteBlock = new HashSet<String>();

        RemovePolicyHandler(NodeClient client, ActionListener<ISMStatusResponse> actionListener, RemovePolicyRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
        }

        void start() {
            TransportRemovePolicyAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            if (this.user == null) {
                this.getIndicesToRemove();
            } else {
                this.validateAndGetIndices();
            }
        }

        private void validateAndGetIndices() {
            ManagedIndexRequest managedIndexRequest = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(this.request.getIndices().toArray(new String[0]));
            this.client.execute((ActionType)ManagedIndexAction.INSTANCE, (ActionRequest)managedIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    RemovePolicyHandler.this.getIndicesToRemove();
                }

                public void onFailure(Exception e) {
                    RemovePolicyHandler.this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap((Exception)(e instanceof SkyliteSecurityException ? new SkyliteStatusException("User doesn't have required index permissions on one or more requested indices: " + e.getLocalizedMessage(), RestStatus.FORBIDDEN, new Object[0]) : e))));
                }
            });
        }

        private void getIndicesToRemove() {
            CompletableFuture.runAsync(() -> {
                HashMap<String, ISMIndexMetadata> indexNameToMetadata = new HashMap<String, ISMIndexMetadata>();
                try {
                    indexNameToMetadata.putAll(TransportRemovePolicyAction.this.indexMetadataProvider.getISMIndexMetadataByType(this.request.getIndexType(), this.request.getIndices()).join());
                }
                catch (Exception e) {
                    this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    return;
                }
                for (Map.Entry entry : indexNameToMetadata.entrySet()) {
                    this.indicesToRemove.putIfAbsent(((ISMIndexMetadata)entry.getValue()).getIndexUuid(), (String)entry.getKey());
                }
                if ("_default".equals(this.request.getIndexType())) {
                    this.getClusterState();
                } else {
                    this.getExistingManagedIndices();
                }
            });
        }

        private void getClusterState() {
            IndicesOptions strictExpandOptions = IndicesOptions.strictExpand();
            ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(this.request.getIndices().toArray(new String[0])).metadata(true).local(false)).indicesOptions(strictExpandOptions);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

                    public void onResponse(ClusterStateResponse response) {
                        Map indexMetadatas = response.getState().metadata().indices();
                        for (Map.Entry entry : indexMetadatas.entrySet()) {
                            if ("false".equals(((IndexMetadata)entry.getValue()).getSettings().get(ManagedIndexSettings.AUTO_MANAGE.getKey()))) {
                                RemovePolicyHandler.this.indicesWithAutoManageFalseBlock.add(((IndexMetadata)entry.getValue()).getIndexUUID());
                            }
                            if ("true".equals(((IndexMetadata)entry.getValue()).getSettings().get(IndexMetadata.SETTING_READ_ONLY))) {
                                RemovePolicyHandler.this.indicesWithReadOnlyBlock.add(((IndexMetadata)entry.getValue()).getIndexUUID());
                            }
                            if (!"true".equals(((IndexMetadata)entry.getValue()).getSettings().get(IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE))) continue;
                            RemovePolicyHandler.this.indicesWithReadOnlyAllowDeleteBlock.add(((IndexMetadata)entry.getValue()).getIndexUUID());
                        }
                        DefaultIndexMetadataService defaultService = (DefaultIndexMetadataService)TransportRemovePolicyAction.this.indexMetadataProvider.getServices().get("_default");
                        List<String> closedIndices = ISMIndexMetadataExtensions.getUuidsForClosedIndices(response.getState(), defaultService);
                        for (String uuid : closedIndices) {
                            RemovePolicyHandler.this.failedIndices.add(new FailedIndex(RemovePolicyHandler.this.indicesToRemove.get(uuid), uuid, "This index is closed"));
                            RemovePolicyHandler.this.indicesToRemove.remove(uuid);
                        }
                        RemovePolicyHandler.this.getExistingManagedIndices();
                    }

                    public void onFailure(Exception t) {
                        RemovePolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                    }
                });
            }
        }

        private void getExistingManagedIndices() {
            if (this.indicesToRemove.isEmpty()) {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
                return;
            }
            MultiGetRequest multiGetReq = new MultiGetRequest();
            for (String uuid : this.indicesToRemove.keySet()) {
                multiGetReq.add(".opendistro-ism-config", uuid);
            }
            this.client.multiGet(multiGetReq, (ActionListener)new ActionListener<MultiGetResponse>(){

                public void onResponse(MultiGetResponse response) {
                    MultiGetItemResponse first = response.getResponses()[0];
                    if (first.isFailed() && first.getFailure().getFailure() instanceof IndexNotFoundException) {
                        for (Map.Entry<String, String> entry : RemovePolicyHandler.this.indicesToRemove.entrySet()) {
                            RemovePolicyHandler.this.failedIndices.add(new FailedIndex(entry.getValue(), entry.getKey(), "This index does not have a policy to remove"));
                        }
                        RemovePolicyHandler.this.actionListener.onResponse((Object)new ISMStatusResponse(0, RemovePolicyHandler.this.failedIndices));
                        return;
                    }
                    for (MultiGetItemResponse item : response.getResponses()) {
                        if (item.getResponse().isExists()) continue;
                        String docId = item.getId();
                        RemovePolicyHandler.this.failedIndices.add(new FailedIndex(RemovePolicyHandler.this.indicesToRemove.get(docId), docId, "This index does not have a policy to remove"));
                        RemovePolicyHandler.this.indicesToRemove.remove(docId);
                    }
                    if ("_default".equals(RemovePolicyHandler.this.request.getIndexType())) {
                        RemovePolicyHandler.this.updateSettings(RemovePolicyHandler.this.indicesToRemove);
                    } else {
                        RemovePolicyHandler.this.removeManagedIndices();
                    }
                }

                public void onFailure(Exception t) {
                    RemovePolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        void updateSettings(Map<String, String> indices) {
            String[] indexNames;
            HashSet<String> indicesUuidsSet = new HashSet<String>(indices.keySet());
            indicesUuidsSet.removeAll(this.indicesWithAutoManageFalseBlock);
            ArrayList<String> readOnlyIndices = new ArrayList<String>();
            for (String uuid : indicesUuidsSet) {
                if (!this.indicesWithReadOnlyBlock.contains(uuid)) continue;
                readOnlyIndices.add(uuid);
            }
            HashSet<String> remaining = new HashSet<String>(indicesUuidsSet);
            remaining.removeAll(readOnlyIndices);
            ArrayList<String> readOnlyAllowDeleteIndices = new ArrayList<String>();
            for (String uuid : remaining) {
                if (!this.indicesWithReadOnlyAllowDeleteBlock.contains(uuid)) continue;
                readOnlyAllowDeleteIndices.add(uuid);
            }
            HashSet<String> normalIndicesSet = new HashSet<String>(indicesUuidsSet);
            normalIndicesSet.removeAll(readOnlyIndices);
            normalIndicesSet.removeAll(readOnlyAllowDeleteIndices);
            ArrayList<String> normalIndices = new ArrayList<String>(normalIndicesSet);
            ArrayList<UpdateSettingsRequest> updateSettingReqsList = new ArrayList<UpdateSettingsRequest>();
            if (!readOnlyIndices.isEmpty()) {
                indexNames = (String[])readOnlyIndices.stream().map(indices::get).toArray(String[]::new);
                updateSettingReqsList.add(new UpdateSettingsRequest().indices(indexNames).settings(Settings.builder().put(IndexMetadata.INDEX_READ_ONLY_SETTING.getKey(), false)));
                updateSettingReqsList.add(new UpdateSettingsRequest().indices(indexNames).settings(Settings.builder().put(ManagedIndexSettings.AUTO_MANAGE.getKey(), false).put(IndexMetadata.INDEX_READ_ONLY_SETTING.getKey(), true)));
            }
            if (!readOnlyAllowDeleteIndices.isEmpty()) {
                indexNames = (String[])readOnlyAllowDeleteIndices.stream().map(indices::get).toArray(String[]::new);
                updateSettingReqsList.add(new UpdateSettingsRequest().indices(indexNames).settings(Settings.builder().put(IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.getKey(), false)));
                updateSettingReqsList.add(new UpdateSettingsRequest().indices(indexNames).settings(Settings.builder().put(ManagedIndexSettings.AUTO_MANAGE.getKey(), false).put(IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.getKey(), true)));
            }
            if (!normalIndices.isEmpty()) {
                indexNames = (String[])normalIndices.stream().map(indices::get).toArray(String[]::new);
                updateSettingReqsList.add(new UpdateSettingsRequest().indices(indexNames).settings(Settings.builder().put(ManagedIndexSettings.AUTO_MANAGE.getKey(), false)));
            }
            this.updateSettingCallChain(0, updateSettingReqsList);
        }

        void updateSettingCallChain(final int current, final List<UpdateSettingsRequest> updateSettingReqsList) {
            if (updateSettingReqsList.isEmpty()) {
                this.removeManagedIndices();
                return;
            }
            this.client.admin().indices().updateSettings(updateSettingReqsList.get(current), (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        RemovePolicyHandler.this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap(new Exception("Failed to remove policy because ISM auto_manage setting update requests are not fully acknowledged."))));
                        return;
                    }
                    if (current < updateSettingReqsList.size() - 1) {
                        RemovePolicyHandler.this.updateSettingCallChain(current + 1, updateSettingReqsList);
                    } else {
                        RemovePolicyHandler.this.removeManagedIndices();
                    }
                }

                public void onFailure(Exception t) {
                    Exception ex = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t);
                    RemovePolicyHandler.this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap(new Exception("Failed to remove policy because ISM auto_manage setting update requests failed with exception:", ex))));
                }
            });
        }

        void removeManagedIndices() {
            if (!this.indicesToRemove.isEmpty()) {
                BulkRequest bulkReq = new BulkRequest();
                for (String uuid : this.indicesToRemove.keySet()) {
                    bulkReq.add(ManagedIndexUtils.deleteManagedIndexRequest(uuid));
                }
                this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(){

                    public void onResponse(BulkResponse response) {
                        for (BulkItemResponse item : response.getItems()) {
                            String docId = item.getId();
                            if (!item.isFailed()) continue;
                            RemovePolicyHandler.this.failedIndices.add(new FailedIndex(RemovePolicyHandler.this.indicesToRemove.get(docId), docId, "Failed to remove policy"));
                            RemovePolicyHandler.this.indicesToRemove.remove(docId);
                        }
                        ArrayList<Index> indicesToRemoveMetadata = new ArrayList<Index>();
                        for (Map.Entry<String, String> entry : RemovePolicyHandler.this.indicesToRemove.entrySet()) {
                            indicesToRemoveMetadata.add(new Index(entry.getValue(), entry.getKey()));
                        }
                        RemovePolicyHandler.this.removeMetadatas(indicesToRemoveMetadata);
                    }

                    public void onFailure(Exception t) {
                        if (t instanceof ClusterBlockException) {
                            for (Map.Entry<String, String> entry : RemovePolicyHandler.this.indicesToRemove.entrySet()) {
                                RemovePolicyHandler.this.failedIndices.add(new FailedIndex(entry.getValue(), entry.getKey(), "Failed to remove policy due to ClusterBlockingException: " + t.getMessage()));
                            }
                            RemovePolicyHandler.this.actionListener.onResponse((Object)new ISMStatusResponse(0, RemovePolicyHandler.this.failedIndices));
                        } else {
                            RemovePolicyHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                        }
                    }
                });
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        void removeMetadatas(List<Index> indices) {
            BulkRequest bulkReq = new BulkRequest();
            for (Index index : indices) {
                bulkReq.add(ManagedIndexUtils.deleteManagedIndexMetadataRequest(index.getUUID()));
            }
            this.client.bulk(bulkReq, (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse response) {
                    for (BulkItemResponse item : response.getItems()) {
                        String docId = item.getId();
                        if (!item.isFailed()) continue;
                        RemovePolicyHandler.this.failedIndices.add(new FailedIndex(RemovePolicyHandler.this.indicesToRemove.get(docId), docId, "Failed to clean metadata due to: " + item.getFailureMessage()));
                        RemovePolicyHandler.this.indicesToRemove.remove(docId);
                    }
                    RemovePolicyHandler.this.actionListener.onResponse((Object)new ISMStatusResponse(RemovePolicyHandler.this.indicesToRemove.size(), RemovePolicyHandler.this.failedIndices));
                }

                public void onFailure(Exception e) {
                    RemovePolicyHandler.this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap(new Exception("Failed to clean metadata for remove policy indices.", e))));
                }
            });
        }
    }

    static class FailedIndex
    extends RestHandlerUtils.FailedIndex {
        public FailedIndex(String name, String uuid, String reason) {
            super(name, uuid, reason);
        }
    }
}

