/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.List;

public class RetryFailedManagedIndexRequest
extends ActionRequest {
    public static final String MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR = "Cannot retry on more than one index name/pattern when using a custom index type";
    private final List<String> indices;
    private final String startState;
    private final TimeValue clusterManagerTimeout;
    private final String indexType;

    public RetryFailedManagedIndexRequest(List<String> indices, String startState, TimeValue clusterManagerTimeout, String indexType) {
        this.indices = indices;
        this.startState = startState;
        this.clusterManagerTimeout = clusterManagerTimeout;
        this.indexType = indexType;
    }

    public RetryFailedManagedIndexRequest(StreamInput in) throws IOException {
        this.indices = in.readStringList();
        this.startState = in.readOptionalString();
        this.clusterManagerTimeout = in.readTimeValue();
        this.indexType = in.readString();
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing indices", validationException);
        } else if (!this.indexType.equals("_default") && this.indices.size() > 1) {
            validationException = ValidateActions.addValidationError((String)MULTIPLE_INDICES_CUSTOM_INDEX_TYPE_ERROR, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indices);
        out.writeOptionalString(this.startState);
        out.writeTimeValue(this.clusterManagerTimeout);
        out.writeString(this.indexType);
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public String getStartState() {
        return this.startState;
    }

    public TimeValue getClusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    public String getIndexType() {
        return this.indexType;
    }
}

