/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex;

import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex.RetryFailedManagedIndexRequest;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.util.IndexManagementException;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.state.ClusterStateRequest;
import io.skylite.core.action.admin.cluster.state.ClusterStateResponse;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ISMIndexMetadata;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.PolicyRetryInfoMetaData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportRetryFailedManagedIndexAction
extends HandledTransportAction<RetryFailedManagedIndexRequest, ISMStatusResponse> {
    private static final Logger log = LogManager.getLogger(TransportRetryFailedManagedIndexAction.class);
    private final NodeClient client;
    private final IndexMetadataProvider indexMetadataProvider;

    @Inject
    public TransportRetryFailedManagedIndexAction(NodeClient client, TransportService transportService, ActionFilters actionFilters, IndexMetadataProvider indexMetadataProvider) {
        super("cluster:admin/lucenia/ism/managedindex/retry", transportService, actionFilters, RetryFailedManagedIndexRequest::new);
        this.client = client;
        this.indexMetadataProvider = indexMetadataProvider;
    }

    protected void doExecute(Task task, RetryFailedManagedIndexRequest request, ActionListener<ISMStatusResponse> listener) {
        RetryFailedManagedIndexHandler handler = new RetryFailedManagedIndexHandler(this.client, listener, request);
        handler.start();
    }

    class RetryFailedManagedIndexHandler {
        private final NodeClient client;
        private final ActionListener<ISMStatusResponse> actionListener;
        private final RetryFailedManagedIndexRequest request;
        private final User user;
        private final List<RestHandlerUtils.FailedIndex> failedIndices = new ArrayList<RestHandlerUtils.FailedIndex>();
        private final List<ManagedIndexMetaData> listOfMetadata = new ArrayList<ManagedIndexMetaData>();
        private final List<IndexMetadataPair> listOfIndexToMetadata = new ArrayList<IndexMetadataPair>();
        private final Map<Integer, Index> mapOfItemIdToIndex = new HashMap<Integer, Index>();
        private final Map<String, Boolean> indicesManagedState = new HashMap<String, Boolean>();
        private Map<String, String> indicesToRetry = new HashMap<String, String>();
        private final Map<String, IndexMetadata> indexUuidToIndexMetadata = new HashMap<String, IndexMetadata>();

        RetryFailedManagedIndexHandler(NodeClient client, ActionListener<ISMStatusResponse> actionListener, RetryFailedManagedIndexRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
        }

        void start() {
            log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            if (this.user == null) {
                this.getIndicesToRetry();
            } else {
                this.validateAndGetIndicesToRetry();
            }
        }

        private void validateAndGetIndicesToRetry() {
            ManagedIndexRequest managedIndexRequest = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(this.request.getIndices().toArray(new String[0]));
            this.client.execute((ActionType)ManagedIndexAction.INSTANCE, (ActionRequest)managedIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    RetryFailedManagedIndexHandler.this.getIndicesToRetry();
                }

                public void onFailure(Exception e) {
                    RetryFailedManagedIndexHandler.this.actionListener.onFailure((Exception)((Object)IndexManagementException.wrap((Exception)(e instanceof SkyliteSecurityException ? new SkyliteStatusException("User doesn't have required index permissions on one or more requested indices: " + e.getLocalizedMessage(), RestStatus.FORBIDDEN, new Object[0]) : e))));
                }
            });
        }

        private void getIndicesToRetry() {
            CompletableFuture.runAsync(() -> {
                HashMap<String, ISMIndexMetadata> indexNameToMetadata;
                try {
                    indexNameToMetadata = new HashMap<String, ISMIndexMetadata>(TransportRetryFailedManagedIndexAction.this.indexMetadataProvider.getISMIndexMetadataByType(this.request.getIndexType(), this.request.getIndices()).get());
                }
                catch (Exception e) {
                    this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    return;
                }
                for (Map.Entry entry : indexNameToMetadata.entrySet()) {
                    this.indicesToRetry.putIfAbsent(((ISMIndexMetadata)entry.getValue()).getIndexUuid(), (String)entry.getKey());
                }
                if ("_default".equals(this.request.getIndexType())) {
                    this.getClusterState();
                } else {
                    this.processResponse();
                }
            });
        }

        private void getClusterState() {
            IndicesOptions strictExpandIndicesOptions = IndicesOptions.strictExpand();
            ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)((ClusterStateRequest)new ClusterStateRequest().clear().indices(this.request.getIndices().toArray(new String[0])).metadata(true).local(false)).clusterManagerNodeTimeout(this.request.getClusterManagerTimeout())).indicesOptions(strictExpandIndicesOptions);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(){

                    public void onResponse(ClusterStateResponse response) {
                        DefaultIndexMetadataService defaultService = (DefaultIndexMetadataService)TransportRetryFailedManagedIndexAction.this.indexMetadataProvider.getServices().get("_default");
                        for (Map.Entry entry : response.getState().metadata().indices().entrySet()) {
                            String indexUUID = defaultService.getIndexUUID((IndexMetadata)entry.getValue());
                            RetryFailedManagedIndexHandler.this.indexUuidToIndexMetadata.put(indexUUID, (IndexMetadata)entry.getValue());
                        }
                        RetryFailedManagedIndexHandler.this.processResponse();
                    }

                    public void onFailure(Exception t) {
                        RetryFailedManagedIndexHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                    }
                });
            }
        }

        private void processResponse() {
            MultiGetRequest mReq = new MultiGetRequest();
            for (String uuid : this.indicesToRetry.keySet()) {
                mReq.add(".opendistro-ism-config", uuid);
            }
            this.client.multiGet(mReq, (ActionListener)new ActionListener<MultiGetResponse>(){

                public void onResponse(MultiGetResponse response) {
                    MultiGetItemResponse first = response.getResponses()[0];
                    if (first.isFailed() && first.getFailure().getFailure() instanceof IndexNotFoundException) {
                        for (Map.Entry<String, String> entry : RetryFailedManagedIndexHandler.this.indicesToRetry.entrySet()) {
                            RetryFailedManagedIndexHandler.this.failedIndices.add(new FailedIndex(entry.getValue(), entry.getKey(), "This index is not being managed."));
                        }
                        RetryFailedManagedIndexHandler.this.actionListener.onResponse((Object)new ISMStatusResponse(0, RetryFailedManagedIndexHandler.this.failedIndices));
                        return;
                    }
                    for (MultiGetItemResponse item : response.getResponses()) {
                        RetryFailedManagedIndexHandler.this.indicesManagedState.put(item.getId(), item.getResponse().isExists());
                    }
                    ArrayList<String> uuidList = new ArrayList<String>(RetryFailedManagedIndexHandler.this.indicesToRetry.keySet());
                    RetryFailedManagedIndexHandler.this.client.multiGet(ISMIndexMetadataExtensions.buildMgetMetadataRequest(uuidList), ActionListener.wrap(RetryFailedManagedIndexHandler.this::onMgetMetadataResponse, RetryFailedManagedIndexHandler.this::onFailure));
                }

                public void onFailure(Exception t) {
                    RetryFailedManagedIndexHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)t));
                }
            });
        }

        private void onMgetMetadataResponse(MultiGetResponse mgetResponse) {
            Map<String, ISMIndexMetadataExtensions.Pair<ManagedIndexMetaData, Exception>> metadataMap = ISMIndexMetadataExtensions.mgetResponseToMap(mgetResponse);
            for (Map.Entry<String, String> entry : this.indicesToRetry.entrySet()) {
                String indexUuid = entry.getKey();
                String indexName = entry.getValue();
                ISMIndexMetadataExtensions.Pair<ManagedIndexMetaData, Exception> metadataPair = metadataMap.get(ManagedIndexUtils.managedIndexMetadataID(indexUuid));
                Exception mgetFailure = metadataPair != null ? metadataPair.getSecond() : null;
                ManagedIndexMetaData managedIndexMetadata = metadataPair != null ? metadataPair.getFirst() : null;
                Boolean isManaged = this.indicesManagedState.get(indexUuid);
                if (Boolean.FALSE.equals(isManaged)) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index is not being managed."));
                    continue;
                }
                if (mgetFailure != null) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "Failed to get managed index metadata, " + String.valueOf(mgetFailure)));
                    continue;
                }
                if (managedIndexMetadata == null) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index has no metadata information"));
                    continue;
                }
                if (!ManagedIndexUtils.isFailed(managedIndexMetadata)) {
                    this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index is not in failed state."));
                    continue;
                }
                this.listOfMetadata.add(managedIndexMetadata);
            }
            if (!this.listOfMetadata.isEmpty()) {
                ArrayList<String> jobDocIds = new ArrayList<String>();
                for (ManagedIndexMetaData metadata : this.listOfMetadata) {
                    jobDocIds.add(metadata.getIndexUuid());
                }
                this.bulkEnableJob(jobDocIds);
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        private void bulkEnableJob(List<String> jobDocIds) {
            BulkRequest bulkRequest = new BulkRequest();
            for (String docId : jobDocIds) {
                bulkRequest.add(ManagedIndexUtils.updateEnableManagedIndexRequest(docId));
            }
            this.client.bulk(bulkRequest, ActionListener.wrap(this::onEnableJobBulkResponse, this::onFailure));
        }

        private void onEnableJobBulkResponse(BulkResponse bulkResponse) {
            for (BulkItemResponse bulkItemResponse : bulkResponse.getItems()) {
                ManagedIndexMetaData managedIndexMetaData = null;
                for (ManagedIndexMetaData metadata : this.listOfMetadata) {
                    if (!metadata.getIndexUuid().equals(bulkItemResponse.getId())) continue;
                    managedIndexMetaData = metadata;
                    break;
                }
                if (managedIndexMetaData == null) continue;
                if (bulkItemResponse.isFailed()) {
                    this.failedIndices.add(new FailedIndex(managedIndexMetaData.getIndex(), managedIndexMetaData.getIndexUuid(), bulkItemResponse.getFailureMessage()));
                    continue;
                }
                ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
                ActionMetaData updatedActionMetaData = actionMetaData != null ? new ActionMetaData.Builder(actionMetaData).startTime(null).failed(false).consumedRetries(0).lastRetryTime(null).build() : null;
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("message", "Pending retry of failed managed index");
                ManagedIndexMetaData updatedMetadata = new ManagedIndexMetaData.Builder(managedIndexMetaData).transitionTo(this.request.getStartState()).actionMetaData(updatedActionMetaData).policyRetryInfo(new PolicyRetryInfoMetaData(false, 0)).info(info).build();
                this.listOfIndexToMetadata.add(new IndexMetadataPair(new Index(managedIndexMetaData.getIndex(), managedIndexMetaData.getIndexUuid()), updatedMetadata));
            }
            if (!this.listOfIndexToMetadata.isEmpty()) {
                for (int ind = 0; ind < this.listOfIndexToMetadata.size(); ++ind) {
                    this.mapOfItemIdToIndex.put(ind, this.listOfIndexToMetadata.get(ind).getIndex());
                }
                BulkRequest bulkUpdateMetadataRequest = new BulkRequest();
                for (IndexMetadataPair pair : this.listOfIndexToMetadata) {
                    try {
                        bulkUpdateMetadataRequest.add(new UpdateRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(pair.getIndex().getUUID())).routing(pair.getIndex().getUUID()).doc(pair.getMetadata().toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, true)));
                    }
                    catch (IOException e) {
                        log.error("Failed to create update request for metadata", (Throwable)e);
                    }
                }
                this.client.bulk(bulkUpdateMetadataRequest, ActionListener.wrap(this::onBulkUpdateMetadataResponse, this::onFailure));
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        private void onBulkUpdateMetadataResponse(BulkResponse bulkResponse) {
            ArrayList<BulkItemResponse> failedResponses = new ArrayList<BulkItemResponse>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedResponses.add(item);
            }
            for (BulkItemResponse failedResponse : failedResponses) {
                Index index = this.mapOfItemIdToIndex.get(failedResponse.getItemId());
                if (index == null) continue;
                this.failedIndices.add(new FailedIndex(index.getName(), index.getUUID(), "Failed to update metadata for index " + index.getName()));
            }
            int updated = bulkResponse.getItems().length - failedResponses.size();
            this.actionListener.onResponse((Object)new ISMStatusResponse(updated, this.failedIndices));
        }

        void onFailure(Exception e) {
            try {
                if (e instanceof ClusterBlockException) {
                    for (IndexMetadataPair pair : this.listOfIndexToMetadata) {
                        this.failedIndices.add(new FailedIndex(pair.getIndex().getName(), pair.getIndex().getUUID(), "Failed to update due to ClusterBlockException. " + e.getMessage()));
                    }
                }
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                log.error("Failed to send failure response", (Throwable)inner);
            }
        }
    }

    static class IndexMetadataPair {
        private final Index index;
        private final ManagedIndexMetaData metadata;

        IndexMetadataPair(Index index, ManagedIndexMetaData metadata) {
            this.index = index;
            this.metadata = metadata;
        }

        public Index getIndex() {
            return this.index;
        }

        public ManagedIndexMetaData getMetadata() {
            return this.metadata;
        }
    }

    static class FailedIndex
    extends RestHandlerUtils.FailedIndex {
        public FailedIndex(String name, String uuid, String reason) {
            super(name, uuid, reason);
        }
    }
}

