/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.util;

import io.lucenia.indexmanagement.common.model.notification.Channel;
import io.lucenia.indexmanagement.common.model.notification.NotificationUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.notifications.NotificationsPluginInterface;
import io.skylite.core.notifications.action.LegacyPublishNotificationRequest;
import io.skylite.core.notifications.action.LegacyPublishNotificationResponse;
import io.skylite.core.notifications.legacy.destination.message.LegacyBaseMessage;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.notifications.model.SeverityType;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public final class ISMNotificationUtils {
    private ISMNotificationUtils() {
    }

    public static void publishLegacyNotification(LegacyBaseMessage baseMessage, Client client) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        NotificationsPluginInterface.publishLegacyNotification((NodeClient)((NodeClient)client), (LegacyPublishNotificationRequest)new LegacyPublishNotificationRequest(baseMessage), (ActionListener)new ActionListener<LegacyPublishNotificationResponse>(){

            public void onResponse(LegacyPublishNotificationResponse response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            LegacyPublishNotificationResponse res = (LegacyPublishNotificationResponse)future.get();
            NotificationUtils.validateResponseStatus(RestStatus.fromCode((int)res.getDestinationResponse().getStatusCode()), res.getDestinationResponse().getResponseContent());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception("Interrupted while publishing legacy notification", e);
        }
        catch (ExecutionException e) {
            throw new Exception("Failed to publish legacy notification", e.getCause());
        }
    }

    public static void sendNotification(Channel channel, Client client, String title, ManagedIndexMetaData managedIndexMetaData, String compiledMessage, User user) throws Exception {
        EventSource eventSource = ISMNotificationUtils.getEventSource(managedIndexMetaData, title);
        CompletableFuture<Void> future = channel.sendNotification(client, eventSource, compiledMessage, user);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception("Interrupted while sending notification", e);
        }
        catch (ExecutionException e) {
            throw new Exception("Failed to send notification", e.getCause());
        }
    }

    public static EventSource getEventSource(ManagedIndexMetaData managedIndexMetaData, String title) {
        return new EventSource(title, managedIndexMetaData.getIndexUuid(), SeverityType.INFO, Collections.emptyList());
    }
}

