/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.util;

import io.lucenia.indexmanagement.indexstatemanagement.ManagedIndexRunner;
import io.lucenia.indexmanagement.indexstatemanagement.action.RolloverAction;
import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.lucenia.indexmanagement.indexstatemanagement.model.Conditions;
import io.lucenia.indexmanagement.indexstatemanagement.model.ManagedIndexConfig;
import io.lucenia.indexmanagement.indexstatemanagement.model.Policy;
import io.lucenia.indexmanagement.indexstatemanagement.model.State;
import io.lucenia.indexmanagement.indexstatemanagement.model.Transition;
import io.lucenia.indexmanagement.indexstatemanagement.model.coordinator.SweptManagedIndexConfig;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.luceniaapi.ParseUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.indexmanagement.Action;
import io.skylite.indexmanagement.Step;
import io.skylite.indexmanagement.model.ActionMetaData;
import io.skylite.indexmanagement.model.ActionRetry;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.PolicyRetryInfoMetaData;
import io.skylite.indexmanagement.model.StateMetaData;
import io.skylite.indexmanagement.model.StepMetaData;
import io.skylite.jobs.schedule.IntervalSchedule;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opensearch.index.query.QueryBuilders;

public final class ManagedIndexUtils {
    public static final String METADATA_POST_FIX = "#metadata";
    public static final String WITH_TYPE = "with_type";
    public static final String WITH_USER = "with_user";

    private ManagedIndexUtils() {
    }

    public static IndexRequest managedIndexConfigIndexRequest(String index, String uuid, String policyID, int jobInterval, Policy policy, Double jobJitter) {
        ManagedIndexConfig managedIndexConfig = new ManagedIndexConfig(uuid, -2L, 0L, index, index, uuid, true, (Schedule)new IntervalSchedule(Instant.now(), jobInterval, ChronoUnit.MINUTES), Instant.now(), Instant.now(), policyID, policy.getSeqNo(), policy.getPrimaryTerm(), policy, null, jobJitter);
        try {
            return new IndexRequest(".opendistro-ism-config").id(uuid).create(true).routing(managedIndexConfig.getIndexUuid()).source(managedIndexConfig.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create index request", e);
        }
    }

    public static IndexRequest managedIndexConfigIndexRequest(ManagedIndexConfig managedIndexConfig) {
        try {
            return new IndexRequest(".opendistro-ism-config").id(managedIndexConfig.getIndexUuid()).setIfPrimaryTerm(managedIndexConfig.getPrimaryTerm()).setIfSeqNo(managedIndexConfig.getSeqNo()).routing(managedIndexConfig.getIndexUuid()).source(managedIndexConfig.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create index request", e);
        }
    }

    public static String managedIndexMetadataID(String indexUuid) {
        return indexUuid + METADATA_POST_FIX;
    }

    public static String revertManagedIndexMetadataID(String metadataID) {
        return metadataID.substring(0, metadataID.length() - METADATA_POST_FIX.length());
    }

    public static IndexRequest managedIndexMetadataIndexRequest(ManagedIndexMetaData managedIndexMetadata, boolean waitRefresh, boolean create) {
        try {
            IndexRequest req = new IndexRequest(".opendistro-ism-config").id(ManagedIndexUtils.managedIndexMetadataID(managedIndexMetadata.getIndexUuid())).setIfPrimaryTerm(managedIndexMetadata.getPrimaryTerm()).setIfSeqNo(managedIndexMetadata.getSeqNo()).routing(managedIndexMetadata.getIndexUuid()).create(create).source(managedIndexMetadata.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, true));
            if (waitRefresh) {
                return (IndexRequest)req.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            }
            return req;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create metadata index request", e);
        }
    }

    public static IndexRequest managedIndexMetadataIndexRequest(ManagedIndexMetaData managedIndexMetadata) {
        return ManagedIndexUtils.managedIndexMetadataIndexRequest(managedIndexMetadata, true, false);
    }

    private static UpdateRequest updateEnabledField(String uuid, boolean enabled, Long enabledTime) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("managed_index").field("last_updated_time", Instant.now().toEpochMilli());
            builder.field("enabled", enabled);
            builder.field("enabled_time", enabledTime);
            builder.endObject().endObject();
            return new UpdateRequest(".opendistro-ism-config", uuid).doc(builder);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create update request", e);
        }
    }

    public static UpdateRequest updateDisableManagedIndexRequest(String uuid) {
        return ManagedIndexUtils.updateEnabledField(uuid, false, null);
    }

    public static UpdateRequest updateEnableManagedIndexRequest(String uuid) {
        return ManagedIndexUtils.updateEnabledField(uuid, true, Instant.now().toEpochMilli());
    }

    public static DeleteRequest deleteManagedIndexRequest(String uuid) {
        return new DeleteRequest(".opendistro-ism-config", uuid);
    }

    public static DeleteRequest deleteManagedIndexMetadataRequest(String uuid) {
        return new DeleteRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(uuid)).routing(uuid);
    }

    public static UpdateRequest updateManagedIndexRequest(SweptManagedIndexConfig sweptManagedIndexConfig) {
        try {
            return new UpdateRequest(".opendistro-ism-config", sweptManagedIndexConfig.getUuid()).setIfPrimaryTerm(sweptManagedIndexConfig.getPrimaryTerm()).setIfSeqNo(sweptManagedIndexConfig.getSeqNo()).doc(ManagedIndexUtils.getPartialChangePolicyBuilder(sweptManagedIndexConfig.getChangePolicy()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create update request", e);
        }
    }

    private static XContentBuilder getPartialChangePolicyBuilder(ChangePolicy changePolicy) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("managed_index");
        LuceniaExtensions.optionalTimeField(builder, "last_updated_time", Instant.now());
        builder.field("change_policy", (ToXContent)changePolicy);
        return builder.endObject().endObject();
    }

    public static List<String> getManagedIndicesToDelete(List<String> currentIndexUuids, List<String> currentManagedIndexUuids) {
        return currentManagedIndexUuids.stream().filter(currentManagedIndex -> !currentIndexUuids.contains(currentManagedIndex)).collect(Collectors.toList());
    }

    public static SearchRequest getSweptManagedIndexSearchRequest(boolean scroll, int size) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)QueryBuilders.existsQuery((String)"managed_index"));
        SearchRequest req = new SearchRequest().indices(new String[]{".opendistro-ism-config"}).allowPartialSearchResults(false).source(new SearchSourceBuilder().size(size).seqNoAndPrimaryTerm(Boolean.valueOf(true)).fetchSource(new String[0], new String[0]).query((QueryBuilder)boolQueryBuilder)).preference(Preference.PRIMARY_FIRST.type());
        if (scroll) {
            req.scroll(TimeValue.timeValueMinutes((long)1L));
        }
        return req;
    }

    public static SearchRequest getSweptManagedIndexSearchRequest() {
        return ManagedIndexUtils.getSweptManagedIndexSearchRequest(false, 10000);
    }

    public static boolean evaluateConditions(Transition transition, TransitionConditionContext context) {
        Conditions conditions = transition.getConditions();
        if (conditions == null) {
            return true;
        }
        if (ManagedIndexUtils.checkDocCount(conditions, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkIndexAge(conditions, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkSize(conditions, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkCron(conditions, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkRolloverAge(conditions, context)) {
            return true;
        }
        if (ManagedIndexUtils.checkNoAlias(conditions, context)) {
            return true;
        }
        return ManagedIndexUtils.checkMinStateAge(conditions, context);
    }

    private static boolean checkDocCount(Conditions conditions, TransitionConditionContext context) {
        return conditions.getDocCount() != null && context.getNumDocs() != null && conditions.getDocCount() <= context.getNumDocs();
    }

    private static boolean checkIndexAge(Conditions conditions, TransitionConditionContext context) {
        if (conditions.getIndexAge() != null) {
            long indexCreationDateMilli = context.getIndexCreationDate().toEpochMilli();
            if (indexCreationDateMilli == -1L) {
                return false;
            }
            long elapsedTime = Instant.now().toEpochMilli() - indexCreationDateMilli;
            return conditions.getIndexAge().millis() <= elapsedTime;
        }
        return false;
    }

    private static boolean checkSize(Conditions conditions, TransitionConditionContext context) {
        return conditions.getSize() != null && context.getIndexSize() != null && conditions.getSize().compareTo(context.getIndexSize()) <= 0;
    }

    private static boolean checkCron(Conditions conditions, TransitionConditionContext context) {
        if (conditions.getCron() != null) {
            return conditions.getCron().getNextExecutionTime(context.getTransitionStartTime()).compareTo(Instant.now()) <= 0;
        }
        return false;
    }

    private static boolean checkRolloverAge(Conditions conditions, TransitionConditionContext context) {
        if (conditions.getRolloverAge() != null) {
            if (context.getRolloverDate() == null) {
                return false;
            }
            long rolloverDateMilli = context.getRolloverDate().toEpochMilli();
            long elapsedTime = Instant.now().toEpochMilli() - rolloverDateMilli;
            return conditions.getRolloverAge().millis() <= elapsedTime;
        }
        return false;
    }

    private static boolean checkNoAlias(Conditions conditions, TransitionConditionContext context) {
        return conditions.getNoAlias() != null && context.getIndexAliasesCount() != null && (conditions.getNoAlias() != false && context.getIndexAliasesCount() == 0 || conditions.getNoAlias() == false && context.getIndexAliasesCount() > 0);
    }

    private static boolean checkMinStateAge(Conditions conditions, TransitionConditionContext context) {
        return conditions.getMinStateAge() != null && context.getStateStartTime() != null && System.currentTimeMillis() - context.getStateStartTime().toEpochMilli() >= conditions.getMinStateAge().millis();
    }

    public static boolean hasStatsConditions(Transition transition) {
        Conditions conditions = transition.getConditions();
        return conditions != null && (conditions.getDocCount() != null || conditions.getSize() != null);
    }

    public static boolean evaluateConditions(RolloverAction action, TimeValue indexAgeTimeValue, long numDocs, ByteSizeValue indexSize, ByteSizeValue primaryShardSize) {
        if (action.getMinDocs() == null && action.getMinAge() == null && action.getMinSize() == null && action.getMinPrimaryShardSize() == null) {
            return true;
        }
        if (action.getMinDocs() != null && action.getMinDocs() <= numDocs) {
            return true;
        }
        if (action.getMinAge() != null && action.getMinAge().getMillis() <= indexAgeTimeValue.getMillis()) {
            return true;
        }
        if (action.getMinSize() != null && action.getMinSize().getBytes() <= indexSize.getBytes()) {
            return true;
        }
        return action.getMinPrimaryShardSize() != null && action.getMinPrimaryShardSize().getBytes() <= primaryShardSize.getBytes();
    }

    public static StateMetaData getUpdatedStateMetaData(State state, ManagedIndexMetaData managedIndexMetaData) {
        StateMetaData stateMetaData = managedIndexMetaData.getStateMetaData();
        if (stateMetaData == null) {
            return new StateMetaData(state.getName(), Instant.now().toEpochMilli());
        }
        if (!state.getName().equals(stateMetaData.getName())) {
            return new StateMetaData(state.getName(), Instant.now().toEpochMilli());
        }
        return stateMetaData;
    }

    public static ManagedIndexConfig getManagedIndexConfig(String indexUuid, Client client) throws Exception {
        GetRequest request = ((GetRequest)new GetRequest().routing(indexUuid).index(".opendistro-ism-config")).id(indexUuid);
        final CompletableFuture future = new CompletableFuture();
        client.get(request, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            GetResponse response = (GetResponse)future.get();
            if (response.getSourceAsBytesRef() == null) {
                return null;
            }
            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
            return ParseUtils.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), ManagedIndexConfig::parse);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception("Interrupted while getting managed index config", e);
        }
        catch (ExecutionException e) {
            throw new Exception("Failed to get managed index config", e.getCause());
        }
    }

    public static long getIntervalFromManagedIndexConfig(ManagedIndexConfig managedIndexConfig) {
        Tuple periodTuple = managedIndexConfig.getSchedule().getPeriodStartingAt(Instant.now());
        return ((Instant)periodTuple.v2()).toEpochMilli() - ((Instant)periodTuple.v1()).toEpochMilli();
    }

    public static boolean isSuccessfulDelete(ManagedIndexMetaData managedIndexMetaData) {
        return managedIndexMetaData.getActionMetaData() != null && "delete".equals(managedIndexMetaData.getActionMetaData().getName()) && !managedIndexMetaData.getActionMetaData().getFailed() && managedIndexMetaData.getStepMetaData() != null && "delete".equals(managedIndexMetaData.getStepMetaData().getName()) && Step.StepStatus.COMPLETED.equals((Object)managedIndexMetaData.getStepMetaData().getStepStatus()) && (managedIndexMetaData.getPolicyRetryInfo() == null || !managedIndexMetaData.getPolicyRetryInfo().getFailed());
    }

    public static boolean isFailed(ManagedIndexMetaData managedIndexMetaData) {
        if (managedIndexMetaData.getPolicyRetryInfo() != null && managedIndexMetaData.getPolicyRetryInfo().getFailed()) {
            return true;
        }
        return managedIndexMetaData.getActionMetaData() != null && managedIndexMetaData.getActionMetaData().getFailed();
    }

    public static boolean isPolicyCompleted(ManagedIndexMetaData managedIndexMetaData) {
        return Boolean.TRUE.equals(managedIndexMetaData.getPolicyCompleted());
    }

    public static boolean shouldChangePolicy(ManagedIndexConfig managedIndexConfig, Action actionToExecute) {
        if (managedIndexConfig.getChangePolicy() == null) {
            return false;
        }
        if (managedIndexConfig.getChangePolicy().isSafe()) {
            return true;
        }
        return actionToExecute != null && "transition".equals(actionToExecute.getType());
    }

    public static boolean hasDifferentPolicyVersion(ManagedIndexMetaData managedIndexMetaData, ManagedIndexConfig managedIndexConfig) {
        return managedIndexMetaData.getPolicySeqNo() != managedIndexConfig.getPolicySeqNo() || managedIndexMetaData.getPolicyPrimaryTerm() != managedIndexConfig.getPolicyPrimaryTerm();
    }

    public static boolean hasDifferentJobInterval(ManagedIndexConfig managedIndexConfig, int jobInterval) {
        if (managedIndexConfig.getSchedule() instanceof IntervalSchedule) {
            IntervalSchedule schedule = (IntervalSchedule)managedIndexConfig.getSchedule();
            return schedule.getInterval() != jobInterval;
        }
        return false;
    }

    public static boolean isSafeToChange(Policy policy, String stateName, Policy newPolicy, ChangePolicy changePolicy) {
        if (stateName == null) {
            return true;
        }
        if (changePolicy.getState() != null) {
            return false;
        }
        State currentState = policy.getStates().stream().filter(s -> s.getName().equals(stateName)).findFirst().orElse(null);
        State newState = newPolicy.getStates().stream().filter(s -> s.getName().equals(stateName)).findFirst().orElse(null);
        if (currentState == null || newState == null) {
            return false;
        }
        if (currentState.getActions().size() != newState.getActions().size()) {
            return false;
        }
        for (int index = 0; index < currentState.getActions().size(); ++index) {
            Action action = currentState.getActions().get(index);
            Action newStateAction = newState.getActions().get(index);
            if (action.getType().equals(newStateAction.getType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllowed(Action action, List<String> allowList) {
        return allowList.contains(action.getType());
    }

    public static ManagedIndexMetaData getStartingManagedIndexMetaData(ManagedIndexMetaData metadata, State state, Action action, Step step) {
        if (state == null) {
            String stateInfo = metadata.getTransitionTo() != null ? metadata.getTransitionTo() : (metadata.getStateMetaData() != null ? metadata.getStateMetaData().toString() : "null");
            return new ManagedIndexMetaData.Builder(metadata).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).info(Map.of("message", "Failed to find state=" + stateInfo + " in policy=" + metadata.getPolicyID())).build();
        }
        if (action == null || step == null) {
            return new ManagedIndexMetaData.Builder(metadata).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).info(Map.of("message", "Failed to find action=" + String.valueOf(metadata.getActionMetaData()) + " in state=" + String.valueOf(metadata.getStateMetaData()))).build();
        }
        StateMetaData updatedStateMetaData = ManagedIndexUtils.getUpdatedStateMetaData(state, metadata);
        ActionMetaData updatedActionMetaData = action.getUpdatedActionMetadata(metadata, state.getName());
        StepMetaData updatedStepMetaData = step.getStartingStepMetaData(metadata);
        return new ManagedIndexMetaData.Builder(metadata).stateMetaData(updatedStateMetaData).actionMetaData(updatedActionMetaData).stepMetaData(updatedStepMetaData).info(Map.of("message", "Starting action " + action.getType() + " and working on " + step.getName())).build();
    }

    public static ManagedIndexMetaData getCompletedManagedIndexMetaData(ManagedIndexMetaData metadata, Action action, Step step) {
        ManagedIndexMetaData updatedStepMetaData = step.getUpdatedManagedIndexMetadata(metadata);
        ActionMetaData actionMetaData = updatedStepMetaData.getActionMetaData();
        if (actionMetaData == null) {
            return new ManagedIndexMetaData.Builder(metadata).policyRetryInfo(new PolicyRetryInfoMetaData(true, 0)).info(Map.of("message", "Failed due to ActionMetaData being null")).build();
        }
        ActionMetaData updatedActionMetaData = updatedStepMetaData.getStepMetaData() != null && updatedStepMetaData.getStepMetaData().getStepStatus() == Step.StepStatus.FAILED ? (action.getConfigRetry() == null ? new ActionMetaData.Builder(actionMetaData).failed(true).build() : ((long)actionMetaData.getConsumedRetries() >= action.getConfigRetry().getCount() ? new ActionMetaData.Builder(actionMetaData).failed(true).build() : new ActionMetaData.Builder(actionMetaData).failed(false).consumedRetries(actionMetaData.getConsumedRetries() + 1).lastRetryTime(Long.valueOf(Instant.now().toEpochMilli())).build())) : actionMetaData;
        return new ManagedIndexMetaData.Builder(metadata).policyCompleted(updatedStepMetaData.getPolicyCompleted()).rolledOver(updatedStepMetaData.getRolledOver()).rolledOverIndexName(updatedStepMetaData.getRolledOverIndexName()).actionMetaData(updatedActionMetaData).stepMetaData(updatedStepMetaData.getStepMetaData()).transitionTo(updatedStepMetaData.getTransitionTo()).policyRetryInfo(updatedStepMetaData.getPolicyRetryInfo()).info(updatedStepMetaData.getInfo()).build();
    }

    public static boolean hasTimedOut(Action action, ActionMetaData actionMetaData) {
        if (actionMetaData == null || actionMetaData.getStartTime() == null || action.getConfigTimeout() == null) {
            return false;
        }
        long startTime = actionMetaData.getStartTime();
        long timeoutMillis = action.getConfigTimeout().getTimeout().millis();
        return Instant.now().toEpochMilli() - startTime > timeoutMillis;
    }

    public static ManagedIndexRunner.Pair<Boolean, Long> shouldBackoff(Action action, ActionMetaData actionMetaData, ActionRetry actionRetry) {
        if (action.getConfigRetry() == null || action.getConfigRetry().getBackoff() == null) {
            return null;
        }
        ActionRetry.Backoff.BackoffResult result = action.getConfigRetry().getBackoff().shouldBackoff(actionMetaData, actionRetry);
        if (result == null) {
            return null;
        }
        return new ManagedIndexRunner.Pair<Boolean, Long>(result.shouldBackoff(), result.getRemainingTime());
    }

    public static class TransitionConditionContext {
        private final Instant indexCreationDate;
        private final Long numDocs;
        private final ByteSizeValue indexSize;
        private final Instant transitionStartTime;
        private final Instant rolloverDate;
        private final Integer indexAliasesCount;
        private final Instant stateStartTime;

        public TransitionConditionContext(Instant indexCreationDate, Long numDocs, ByteSizeValue indexSize, Instant transitionStartTime, Instant rolloverDate, Integer indexAliasesCount, Instant stateStartTime) {
            this.indexCreationDate = indexCreationDate;
            this.numDocs = numDocs;
            this.indexSize = indexSize;
            this.transitionStartTime = transitionStartTime;
            this.rolloverDate = rolloverDate;
            this.indexAliasesCount = indexAliasesCount;
            this.stateStartTime = stateStartTime;
        }

        public Instant getIndexCreationDate() {
            return this.indexCreationDate;
        }

        public Long getNumDocs() {
            return this.numDocs;
        }

        public ByteSizeValue getIndexSize() {
            return this.indexSize;
        }

        public Instant getTransitionStartTime() {
            return this.transitionStartTime;
        }

        public Instant getRolloverDate() {
            return this.rolloverDate;
        }

        public Integer getIndexAliasesCount() {
            return this.indexAliasesCount;
        }

        public Instant getStateStartTime() {
            return this.stateStartTime;
        }
    }
}

