/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.util;

import io.lucenia.indexmanagement.common.model.notification.Channel;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.notifications.NotificationsPluginInterface;
import io.skylite.core.notifications.action.LegacyPublishNotificationRequest;
import io.skylite.core.notifications.legacy.destination.message.LegacyBaseMessage;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.notifications.model.SeverityType;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class NotificationUtils {
    private NotificationUtils() {
    }

    public static CompletableFuture<Void> publishLegacyNotification(LegacyBaseMessage baseMessage, Client client) {
        return LuceniaExtensions.suspendUntil((NodeClient)client, (c, listener) -> NotificationsPluginInterface.publishLegacyNotification((NodeClient)c, (LegacyPublishNotificationRequest)new LegacyPublishNotificationRequest(baseMessage), (ActionListener)listener)).thenAccept(res -> io.lucenia.indexmanagement.common.model.notification.NotificationUtils.validateResponseStatus(RestStatus.fromCode((int)res.getDestinationResponse().getStatusCode()), res.getDestinationResponse().getResponseContent()));
    }

    public static CompletableFuture<Void> sendNotification(Channel channel, Client client, String title, ManagedIndexMetaData managedIndexMetaData, String compiledMessage, User user) {
        EventSource eventSource = NotificationUtils.getEventSource(managedIndexMetaData, title);
        return channel.sendNotification(client, eventSource, compiledMessage, user);
    }

    public static EventSource getEventSource(ManagedIndexMetaData managedIndexMetaData, String title) {
        return new EventSource(title, managedIndexMetaData.getIndexUuid(), SeverityType.INFO, List.of());
    }
}

