/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.util;

import io.lucenia.indexmanagement.indexstatemanagement.model.ChangePolicy;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.SkyliteParseException;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class RestHandlerUtils {
    public static final String WITH_TYPE = "with_type";
    public static final String WITH_USER = "with_user";
    public static final ToXContent.MapParams XCONTENT_WITHOUT_TYPE = new ToXContent.MapParams(Map.of("with_type", "false"));
    public static final ToXContent.MapParams XCONTENT_WITHOUT_USER = new ToXContent.MapParams(Map.of("with_user", "false"));
    public static final ToXContent.MapParams XCONTENT_WITHOUT_TYPE_AND_USER = new ToXContent.MapParams(Map.of("with_type", "false", "with_user", "false"));
    public static final String FAILURES = "failures";
    public static final String FAILED_INDICES = "failed_indices";
    public static final String UPDATED_INDICES = "updated_indices";
    public static final String TOTAL_MANAGED_INDICES = "total_managed_indices";
    public static final String ISM_TEMPLATE_FIELD = "policy.ism_template";
    public static final String MANAGED_INDEX_FIELD = "managed_index";
    public static final String MANAGED_INDEX_NAME_KEYWORD_FIELD = "managed_index.name.keyword";
    public static final String MANAGED_INDEX_INDEX_FIELD = "managed_index.index";
    public static final String MANAGED_INDEX_INDEX_UUID_FIELD = "managed_index.index_uuid";
    public static final String MANAGED_INDEX_POLICY_ID_FIELD = "managed_index.policy_id";
    public static final String DEFAULT_JOB_SORT_FIELD = "managed_index.index";
    public static final String DEFAULT_POLICY_SORT_FIELD = "policy.policy_id.keyword";
    public static final String SHOW_POLICY_QUERY_PARAM = "show_policy";
    public static final boolean DEFAULT_EXPLAIN_SHOW_POLICY = false;
    public static final String SHOW_VALIDATE_ACTION = "validate_action";
    public static final boolean DEFAULT_EXPLAIN_VALIDATE_ACTION = false;
    public static final String INDEX_HIDDEN = "index.hidden";
    public static final String INDEX_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final String INDEX_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final String TYPE_PARAM_KEY = "type";
    public static final String DEFAULT_INDEX_TYPE = "_default";
    public static final String MASTER_TIMEOUT_DEPRECATED_MESSAGE = "Parameter [master_timeout] is deprecated and will be removed in 3.0. To support inclusive language, please use [cluster_manager_timeout] instead.";
    public static final String DUPLICATE_PARAMETER_ERROR_MESSAGE = "Please only use one of the request parameters [master_timeout, cluster_manager_timeout].";

    private RestHandlerUtils() {
    }

    public static void buildInvalidIndexResponse(XContentBuilder builder, List<FailedIndex> failedIndices) throws IOException {
        if (!failedIndices.isEmpty()) {
            builder.field(FAILURES, true);
            builder.startArray(FAILED_INDICES);
            for (FailedIndex failedIndex : failedIndices) {
                failedIndex.toXContent(builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endArray();
        } else {
            builder.field(FAILURES, false);
            builder.startArray(FAILED_INDICES).endArray();
        }
    }

    public static XContentBuilder getPartialChangePolicyBuilder(ChangePolicy changePolicy) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject(MANAGED_INDEX_FIELD);
        LuceniaExtensions.optionalTimeField(builder, "last_updated_time", Instant.now());
        builder.field("change_policy", (ToXContent)changePolicy);
        return builder.endObject().endObject();
    }

    public static TimeValue parseClusterManagerTimeout(RestRequest request, DeprecationLogger deprecationLogger, String restActionName) {
        TimeValue timeout = request.paramAsTime("cluster_manager_timeout", ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT);
        if (request.hasParam("master_timeout")) {
            deprecationLogger.deprecate(restActionName + "_master_timeout_parameter", MASTER_TIMEOUT_DEPRECATED_MESSAGE, new Object[0]);
            if (request.hasParam("cluster_manager_timeout")) {
                throw new SkyliteParseException(DUPLICATE_PARAMETER_ERROR_MESSAGE, new Object[0]);
            }
            timeout = request.paramAsTime("master_timeout", timeout);
        }
        return timeout;
    }

    public static class FailedIndex
    implements Writeable,
    ToXContentFragment {
        public static final String INDEX_NAME_FIELD = "index_name";
        public static final String INDEX_UUID_FIELD = "index_uuid";
        public static final String REASON_FIELD = "reason";
        private final String name;
        private final String uuid;
        private final String reason;

        public FailedIndex(String name, String uuid, String reason) {
            this.name = name;
            this.uuid = uuid;
            this.reason = reason;
        }

        public FailedIndex(StreamInput sin) throws IOException {
            this.name = sin.readString();
            this.uuid = sin.readString();
            this.reason = sin.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.uuid);
            out.writeString(this.reason);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(INDEX_NAME_FIELD, this.name).field(INDEX_UUID_FIELD, this.uuid).field(REASON_FIELD, this.reason).endObject();
        }

        public String getName() {
            return this.name;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedIndex that = (FailedIndex)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.reason, that.reason);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.uuid, this.reason);
        }

        public String toString() {
            return "FailedIndex{name='" + this.name + "', uuid='" + this.uuid + "', reason='" + this.reason + "'}";
        }
    }
}

