/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.util;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.cluster.health.ClusterHealthRequest;
import io.skylite.core.action.admin.cluster.health.ClusterHealthResponse;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.action.admin.indices.stats.ShardStats;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.LockServiceInterface;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import io.skylite.indexmanagement.model.ShrinkActionProperties;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;

public final class StepUtils {
    private static final double DISK_THRESHOLD_EPSILON = 0.001;
    private static final int PERCENT_MULTIPLIER = 100;

    private StepUtils() {
    }

    public static void issueUpdateSettingsRequest(Client client, String indexName, Settings settings, ActionListener<AcknowledgedResponse> listener) {
        client.admin().indices().updateSettings(new UpdateSettingsRequest(settings, new String[]{indexName}), listener);
    }

    public static AcknowledgedResponse issueUpdateSettingsRequest(Client client, String indexName, Settings settings) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        StepUtils.issueUpdateSettingsRequest(client, indexName, settings, new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (AcknowledgedResponse)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception("Interrupted while updating settings", e);
        }
        catch (ExecutionException e) {
            throw new Exception("Failed to update settings", e.getCause());
        }
    }

    public static void releaseShrinkLock(ShrinkActionProperties shrinkActionProperties, LockServiceInterface lockService, ActionListener<Boolean> listener) {
        LockModel lock = StepUtils.getShrinkLockModel(shrinkActionProperties);
        lockService.release(lock, listener);
    }

    public static boolean releaseShrinkLock(ShrinkActionProperties shrinkActionProperties, LockServiceInterface lockService) throws Exception {
        LockModel lock = StepUtils.getShrinkLockModel(shrinkActionProperties);
        final CompletableFuture future = new CompletableFuture();
        lockService.release(lock, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception("Interrupted while releasing lock", e);
        }
        catch (ExecutionException e) {
            throw new Exception("Failed to release lock", e.getCause());
        }
    }

    public static void deleteShrinkLock(ShrinkActionProperties shrinkActionProperties, LockServiceInterface lockService, Logger logger, ActionListener<Boolean> listener) {
        String lockID = StepUtils.getShrinkLockID(shrinkActionProperties.getNodeName());
        logger.info("Deleting lock: " + lockID);
        lockService.deleteLock(lockID, listener);
    }

    public static boolean deleteShrinkLock(ShrinkActionProperties shrinkActionProperties, LockServiceInterface lockService, Logger logger) throws Exception {
        String lockID = StepUtils.getShrinkLockID(shrinkActionProperties.getNodeName());
        logger.info("Deleting lock: " + lockID);
        final CompletableFuture future = new CompletableFuture();
        lockService.deleteLock(lockID, (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception("Interrupted while deleting lock", e);
        }
        catch (ExecutionException e) {
            throw new Exception("Failed to delete lock", e.getCause());
        }
    }

    public static void renewShrinkLock(ShrinkActionProperties shrinkActionProperties, LockServiceInterface lockService, Logger logger, ActionListener<LockModel> listener) {
        LockModel lock = StepUtils.getShrinkLockModel(shrinkActionProperties);
        lockService.renewLock(lock, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            logger.error("Failed to renew Shrink action lock on node [" + shrinkActionProperties.getNodeName() + "]: " + String.valueOf(e));
            listener.onResponse(null);
        }));
    }

    public static LockModel renewShrinkLock(ShrinkActionProperties shrinkActionProperties, LockServiceInterface lockService, Logger logger) {
        LockModel lock = StepUtils.getShrinkLockModel(shrinkActionProperties);
        final CompletableFuture future = new CompletableFuture();
        lockService.renewLock(lock, (ActionListener)new ActionListener<LockModel>(){

            public void onResponse(LockModel response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (LockModel)future.get();
        }
        catch (Exception e) {
            logger.error("Failed to renew Shrink action lock on node [" + shrinkActionProperties.getNodeName() + "]: " + String.valueOf(e));
            return null;
        }
    }

    public static LockModel getShrinkLockModel(ShrinkActionProperties shrinkActionProperties) {
        return StepUtils.getShrinkLockModel(shrinkActionProperties.getNodeName(), ".opendistro-ism-config", shrinkActionProperties.getLockEpochSecond(), shrinkActionProperties.getLockPrimaryTerm(), shrinkActionProperties.getLockSeqNo(), shrinkActionProperties.getLockDurationSecond());
    }

    public static LockModel getShrinkLockModel(String nodeName, String jobIndexName, long lockEpochSecond, long lockPrimaryTerm, long lockSeqNo, long lockDurationSecond) {
        String jobID = StepUtils.getShrinkJobID(nodeName);
        Instant lockCreationInstant = Instant.ofEpochSecond(lockEpochSecond);
        return new LockModel(jobIndexName, jobID, lockCreationInstant, lockDurationSecond, false, lockSeqNo, lockPrimaryTerm);
    }

    public static ShrinkActionProperties getUpdatedShrinkActionProperties(ShrinkActionProperties shrinkActionProperties, LockModel lock) {
        return new ShrinkActionProperties(shrinkActionProperties.getNodeName(), shrinkActionProperties.getTargetIndexName(), shrinkActionProperties.getTargetNumShards(), lock.getPrimaryTerm(), lock.getSeqNo(), lock.getLockTime().getEpochSecond(), lock.getLockDurationSeconds(), shrinkActionProperties.getOriginalIndexSettings());
    }

    public static Instant getActionStartTime(ManagedIndexMetaData managedIndexMetaData) {
        if (managedIndexMetaData.getActionMetaData() != null && managedIndexMetaData.getActionMetaData().getStartTime() != null) {
            return Instant.ofEpochMilli(managedIndexMetaData.getActionMetaData().getStartTime());
        }
        return Instant.now();
    }

    public static long getFreeBytesThresholdHigh(ClusterSettings clusterSettings, long totalNodeBytes) {
        DiskThresholdSettings diskThresholdSettings = new DiskThresholdSettings(StepUtils.getDiskSettings(clusterSettings), clusterSettings);
        double diskThresholdPercent = diskThresholdSettings.getFreeDiskThresholdHigh();
        long diskThresholdBytes = diskThresholdSettings.getFreeBytesThresholdHigh().getBytes();
        if (diskThresholdPercent > 0.001) {
            return (long)(diskThresholdPercent / 100.0 * (double)totalNodeBytes);
        }
        return diskThresholdBytes;
    }

    public static Settings getDiskSettings(ClusterSettings clusterSettings) {
        return Settings.builder().put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING)).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING)).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), (String)clusterSettings.get(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING)).build();
    }

    public static long getNodeFreeDiskSpaceAfterShrink(NodeStats node, long indexSizeInBytes, ClusterSettings clusterSettings) {
        long totalNodeDisk;
        long freeBytesThresholdHigh;
        long requiredBytes;
        long diskSpaceLeftInNode;
        if (node.getFs() != null && (diskSpaceLeftInNode = node.getFs().getTotal().getFree().getBytes()) > (requiredBytes = 2L * indexSizeInBytes + (freeBytesThresholdHigh = StepUtils.getFreeBytesThresholdHigh(clusterSettings, totalNodeDisk = node.getFs().getTotal().getTotal().getBytes())))) {
            return diskSpaceLeftInNode - requiredBytes;
        }
        return -1L;
    }

    public static boolean isIndexGreen(Client client, String indexName) throws Exception {
        return StepUtils.isIndexGreen(client, indexName, TimeValue.timeValueMillis((long)30000L));
    }

    public static boolean isIndexGreen(Client client, String indexName, TimeValue timeout) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        ClusterHealthRequest healthReq = new ClusterHealthRequest().indices(new String[]{indexName}).waitForGreenStatus().timeout(timeout);
        client.admin().cluster().health(healthReq, (ActionListener)new ActionListener<ClusterHealthResponse>(){

            public void onResponse(ClusterHealthResponse response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            ClusterHealthResponse response = (ClusterHealthResponse)future.get();
            return !response.isTimedOut();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception("Interrupted while checking index health", e);
        }
        catch (ExecutionException e) {
            throw new Exception("Failed to check index health", e.getCause());
        }
    }

    public static void resetReadOnlyAndRouting(String index, Client client, Map<String, String> originalSettings, ActionListener<Boolean> listener) {
        Settings allocationSettings = Settings.builder().put("index.routing.allocation.require._name", originalSettings.get("index.routing.allocation.require._name")).put(IndexMetadata.SETTING_BLOCKS_WRITE, originalSettings.get(IndexMetadata.SETTING_BLOCKS_WRITE)).build();
        StepUtils.issueUpdateSettingsRequest(client, index, allocationSettings, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(response -> listener.onResponse((Object)response.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)));
    }

    public static String getShrinkLockID(String nodeName) {
        return LockModel.generateLockId((String)".opendistro-ism-config", (String)StepUtils.getShrinkJobID(nodeName));
    }

    public static String getShrinkJobID(String nodeName) {
        return "shrink-node_name-" + nodeName;
    }

    public static Map<Integer, Set<String>> getShardIdToNodeNameSet(ShardStats[] shardStats, DiscoveryNodes nodes) {
        HashMap<Integer, Set<String>> shardIdToNodeList = new HashMap<Integer, Set<String>>();
        for (ShardStats shard : shardStats) {
            String nodeName;
            int shardId = shard.getShardRouting().shardId().getId();
            String string = nodeName = nodes.get(shard.getShardRouting().currentNodeId()) != null ? nodes.get(shard.getShardRouting().currentNodeId()).getName() : null;
            if (nodeName == null) continue;
            shardIdToNodeList.computeIfAbsent(shardId, k -> new HashSet()).add(nodeName);
        }
        return shardIdToNodeList;
    }
}

