/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateClose;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateConvertIndexToRemote;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateDelete;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateForceMerge;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateIndexPriority;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateNothing;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateOpen;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateReadOnly;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateReadWrite;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateReplicaCount;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateRollover;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateSnapshot;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateStopReplication;
import io.lucenia.indexmanagement.indexstatemanagement.validation.ValidateTransition;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import io.skylite.indexmanagement.model.ValidationResult;

public class ActionValidation {
    private final Settings settings;
    private final ClusterService clusterService;
    private final JvmService jvmService;

    public ActionValidation(Settings settings, ClusterService clusterService, JvmService jvmService) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.jvmService = jvmService;
    }

    public ValidationResult validate(String actionName, String indexName) {
        Validate validation = switch (actionName) {
            case "rollover" -> new ValidateRollover(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "delete" -> new ValidateDelete(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "force_merge" -> new ValidateForceMerge(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "open" -> new ValidateOpen(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "read_only" -> new ValidateReadOnly(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "read_write" -> new ValidateReadWrite(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "replica_count" -> new ValidateReplicaCount(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "snapshot" -> new ValidateSnapshot(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "convert_index_to_remote" -> new ValidateConvertIndexToRemote(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "transition" -> new ValidateTransition(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "close" -> new ValidateClose(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "index_priority" -> new ValidateIndexPriority(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "stop_replication" -> new ValidateStopReplication(this.settings, this.clusterService, this.jvmService).execute(indexName);
            case "notification", "shrink", "allocation", "rollup" -> new ValidateNothing(this.settings, this.clusterService, this.jvmService).execute(indexName);
            default -> new ValidateNothing(this.settings, this.clusterService, this.jvmService).execute(indexName);
        };
        return new ValidationResult(validation.getValidationMessage(), validation.getValidationStatus());
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public JvmService getJvmService() {
        return this.jvmService;
    }
}

