/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.indices.InvalidIndexNameException;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public class ValidateConvertIndexToRemote
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateConvertIndexToRemote.class);
    public static final String NAME = "validate_convert_index_to_remote";

    public ValidateConvertIndexToRemote(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (!this.validIndexName(indexName)) {
            this.setValidationStatus(Validate.ValidationStatus.FAILED);
            return this;
        }
        if (this.indexExists(indexName)) {
            String message = ValidateConvertIndexToRemote.getIndexAlreadyExistsMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.FAILED);
            this.setValidationMessage(message);
            return this;
        }
        this.setValidationMessage(ValidateConvertIndexToRemote.getValidationPassedMessage(indexName));
        return this;
    }

    private boolean indexExists(String indexName) {
        return this.getClusterService().state().metadata().indices().containsKey(indexName);
    }

    private boolean validIndexName(String indexName) {
        BiFunction<String, String, RuntimeException> exceptionGenerator = (name, reason) -> new InvalidIndexNameException(name, reason);
        try {
            MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, exceptionGenerator);
        }
        catch (Exception e) {
            String message = ValidateConvertIndexToRemote.getIndexNotValidMessage(indexName);
            logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    public static String getIndexAlreadyExistsMessage(String index) {
        return "Index [index=" + index + "] already exists, cannot restore over existing index.";
    }

    public static String getIndexNotValidMessage(String index) {
        return "Index [index=" + index + "] is not valid for restore action.";
    }

    public static String getValidationPassedMessage(String index) {
        return "Restore action validation passed for [index=" + index + "]";
    }
}

