/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.indices.InvalidIndexNameException;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public class ValidateDelete
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateDelete.class);
    public static final String NAME = "validate_delete";

    public ValidateDelete(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (!this.deleteIndexExists(indexName) || !this.validIndex(indexName)) {
            return this;
        }
        RolloverTargetInfo rolloverTargetInfo = this.getRolloverTargetOrUpdateInfo(indexName);
        if (rolloverTargetInfo.rolloverTarget != null && !this.notWriteIndexForDataStream(rolloverTargetInfo.rolloverTarget, indexName)) {
            return this;
        }
        this.setValidationMessage(ValidateDelete.getValidationPassedMessage(indexName));
        return this;
    }

    private RolloverTargetInfo getRolloverTargetOrUpdateInfo(String indexName) {
        Metadata metadata = this.getClusterService().state().metadata();
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexName);
        boolean isDataStreamIndex = indexAbstraction != null && indexAbstraction.getParentDataStream() != null;
        String rolloverTarget = isDataStreamIndex ? indexAbstraction.getParentDataStream().getName() : ISMIndexMetadataExtensions.getRolloverAlias(metadata.index(indexName));
        return new RolloverTargetInfo(rolloverTarget, isDataStreamIndex);
    }

    private boolean notWriteIndexForDataStream(String alias, String indexName) {
        IndexAbstraction indexAbstraction;
        Boolean isWriteIndex;
        Metadata metadata = this.getClusterService().state().metadata();
        IndexMetadata indexMetadata = metadata.index(indexName);
        if (indexMetadata == null) {
            return true;
        }
        AliasMetadata indexAlias = (AliasMetadata)indexMetadata.getAliases().get(alias);
        Boolean bl = isWriteIndex = indexAlias != null ? indexAlias.writeIndex() : null;
        if (Boolean.TRUE.equals(isWriteIndex) && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(alias)) != null) {
            List aliasIndices = indexAbstraction.getIndices().stream().map(im -> im.getIndex().getName()).collect(Collectors.toList());
            logger.debug("Alias {} contains indices {}", (Object)alias, aliasIndices);
            String message = ValidateDelete.getFailedIsWriteIndexMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    private boolean deleteIndexExists(String indexName) {
        boolean indexExists = this.getClusterService().state().metadata().indices().containsKey(indexName);
        if (!indexExists) {
            String message = ValidateDelete.getNoIndexMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    private boolean validIndex(String indexName) {
        BiFunction<String, String, RuntimeException> exceptionGenerator = (index_name, reason) -> new InvalidIndexNameException(index_name, reason);
        try {
            MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, exceptionGenerator);
        }
        catch (Exception e) {
            String message = ValidateDelete.getIndexNotValidMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
        }
        return true;
    }

    public static String getNoIndexMessage(String index) {
        return "no such index [index=" + index + "]";
    }

    public static String getIndexNotValidMessage(String index) {
        return "delete index [index=" + index + "] not valid";
    }

    public static String getFailedIsWriteIndexMessage(String index) {
        return "Index [index=" + index + "] is the write index for data stream and cannot be deleted";
    }

    public static String getValidationPassedMessage(String index) {
        return "Delete validation passed for [index=" + index + "]";
    }

    private static class RolloverTargetInfo {
        final String rolloverTarget;
        final boolean isDataStreamIndex;

        RolloverTargetInfo(String rolloverTarget, boolean isDataStreamIndex) {
            this.rolloverTarget = rolloverTarget;
            this.isDataStreamIndex = isDataStreamIndex;
        }
    }
}

