/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.lucenia.indexmanagement.transform.settings.TransformSettings;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidateForceMerge
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateForceMerge.class);
    public static final String NAME = "validate_force_merge";

    public ValidateForceMerge(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (!this.dataSizeNotLarge(indexName)) {
            return this;
        }
        this.setValidationMessage(ValidateForceMerge.getValidationPassedMessage(indexName));
        return this;
    }

    public boolean dataSizeNotLarge(String indexName) {
        boolean circuitBreakerEnabled = (Boolean)TransformSettings.TRANSFORM_CIRCUIT_BREAKER_ENABLED.get(this.getSettings());
        int circuitBreakerJvmThreshold = (Integer)TransformSettings.TRANSFORM_CIRCUIT_BREAKER_JVM_THRESHOLD.get(this.getSettings());
        if (circuitBreakerEnabled && this.getJvmService().stats().getMem().getHeapUsedPercent() > circuitBreakerJvmThreshold) {
            String message = ValidateForceMerge.getFailedDataTooLargeMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return false;
        }
        return true;
    }

    public static String getFailedDataTooLargeMessage(String index) {
        return "Data too large and is over the allowed limit for index [index=" + index + "]";
    }

    public static String getValidationPassedMessage(String index) {
        return "Force merge validation passed for [index=" + index + "]";
    }
}

