/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidateIndexPriority
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateIndexPriority.class);
    public static final String NAME = "validate_index_priority";

    public ValidateIndexPriority(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (this.hasReadOnlyAllowDeleteBlock(indexName)) {
            return this;
        }
        this.setValidationMessage(ValidateIndexPriority.getValidationPassedMessage(indexName));
        return this;
    }

    public boolean hasReadOnlyAllowDeleteBlock(String indexName) {
        String readOnlyAllowDeleteBlock = this.getSettings().get(IndexMetadata.SETTING_READ_ONLY_ALLOW_DELETE);
        if (readOnlyAllowDeleteBlock != null && !readOnlyAllowDeleteBlock.isEmpty() && Boolean.parseBoolean(readOnlyAllowDeleteBlock)) {
            String message = ValidateIndexPriority.getReadOnlyAllowDeleteBlockMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.FAILED);
            return true;
        }
        return false;
    }

    public static String getReadOnlyAllowDeleteBlockMessage(String index) {
        return "read_only_allow_delete block is not null for index [index=" + index + "]";
    }

    public static String getValidationPassedMessage(String index) {
        return "Index Priority action validation passed for [index=" + index + "]";
    }
}

