/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidateOpen
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateOpen.class);
    public static final String NAME = "validate_open";

    public ValidateOpen(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (this.hasReadOnlyAllowDeleteBlock(indexName)) {
            return this;
        }
        this.setValidationMessage(ValidateOpen.getValidationPassedMessage(indexName));
        return this;
    }

    public boolean hasReadOnlyAllowDeleteBlock(String indexName) {
        String readOnlyAllowDeleteBlock = this.getSettings().get("read_only_allow_delete");
        if (readOnlyAllowDeleteBlock != null && !readOnlyAllowDeleteBlock.isEmpty()) {
            String message = ValidateOpen.getReadOnlyAllowDeleteBlockMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    public boolean maxNumberOfShardsExceeded(String indexName) {
        Metadata metadata = this.getClusterService().state().metadata();
        int totalShards = metadata.getTotalNumberOfShards();
        int openShards = metadata.getTotalOpenIndexShards();
        IndexMetadata indexMetadata = metadata.index(indexName);
        int numberOfShards = indexMetadata.getNumberOfShards();
        int replicaCount = indexMetadata.getNumberOfReplicas();
        if (replicaCount * numberOfShards > totalShards - openShards) {
            String message = ValidateOpen.getMaxNumberOfShardsExceededMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    public static String getReadOnlyAllowDeleteBlockMessage(String index) {
        return "read_only_allow_delete block is not null for index [index=" + index + "]";
    }

    public static String getMaxNumberOfShardsExceededMessage(String index) {
        return "Maximum number of shards exceeded for index [index=" + index + "]";
    }

    public static String getValidationPassedMessage(String index) {
        return "Open action validation passed for [index=" + index + "]";
    }
}

