/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.lucenia.indexmanagement.transform.settings.TransformSettings;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidateReadOnly
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateReadOnly.class);
    public static final String NAME = "validate_read_only";
    public static final String SETTING_KEY = "read_only_allow_delete";

    public ValidateReadOnly(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (this.dataSizeTooLarge(indexName) || this.hasReadOnlyAllowDeleteBlock(indexName)) {
            return this;
        }
        this.setValidationMessage(ValidateReadOnly.getValidationPassedMessage(indexName));
        return this;
    }

    public boolean hasReadOnlyAllowDeleteBlock(String indexName) {
        String readOnlyAllowDeleteBlock = this.getSettings().get(SETTING_KEY);
        if (readOnlyAllowDeleteBlock != null && !readOnlyAllowDeleteBlock.isEmpty()) {
            String message = ValidateReadOnly.getReadOnlyAllowDeleteBlockMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    public boolean dataSizeTooLarge(String indexName) {
        boolean circuitBreakerEnabled = (Boolean)TransformSettings.TRANSFORM_CIRCUIT_BREAKER_ENABLED.get(this.getSettings());
        int circuitBreakerJvmThreshold = (Integer)TransformSettings.TRANSFORM_CIRCUIT_BREAKER_JVM_THRESHOLD.get(this.getSettings());
        if (circuitBreakerEnabled && this.getJvmService().stats().getMem().getHeapUsedPercent() > circuitBreakerJvmThreshold) {
            String message = ValidateReadOnly.getFailedDataTooLargeMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    public static String getReadOnlyAllowDeleteBlockMessage(String index) {
        return "read_only_allow_delete block is not null for index [index=" + index + "]";
    }

    public static String getFailedDataTooLargeMessage(String index) {
        return "Data too large and is over the allowed limit for index [index=" + index + "]";
    }

    public static String getValidationPassedMessage(String index) {
        return "validate_read_only action validation passed for [index=" + index + "]";
    }
}

