/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidateReadWrite
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateReadWrite.class);
    public static final String NAME = "validate_read_write";
    public static final String SETTING_KEY = "read_only_allow_delete";

    public ValidateReadWrite(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (this.hasReadOnlyAllowDeleteBlock(indexName)) {
            return this;
        }
        this.setValidationMessage(ValidateReadWrite.getValidationPassedMessage(indexName));
        return this;
    }

    public boolean hasReadOnlyAllowDeleteBlock(String indexName) {
        String readOnlyAllowDeleteBlock = this.getSettings().get(SETTING_KEY);
        if (readOnlyAllowDeleteBlock != null && !readOnlyAllowDeleteBlock.isEmpty()) {
            String message = ValidateReadWrite.getReadOnlyAllowDeleteBlockMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    public static String getReadOnlyAllowDeleteBlockMessage(String index) {
        return "read_only_allow_delete block is not null for index [index=" + index + "]";
    }

    public static String getValidationPassedMessage(String index) {
        return "read_write validation passed for [index=" + index + "]";
    }
}

