/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.lucenia.indexmanagement.transform.settings.TransformSettings;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidateReplicaCount
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateReplicaCount.class);
    public static final String NAME = "validate_replica_count";

    public ValidateReplicaCount(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (this.dataSizeTooLarge(indexName)) {
            return this;
        }
        this.setValidationMessage(ValidateReplicaCount.getValidationPassedMessage(indexName));
        return this;
    }

    public boolean dataSizeTooLarge(String indexName) {
        boolean circuitBreakerEnabled = (Boolean)TransformSettings.TRANSFORM_CIRCUIT_BREAKER_ENABLED.get(this.getSettings());
        int circuitBreakerJvmThreshold = (Integer)TransformSettings.TRANSFORM_CIRCUIT_BREAKER_JVM_THRESHOLD.get(this.getSettings());
        if (circuitBreakerEnabled && this.getJvmService().stats().getMem().getHeapUsedPercent() > circuitBreakerJvmThreshold) {
            String message = ValidateReplicaCount.getFailedDataTooLargeMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    public boolean maxNumberOfShardsExceeded(String indexName) {
        Metadata metadata = this.getClusterService().state().metadata();
        int totalShards = metadata.getTotalNumberOfShards();
        int openShards = metadata.getTotalOpenIndexShards();
        IndexMetadata indexMetadata = metadata.index(indexName);
        int numberOfShards = indexMetadata.getNumberOfShards();
        int replicaCount = indexMetadata.getNumberOfReplicas();
        if (replicaCount * numberOfShards > totalShards - openShards) {
            String message = ValidateReplicaCount.getMaxNumberOfShardsExceededMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            return true;
        }
        return false;
    }

    public static String getFailedDataTooLargeMessage(String index) {
        return "Data too large and is over the allowed limit for index [index=" + index + "]";
    }

    public static String getMaxNumberOfShardsExceededMessage(String index) {
        return "Maximum number of shards exceeded for index [index=" + index + "]";
    }

    public static String getValidationPassedMessage(String index) {
        return "Replica Count validation passed for [index=" + index + "]";
    }
}

