/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.lucenia.indexmanagement.indexstatemanagement.opensearchapi.ISMIndexMetadataExtensions;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ValidateRollover
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateRollover.class);
    public static final String NAME = "validate_rollover";

    public ValidateRollover(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        RolloverTargetInfo rolloverTargetInfo = this.getRolloverTargetOrUpdateInfo(indexName);
        if (rolloverTargetInfo.rolloverTarget == null) {
            return this;
        }
        if (this.skipRollover(indexName) || this.alreadyRolledOver(rolloverTargetInfo.rolloverTarget, indexName)) {
            return this;
        }
        if (!(rolloverTargetInfo.isDataStream || this.hasAlias(rolloverTargetInfo.rolloverTarget, indexName) && this.isWriteIndex(rolloverTargetInfo.rolloverTarget, indexName))) {
            return this;
        }
        this.setValidationMessage(ValidateRollover.getValidationPassedMessage(indexName));
        return this;
    }

    private boolean skipRollover(String indexName) {
        boolean skipRollover = ISMIndexMetadataExtensions.getRolloverSkip(this.getClusterService().state().metadata().index(indexName));
        if (skipRollover) {
            this.setValidationStatus(Validate.ValidationStatus.PASSED);
            this.setValidationMessage(ValidateRollover.getSkipRolloverMessage(indexName));
            return true;
        }
        return false;
    }

    private boolean alreadyRolledOver(String alias, String indexName) {
        IndexMetadata indexMetadata = this.getClusterService().state().metadata().index(indexName);
        if (indexMetadata.getRolloverInfos() != null && indexMetadata.getRolloverInfos().containsKey(alias)) {
            this.setValidationStatus(Validate.ValidationStatus.PASSED);
            this.setValidationMessage(ValidateRollover.getAlreadyRolledOverMessage(indexName, alias));
            return true;
        }
        return false;
    }

    private boolean hasAlias(String alias, String indexName) {
        Metadata metadata = this.getClusterService().state().metadata();
        IndexMetadata indexMetadata = metadata.index(indexName);
        if (indexMetadata == null) {
            return false;
        }
        AliasMetadata indexAlias = (AliasMetadata)indexMetadata.getAliases().get(alias);
        logger.debug("Index {} has aliases {}", (Object)indexName, (Object)indexAlias);
        if (indexAlias == null) {
            String message = ValidateRollover.getMissingAliasMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    private boolean isWriteIndex(String alias, String indexName) {
        IndexAbstraction indexAbstraction;
        Boolean isWriteIndex;
        Metadata metadata = this.getClusterService().state().metadata();
        IndexMetadata indexMetadata = metadata.index(indexName);
        if (indexMetadata == null) {
            return false;
        }
        AliasMetadata indexAlias = (AliasMetadata)indexMetadata.getAliases().get(alias);
        Boolean bl = isWriteIndex = indexAlias != null ? indexAlias.writeIndex() : null;
        if (!Boolean.TRUE.equals(isWriteIndex) && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(alias)) != null) {
            List aliasIndices = indexAbstraction.getIndices().stream().map(im -> im.getIndex().getName()).collect(Collectors.toList());
            logger.debug("Alias {} contains indices {}", (Object)alias, aliasIndices);
            if (aliasIndices.size() > 1) {
                String message = ValidateRollover.getFailedWriteIndexMessage(indexName);
                logger.warn(message);
                this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
                this.setValidationMessage(message);
                return false;
            }
        }
        return true;
    }

    private RolloverTargetInfo getRolloverTargetOrUpdateInfo(String indexName) {
        Metadata metadata = this.getClusterService().state().metadata();
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexName);
        boolean isDataStreamIndex = indexAbstraction != null && indexAbstraction.getParentDataStream() != null;
        String rolloverTarget = isDataStreamIndex ? indexAbstraction.getParentDataStream().getName() : ISMIndexMetadataExtensions.getRolloverAlias(metadata.index(indexName));
        if (rolloverTarget == null) {
            String message = ValidateRollover.getFailedNoValidAliasMessage(indexName);
            logger.warn(message);
            this.setValidationStatus(Validate.ValidationStatus.RE_VALIDATING);
            this.setValidationMessage(message);
        }
        return new RolloverTargetInfo(rolloverTarget, isDataStreamIndex);
    }

    public static String getFailedWriteIndexMessage(String index) {
        return "Not the write index when rollover [index=" + index + "]";
    }

    public static String getMissingAliasMessage(String index) {
        return "Missing alias when rollover [index=" + index + "]";
    }

    public static String getFailedNoValidAliasMessage(String index) {
        return "Missing rollover_alias index setting [index=" + index + "]";
    }

    public static String getAlreadyRolledOverMessage(String index, String alias) {
        return "This index has already been rolled over using this alias, treating as a success [index=" + index + ", alias=" + alias + "]";
    }

    public static String getSkipRolloverMessage(String index) {
        return "Skipped rollover action for [index=" + index + "]";
    }

    public static String getValidationPassedMessage(String index) {
        return "Rollover validation passed for [index=" + index + "]";
    }

    private static class RolloverTargetInfo {
        final String rolloverTarget;
        final boolean isDataStream;

        RolloverTargetInfo(String rolloverTarget, boolean isDataStream) {
            this.rolloverTarget = rolloverTarget;
            this.isDataStream = isDataStream;
        }
    }
}

