/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.indexstatemanagement.validation;

import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.indices.InvalidIndexNameException;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.settings.Settings;
import io.skylite.indexmanagement.Validate;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public class ValidateSnapshot
extends Validate {
    private static final Logger logger = LogManager.getLogger(ValidateSnapshot.class);
    public static final String NAME = "validate_snapshot";

    public ValidateSnapshot(Settings settings, ClusterService clusterService, JvmService jvmService) {
        super(settings, clusterService, jvmService);
    }

    public Validate execute(String indexName) {
        if (!this.indexExists(indexName) || !this.validIndex(indexName)) {
            this.setValidationStatus(Validate.ValidationStatus.FAILED);
            return this;
        }
        this.setValidationMessage(ValidateSnapshot.getValidationPassedMessage(indexName));
        return this;
    }

    private boolean indexExists(String indexName) {
        boolean indexExists = this.getClusterService().state().metadata().indices().containsKey(indexName);
        if (!indexExists) {
            String message = ValidateSnapshot.getNoIndexMessage(indexName);
            logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    private boolean validIndex(String indexName) {
        BiFunction<String, String, RuntimeException> exceptionGenerator = (index_name, reason) -> new InvalidIndexNameException(index_name, reason);
        try {
            MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, exceptionGenerator);
        }
        catch (Exception e) {
            String message = ValidateSnapshot.getIndexNotValidMessage(indexName);
            logger.warn(message);
            this.setValidationMessage(message);
            return false;
        }
        return true;
    }

    public static String getNoIndexMessage(String index) {
        return "Index [index=" + index + "] does not exist for snapshot action.";
    }

    public static String getIndexNotValidMessage(String index) {
        return "Index [index=" + index + "] is not valid for snapshot action.";
    }

    public static String getValidationPassedMessage(String index) {
        return "Snapshot action validation passed for [index=" + index + "]";
    }
}

