/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.luceniaapi;

import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.security.InjectSecurity;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import java.io.Closeable;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexManagementSecurityContext
implements Closeable {
    private static final Logger logger = LogManager.getLogger(IndexManagementSecurityContext.class);
    private final String id;
    private final InjectSecurity injector;
    private final User user;

    public IndexManagementSecurityContext(String id, Settings settings, ThreadContext threadContext, User user) {
        this.id = id;
        this.injector = new InjectSecurity(id, settings, threadContext);
        this.user = user;
        this.inject();
    }

    private void inject() {
        logger.debug("Setting security context in thread {} for job {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        ArrayList roles = this.user == null ? SecurityUtils.DEFAULT_INJECT_ROLES : new ArrayList(this.user.getRoles());
        logger.debug("Injecting roles {} for job {}", roles, (Object)this.id);
        this.injector.injectRoles(roles);
        this.injector.injectProperty("index_management_plugin_internal_user", (Object)true);
        if (this.user != null) {
            String userString = SecurityUtils.generateUserString(this.user);
            logger.debug("Injecting user info {} for job {}", (Object)userString, (Object)this.id);
            this.injector.injectProperty("_opendistro_security_user_info", (Object)userString);
        }
    }

    @Override
    public void close() {
        logger.debug("Cleaning up security context in thread {} for job {}", (Object)Thread.currentThread().getName(), (Object)this.id);
        this.injector.close();
    }

    public InjectSecurity getInjector() {
        return this.injector;
    }

    public User getUser() {
        return this.user;
    }

    public String getId() {
        return this.id;
    }
}

