/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.luceniaapi;

import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.lucenia.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import io.lucenia.indexmanagement.indexstatemanagement.model.ISMTemplate;
import io.lucenia.indexmanagement.indexstatemanagement.settings.LegacyOpenDistroManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import io.lucenia.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.CheckedFunction;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.action.NoShardAvailableActionException;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.client.Client;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.jobs.LockService;
import io.skylite.core.notifications.NotificationsPluginInterface;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.security.InjectSecurity;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.indexmanagement.model.ManagedIndexMetaData;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LuceniaExtensions {
    private static final Logger log = LogManager.getLogger((String)"Index Management Helper");
    public static final String OPENDISTRO_SECURITY_PROTECTED_INDICES_CONF_REQUEST = "_opendistro_security_protected_indices_conf_request";

    private LuceniaExtensions() {
    }

    public static XContentParser contentParser(BytesReference bytesReference) throws IOException {
        return LuceniaExtensions.contentParser(bytesReference, NamedXContentRegistry.EMPTY);
    }

    public static XContentParser contentParser(BytesReference bytesReference, NamedXContentRegistry xContentRegistry) throws IOException {
        return XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)bytesReference, (MediaType)MediaTypeRegistry.JSON);
    }

    public static Map<String, Object> convertToMap(ToXContent toXContent) throws IOException {
        BytesReference bytesReference = XContentHelper.toXContent((ToXContent)toXContent, (MediaType)MediaTypeRegistry.JSON, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (boolean)false);
        return (Map)XContentHelper.convertToMap((BytesReference)bytesReference, (boolean)false, (MediaType)MediaTypeRegistry.JSON).v2();
    }

    public static Instant instant(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken().isValue()) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        XContentParserUtils.throwUnknownToken((XContentParser.Token)parser.currentToken(), (XContentLocation)parser.getTokenLocation());
        return null;
    }

    public static Instant parseInstant(XContentParser parser) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken().isValue()) {
            return Instant.ofEpochMilli(parser.longValue());
        }
        XContentParserUtils.throwUnknownToken((XContentParser.Token)parser.currentToken(), (XContentLocation)parser.getTokenLocation());
        return null;
    }

    public static XContentBuilder aliasesField(XContentBuilder builder, List<Alias> aliases) throws IOException {
        builder.startArray("aliases");
        for (Alias alias : aliases) {
            builder.startObject();
            alias.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
        }
        return builder.endArray();
    }

    public static XContentBuilder optionalTimeField(XContentBuilder builder, String name, Instant instant) throws IOException {
        if (instant == null) {
            return builder.nullField(name);
        }
        return builder.timeField(name, name + "_in_millis", instant.toEpochMilli());
    }

    public static XContentBuilder optionalISMTemplateField(XContentBuilder builder, String name, List<ISMTemplate> ismTemplates) throws IOException {
        if (ismTemplates == null) {
            return builder.nullField(name);
        }
        return builder.field("ism_template", (Object)ismTemplates.toArray(new ISMTemplate[0]));
    }

    public static XContentBuilder optionalUserField(XContentBuilder builder, String name, User user) throws IOException {
        if (user == null) {
            return builder.nullField(name);
        }
        return builder.field(name, (ToXContent)user);
    }

    public static CompletableFuture<Pair<ManagedIndexMetaData, Boolean>> getManagedIndexMetadata(Client client, String indexUUID) {
        CompletableFuture<Pair<ManagedIndexMetaData, Boolean>> future = new CompletableFuture<Pair<ManagedIndexMetaData, Boolean>>();
        try {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(indexUUID)).routing(indexUUID);
            ((CompletableFuture)LuceniaExtensions.suspendUntil(client, (c, listener) -> c.get(getRequest, listener)).thenAccept(getResponse -> {
                try {
                    if (!getResponse.isExists() || getResponse.isSourceEmpty()) {
                        future.complete(new Pair<Object, Boolean>(null, true));
                        return;
                    }
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)getResponse.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
                    ManagedIndexMetaData metadata = ManagedIndexMetaData.parseWithType((XContentParser)xcp, (String)getResponse.getId(), (long)getResponse.getSeqNo(), (long)getResponse.getPrimaryTerm());
                    future.complete(new Pair<ManagedIndexMetaData, Boolean>(metadata, true));
                }
                catch (Exception e) {
                    log.error("Failed to parse metadata", (Throwable)e);
                    future.complete(new Pair<Object, Boolean>(null, false));
                }
            })).exceptionally(e -> {
                Throwable cause;
                Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
                if (cause instanceof IndexNotFoundException || cause instanceof NoShardAvailableActionException) {
                    log.error("Failed to get metadata because no index or shard not available");
                } else {
                    log.error("Failed to get metadata", cause);
                }
                future.complete(new Pair<Object, Boolean>(null, false));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to create get request", (Throwable)e2);
            future.complete(new Pair<Object, Boolean>(null, false));
        }
        return future;
    }

    public static CompletableFuture<List<Pair<ManagedIndexMetaData, Exception>>> mgetManagedIndexMetadata(Client client, List<String> indexUuids) {
        log.debug("trying to get back metadata for index [{}]", indexUuids);
        if (indexUuids.isEmpty()) {
            return CompletableFuture.completedFuture(new ArrayList());
        }
        CompletableFuture<List<Pair<ManagedIndexMetaData, Exception>>> future = new CompletableFuture<List<Pair<ManagedIndexMetaData, Exception>>>();
        MultiGetRequest mgetRequest = LuceniaExtensions.buildMgetMetadataRequest(indexUuids);
        ((CompletableFuture)LuceniaExtensions.suspendUntil(client, (c, listener) -> c.multiGet(mgetRequest, listener)).thenAccept(response -> {
            Map<String, Pair<ManagedIndexMetaData, Exception>> resultMap = LuceniaExtensions.mgetResponseToMap(response);
            ArrayList<Pair<ManagedIndexMetaData, Exception>> results = new ArrayList<Pair<ManagedIndexMetaData, Exception>>(resultMap.values());
            future.complete(results);
        })).exceptionally(e -> {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof ActionRequestValidationException) {
                log.info("No managed index metadata for indices [{}], {}", (Object)indexUuids, (Object)cause.getMessage());
            } else {
                log.error("Failed to multi-get managed index metadata for indices [{}] {}", (Object)indexUuids, (Object)cause);
            }
            future.complete(new ArrayList());
            return null;
        });
        return future;
    }

    public static Map<String, Pair<ManagedIndexMetaData, Exception>> mgetResponseToMap(MultiGetResponse mgetResponse) {
        HashMap<String, Pair<ManagedIndexMetaData, Exception>> mgetMap = new HashMap<String, Pair<ManagedIndexMetaData, Exception>>();
        for (MultiGetItemResponse item : mgetResponse.getResponses()) {
            if (item.isFailed()) {
                mgetMap.put(item.getId(), new Pair<Object, Exception>(null, item.getFailure().getFailure()));
                continue;
            }
            if (item.getResponse() != null && !item.getResponse().isSourceEmpty()) {
                try {
                    XContentParser xcp = LuceniaExtensions.contentParser(item.getResponse().getSourceAsBytesRef());
                    ManagedIndexMetaData metadata = ManagedIndexMetaData.parseWithType((XContentParser)xcp, (String)item.getResponse().getId(), (long)item.getResponse().getSeqNo(), (long)item.getResponse().getPrimaryTerm());
                    mgetMap.put(item.getId(), new Pair<ManagedIndexMetaData, Object>(metadata, null));
                }
                catch (Exception e) {
                    mgetMap.put(item.getId(), new Pair<Object, Exception>(null, e));
                }
                continue;
            }
            mgetMap.put(item.getId(), null);
        }
        return mgetMap;
    }

    public static XContentBuilder addObject(XContentBuilder builder, String name, ToXContentFragment metadata, ToXContent.Params params, boolean forIndex) throws IOException {
        if (metadata != null) {
            return LuceniaExtensions.buildMetadata(builder, name, metadata, params);
        }
        return forIndex ? builder.nullField(name) : builder;
    }

    public static XContentBuilder addObject(XContentBuilder builder, String name, ToXContentFragment metadata, ToXContent.Params params) throws IOException {
        return LuceniaExtensions.addObject(builder, name, metadata, params, false);
    }

    public static XContentBuilder buildMetadata(XContentBuilder builder, String name, ToXContentFragment metadata, ToXContent.Params params) throws IOException {
        builder.startObject(name);
        metadata.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    private static boolean isNullOrBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static List<String> getUuidsForClosedIndices(ClusterState state, DefaultIndexMetadataService defaultIndexMetadataService) {
        ArrayList<String> closeList = new ArrayList<String>();
        for (Map.Entry entry : state.metadata().indices().entrySet()) {
            if (((IndexMetadata)entry.getValue()).getState() != IndexMetadata.State.CLOSE) continue;
            closeList.add(defaultIndexMetadataService.getIndexUUID((IndexMetadata)entry.getValue()));
        }
        return closeList;
    }

    public static MultiGetRequest buildMgetMetadataRequest(List<String> indexUuids) {
        MultiGetRequest mgetMetadataRequest = new MultiGetRequest();
        for (String uuid : indexUuids) {
            mgetMetadataRequest.add(new MultiGetRequest.Item(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(uuid)).routing(uuid));
        }
        return mgetMetadataRequest;
    }

    public static <T> List<T> parseFromSearchResponse(SearchResponse response, NamedXContentRegistry xContentRegistry, Parser<T> parser) throws IOException {
        ArrayList<T> results = new ArrayList<T>();
        for (SearchHit hit : response.getHits().getHits()) {
            String id = hit.getId();
            long seqNo = hit.getSeqNo();
            long primaryTerm = hit.getPrimaryTerm();
            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)hit.getSourceRef(), (MediaType)MediaTypeRegistry.JSON);
            results.add(LuceniaExtensions.parseWithType(xcp, id, seqNo, primaryTerm, parser));
        }
        return results;
    }

    public static <T> List<T> parseFromSearchResponse(SearchResponse response, Parser<T> parser) throws IOException {
        return LuceniaExtensions.parseFromSearchResponse(response, NamedXContentRegistry.EMPTY, parser);
    }

    public static <T> T parseFromGetResponse(GetResponse response, NamedXContentRegistry xContentRegistry, Parser<T> parser) throws IOException {
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
        return LuceniaExtensions.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), parser);
    }

    public static <T> T parseFromGetResponse(GetResponse response, Parser<T> parser) throws IOException {
        return LuceniaExtensions.parseFromGetResponse(response, NamedXContentRegistry.EMPTY, parser);
    }

    public static <T> T retry(BackoffPolicy backoffPolicy, Logger logger, List<RestStatus> retryOn, Function<TimeValue, T> block) throws InterruptedException {
        Iterator iter = backoffPolicy.iterator();
        TimeValue backoff = TimeValue.ZERO;
        while (true) {
            try {
                return block.apply(backoff);
            }
            catch (SkyliteException e) {
                if (iter.hasNext() && (RetryUtils.isRetryable(e) || retryOn.contains(e.status()))) {
                    backoff = (TimeValue)iter.next();
                    logger.warn("Operation failed. Retrying in " + String.valueOf(backoff) + ".", (Throwable)e);
                    TimeUnit.MILLISECONDS.sleep(backoff.millis());
                    continue;
                }
                throw e;
            }
            catch (SkyliteRejectedExecutionException rje) {
                if (iter.hasNext()) {
                    backoff = (TimeValue)iter.next();
                    logger.warn("Rejected execution. Retrying in " + String.valueOf(backoff) + ".", (Throwable)rje);
                    TimeUnit.MILLISECONDS.sleep(backoff.millis());
                    continue;
                }
                throw rje;
            }
            break;
        }
    }

    public static String string(XContentBuilder builder) {
        return BytesReference.bytes((XContentBuilder)builder).utf8ToString();
    }

    public static Map<String, Object> toMap(XContentBuilder builder) {
        return (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)builder), (boolean)false, (MediaType)MediaTypeRegistry.JSON).v2();
    }

    public static <C extends SkyliteClient, T> CompletableFuture<T> suspendUntil(C client, BiConsumer<C, ActionListener<T>> block) {
        final CompletableFuture future = new CompletableFuture();
        block.accept(client, new ActionListener<T>(){

            public void onResponse(T response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static <T> CompletableFuture<T> suspendUntilLock(LockService lockService, BiConsumer<LockService, ActionListener<T>> block) {
        final CompletableFuture future = new CompletableFuture();
        block.accept(lockService, new ActionListener<T>(){

            public void onResponse(T response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static <T> CompletableFuture<T> suspendUntilNotification(NotificationsPluginInterface notificationsPlugin, BiConsumer<NotificationsPluginInterface, ActionListener<T>> block) {
        final CompletableFuture future = new CompletableFuture();
        block.accept(notificationsPlugin, new ActionListener<T>(){

            public void onResponse(T response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static RemoteTransportException findRemoteTransportException(Throwable throwable) {
        if (throwable instanceof RemoteTransportException) {
            return (RemoteTransportException)throwable;
        }
        if (throwable.getCause() != null) {
            return LuceniaExtensions.findRemoteTransportException(throwable.getCause());
        }
        return null;
    }

    public static String getUsefulCauseString(DefaultShardOperationFailedException exception) {
        RemoteTransportException rte = LuceniaExtensions.findRemoteTransportException(exception.getCause());
        if (rte == null) {
            return exception.toString();
        }
        return SkyliteExceptionsHelper.unwrapCause((Throwable)rte).toString();
    }

    public static <T> T parseWithType(XContentParser parser, String id, long seqNo, long primaryTerm, Parser<T> parseFunc) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        T parsed = parseFunc.parse(parser, id, seqNo, primaryTerm);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return parsed;
    }

    public static <T> T parseWithType(XContentParser parser, Parser<T> parseFunc) throws IOException {
        return LuceniaExtensions.parseWithType(parser, "", -2L, 0L, parseFunc);
    }

    public static <T> T parseWithType(XContentParser parser, String id, Parser<T> parseFunc) throws IOException {
        return LuceniaExtensions.parseWithType(parser, id, -2L, 0L, parseFunc);
    }

    public static XContentBuilder optionalField(XContentBuilder builder, String name, Object value) throws IOException {
        if (value != null) {
            return builder.field(name, value);
        }
        return builder;
    }

    public static XContentBuilder optionalInfoField(XContentBuilder builder, String name, SMMetadata.Info info) throws IOException {
        if (info != null && (info.getMessage() != null || info.getCause() != null)) {
            return builder.field(name, (ToXContent)info);
        }
        return builder;
    }

    public static <T> T nullValueHandler(XContentParser parser, CheckedFunction<XContentParser, T, IOException> block) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return (T)block.apply((Object)parser);
    }

    public static <T> List<T> parseArray(XContentParser parser, Function<XContentParser, T> block) throws IOException {
        ArrayList<T> resArr = new ArrayList<T>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            resArr.add(block.apply(parser));
        }
        return resArr;
    }

    public static <T> T readOptionalValue(StreamInput input, Writeable.Reader<T> reader) throws IOException {
        if (input.readBoolean()) {
            return (T)reader.read(input);
        }
        return null;
    }

    public static <T> void writeOptionalValue(StreamOutput output, T value, Writeable.Writer<T> writer) throws IOException {
        if (value == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            writer.write(output, value);
        }
    }

    public static <T> T withClosableContext(IndexManagementSecurityContext context, Supplier<T> block) {
        try {
            context.updateThreadContext();
            T t = block.get();
            return t;
        }
        finally {
            context.close();
        }
    }

    public static String getRolloverAlias(IndexMetadata indexMetadata) {
        if (LuceniaExtensions.isNullOrBlank(indexMetadata.getSettings().get(ManagedIndexSettings.ROLLOVER_ALIAS.getKey()))) {
            if (LuceniaExtensions.isNullOrBlank(indexMetadata.getSettings().get(LegacyOpenDistroManagedIndexSettings.ROLLOVER_ALIAS.getKey()))) {
                return null;
            }
            return indexMetadata.getSettings().get(LegacyOpenDistroManagedIndexSettings.ROLLOVER_ALIAS.getKey());
        }
        return indexMetadata.getSettings().get(ManagedIndexSettings.ROLLOVER_ALIAS.getKey());
    }

    public static boolean getRolloverSkip(IndexMetadata indexMetadata) {
        if (LuceniaExtensions.isNullOrBlank(indexMetadata.getSettings().get(ManagedIndexSettings.ROLLOVER_SKIP.getKey()))) {
            return indexMetadata.getSettings().getAsBoolean(LegacyOpenDistroManagedIndexSettings.ROLLOVER_SKIP.getKey(), Boolean.valueOf(false));
        }
        return indexMetadata.getSettings().getAsBoolean(ManagedIndexSettings.ROLLOVER_SKIP.getKey(), Boolean.valueOf(false));
    }

    public static class Pair<F, S> {
        private final F first;
        private final S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(XContentParser var1, String var2, long var3, long var5) throws IOException;
    }

    public static class IndexManagementSecurityContext {
        private static final Logger logger = LogManager.getLogger(IndexManagementSecurityContext.class);
        private final String id;
        private final ThreadContext threadContext;
        private final User user;
        private final InjectSecurity injector;

        public IndexManagementSecurityContext(String id, Settings settings, ThreadContext threadContext, User user) {
            this.id = id;
            this.threadContext = threadContext;
            this.user = user;
            this.injector = new InjectSecurity(id, settings, threadContext);
        }

        public InjectSecurity getInjector() {
            return this.injector;
        }

        public void updateThreadContext() {
            logger.debug("Setting security context in thread " + Thread.currentThread().getName() + " for job " + this.id);
            if (this.user == null) {
                this.injector.injectRoles(SecurityUtils.DEFAULT_INJECT_ROLES);
            } else {
                this.injector.injectRoles(this.user.getRoles());
            }
            this.injector.injectProperty("index_management_plugin_internal_user", (Object)true);
        }

        public void restoreThreadContext() {
            logger.debug("Cleaning up security context in thread " + Thread.currentThread().getName() + " for job " + this.id);
            this.injector.close();
        }

        public void close() {
            this.injector.close();
        }
    }
}

