/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.refreshanalyzer;

import io.lucenia.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerShardResponse;
import io.skylite.core.action.ShardOperationFailedException;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.broadcast.BroadcastResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestUtils;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RefreshSearchAnalyzerResponse
extends BroadcastResponse {
    private List<RefreshSearchAnalyzerShardResponse> shardResponses;
    private List<DefaultShardOperationFailedException> shardFailures;
    private static final ConstructingObjectParser<RefreshSearchAnalyzerResponse, Void> PARSER = new ConstructingObjectParser("_refresh_search_analyzers", true, arg -> {
        RefreshSearchAnalyzerResponse response = (RefreshSearchAnalyzerResponse)((Object)((Object)arg[0]));
        return new RefreshSearchAnalyzerResponse(response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), response.shardFailures, response.shardResponses);
    });

    public RefreshSearchAnalyzerResponse(StreamInput in) throws IOException {
        super(in);
        this.shardResponses = in.readList(RefreshSearchAnalyzerShardResponse::new);
        this.shardFailures = in.readList(DefaultShardOperationFailedException::readShardOperationFailed);
    }

    public RefreshSearchAnalyzerResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, List<RefreshSearchAnalyzerShardResponse> shardResponses) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardResponses = new ArrayList<RefreshSearchAnalyzerShardResponse>(shardResponses);
        this.shardFailures = new ArrayList<DefaultShardOperationFailedException>(shardFailures);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        RestUtils.buildBroadcastShardsHeader((XContentBuilder)builder, (ToXContent.Params)params, (int)this.getTotalShards(), (int)this.getSuccessfulShards(), (int)-1, (int)this.getFailedShards(), (ShardOperationFailedException[])((ShardOperationFailedException[])this.shardFailures.toArray(new DefaultShardOperationFailedException[0])));
        builder.startArray("successful_refresh_details");
        Map<String, List<String>> successfulIndices = this.getSuccessfulRefreshDetails();
        for (Map.Entry<String, List<String>> entry : successfulIndices.entrySet()) {
            String index = entry.getKey();
            List<String> reloadedAnalyzers = entry.getValue();
            builder.startObject().field("index", index).startArray("refreshed_analyzers");
            for (String analyzer : reloadedAnalyzers) {
                builder.value(analyzer);
            }
            builder.endArray().endObject();
        }
        builder.endArray().endObject();
        return builder;
    }

    public Map<String, List<String>> getSuccessfulRefreshDetails() {
        HashMap<String, List<String>> successfulRefreshDetails = new HashMap<String, List<String>>();
        HashSet<String> failedIndices = new HashSet<String>();
        for (DefaultShardOperationFailedException failure : this.shardFailures) {
            failedIndices.add(failure.index());
        }
        for (RefreshSearchAnalyzerShardResponse response : this.shardResponses) {
            if (failedIndices.contains(response.getIndex())) continue;
            successfulRefreshDetails.putIfAbsent(response.getIndex(), response.getReloadedAnalyzers());
        }
        return successfulRefreshDetails;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.shardResponses);
        out.writeCollection(this.shardFailures);
    }

    static {
        RefreshSearchAnalyzerResponse.declareBroadcastFields(PARSER);
    }
}

