/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.refreshanalyzer;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.lucenia.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerRequest;
import io.lucenia.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerResponse;
import io.lucenia.indexmanagement.refreshanalyzer.RefreshSearchAnalyzerShardResponse;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.analysis.AnalysisRegistry;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportRefreshSearchAnalyzerAction
extends TransportBroadcastByNodeAction<RefreshSearchAnalyzerRequest, RefreshSearchAnalyzerResponse, RefreshSearchAnalyzerShardResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final IndicesService indicesService;
    private final AnalysisRegistry analysisRegistry;

    @Inject
    public TransportRefreshSearchAnalyzerAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, AnalysisRegistry analysisRegistry, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/refresh_search_analyzers", clusterService, transportService, actionFilters, indexNameExpressionResolver, RefreshSearchAnalyzerRequest::new, "management");
        this.analysisRegistry = analysisRegistry;
        this.indicesService = indicesService;
    }

    protected RefreshSearchAnalyzerShardResponse readShardResult(StreamInput in) throws IOException {
        return new RefreshSearchAnalyzerShardResponse(in);
    }

    protected RefreshSearchAnalyzerResponse newResponse(RefreshSearchAnalyzerRequest request, int totalShards, int successfulShards, int failedShards, List<RefreshSearchAnalyzerShardResponse> shardResponses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new RefreshSearchAnalyzerResponse(totalShards, successfulShards, failedShards, shardFailures, shardResponses);
    }

    protected RefreshSearchAnalyzerRequest readRequestFrom(StreamInput in) throws IOException {
        return new RefreshSearchAnalyzerRequest(in);
    }

    protected RefreshSearchAnalyzerShardResponse shardOperation(RefreshSearchAnalyzerRequest request, ShardRouting shardRouting) throws IOException {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
        List reloadedAnalyzers = indexShard.mapperService().reloadSearchAnalyzers(this.analysisRegistry);
        this.log.info("Reload successful, index: {}, shard: {}, is_primary: {}", (Object)shardRouting.shardId().getIndex().getName(), (Object)shardRouting.shardId().id(), (Object)shardRouting.primary());
        return new RefreshSearchAnalyzerShardResponse(shardRouting.shardId(), reloadedAnalyzers);
    }

    protected ShardsIterator shards(ClusterState clusterState, RefreshSearchAnalyzerRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, RefreshSearchAnalyzerRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, RefreshSearchAnalyzerRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }
}

