/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup;

import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupStats;
import io.lucenia.indexmanagement.rollup.settings.RollupSettings;
import io.lucenia.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.aggregations.Aggregation;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.InternalValueCount;

public class RollupIndexer {
    private final Logger logger = LogManager.getLogger(RollupIndexer.class);
    private final Client client;
    private volatile BackoffPolicy retryIngestPolicy;

    public RollupIndexer(Settings settings, ClusterService clusterService, Client client) {
        this.client = client;
        this.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)((TimeValue)RollupSettings.ROLLUP_INGEST_BACKOFF_MILLIS.get(settings)), (int)((Integer)RollupSettings.ROLLUP_INGEST_BACKOFF_COUNT.get(settings)));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.ROLLUP_INGEST_BACKOFF_MILLIS, RollupSettings.ROLLUP_INGEST_BACKOFF_COUNT, (millis, count) -> {
            this.retryIngestPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
        });
    }

    public void indexRollups(Rollup rollup, InternalComposite internalComposite, ActionListener<RollupIndexResult> listener) {
        try {
            List<DocWriteRequest<?>> requestsToRetry = this.convertResponseToRequests(rollup, internalComposite);
            RollupStats stats = new RollupStats(0L, 0L, requestsToRetry.size(), 0L, 0L);
            ArrayList<BulkItemResponse> nonRetryableFailures = new ArrayList<BulkItemResponse>();
            if (requestsToRetry.isEmpty()) {
                listener.onResponse((Object)new RollupIndexResult.Success(stats));
                return;
            }
            this.retryIndexing(rollup, requestsToRetry, stats, nonRetryableFailures, 0, listener);
        }
        catch (RemoteTransportException e) {
            this.logger.error(e.getMessage(), e.getCause());
            listener.onResponse((Object)new RollupIndexResult.Failure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e)));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e.getCause());
            listener.onResponse((Object)new RollupIndexResult.Failure(e));
        }
    }

    private void retryIndexing(Rollup rollup, List<DocWriteRequest<?>> requestsToRetry, RollupStats stats, List<BulkItemResponse> nonRetryableFailures, int attemptNumber, ActionListener<RollupIndexResult> listener) {
        if (requestsToRetry.isEmpty()) {
            if (!nonRetryableFailures.isEmpty()) {
                this.logger.error("Failed to index {} documents", (Object)nonRetryableFailures.size());
                listener.onResponse((Object)new RollupIndexResult.Failure((Exception)((Object)SkyliteExceptionsHelper.convertToOpenSearchException((Exception)nonRetryableFailures.get(0).getFailure().getCause()))));
            } else {
                listener.onResponse((Object)new RollupIndexResult.Success(stats));
            }
            return;
        }
        BulkRequest bulkRequest = new BulkRequest().add(requestsToRetry);
        this.client.bulk(bulkRequest, ActionListener.wrap(bulkResponse -> {
            RollupStats updatedStats = new RollupStats(stats.getPagesProcessed(), stats.getDocumentsProcessed(), stats.getRollupsIndexed(), stats.getIndexTimeInMillis() + bulkResponse.getTook().getMillis(), stats.getSearchTimeInMillis());
            ArrayList<BulkItemResponse> retryableFailures = new ArrayList<BulkItemResponse>();
            ArrayList newRequestsToRetry = new ArrayList();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                if (item.status() == RestStatus.TOO_MANY_REQUESTS) {
                    retryableFailures.add(item);
                    newRequestsToRetry.add((DocWriteRequest)requestsToRetry.get(item.getItemId()));
                    continue;
                }
                nonRetryableFailures.add(item);
            }
            if (!newRequestsToRetry.isEmpty()) {
                Iterator backoffIterator = this.retryIngestPolicy.iterator();
                for (int i = 0; i < attemptNumber && backoffIterator.hasNext(); ++i) {
                    backoffIterator.next();
                }
                if (!backoffIterator.hasNext()) {
                    this.logger.error("Exceeded retry attempts for indexing rollup documents");
                    listener.onResponse((Object)new RollupIndexResult.Failure(new Exception("Exceeded retry attempts for indexing rollup documents")));
                    return;
                }
                long delayMillis = ((TimeValue)backoffIterator.next()).millis();
                if (delayMillis >= 900000L) {
                    listener.onResponse((Object)new RollupIndexResult.Failure(new IllegalStateException("Cannot retry ingestion with a delay more than half of the rollup lock TTL")));
                    return;
                }
                this.logger.warn("Retrying {} documents after {} ms", (Object)newRequestsToRetry.size(), (Object)delayMillis);
                this.scheduleRetry(rollup, newRequestsToRetry, updatedStats, nonRetryableFailures, attemptNumber + 1, listener, delayMillis);
            } else if (!nonRetryableFailures.isEmpty()) {
                listener.onResponse((Object)new RollupIndexResult.Failure((Exception)((Object)SkyliteExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)nonRetryableFailures.get(0)).getFailure().getCause()))));
            } else {
                listener.onResponse((Object)new RollupIndexResult.Success(updatedStats));
            }
        }, e -> {
            this.logger.error("Error during bulk indexing", (Throwable)e);
            listener.onResponse((Object)new RollupIndexResult.Failure((Exception)e));
        }));
    }

    private void scheduleRetry(Rollup rollup, List<DocWriteRequest<?>> requestsToRetry, RollupStats stats, List<BulkItemResponse> nonRetryableFailures, int attemptNumber, ActionListener<RollupIndexResult> listener, long delayMillis) {
        this.client.threadPool().schedule(() -> this.retryIndexing(rollup, requestsToRetry, stats, nonRetryableFailures, attemptNumber, listener), TimeValue.timeValueMillis((long)delayMillis), "generic");
    }

    public List<DocWriteRequest<?>> convertResponseToRequests(Rollup job, InternalComposite internalComposite) {
        ArrayList requests = new ArrayList();
        for (InternalComposite.InternalBucket bucket : internalComposite.getBuckets()) {
            StringBuilder docIdBuilder = new StringBuilder(job.getId()).append("#");
            for (Map.Entry entry : bucket.getKey().entrySet()) {
                docIdBuilder.append(entry.getValue() != null ? entry.getValue().toString() : "#ODFE-MAGIC-NULL-MAGIC-ODFE#").append("#");
            }
            String docId = docIdBuilder.toString();
            String documentId = IndexUtils.hashToFixedSize(docId);
            Map<String, Object> mapOfKeyValues = RollupUtils.getInitialDocValues(job, bucket.getDocCount());
            for (Map.Entry entry : bucket.getKey().entrySet()) {
                mapOfKeyValues.put((String)entry.getKey(), entry.getValue());
            }
            for (Aggregation agg : bucket.getAggregations()) {
                if (agg instanceof InternalSum) {
                    mapOfKeyValues.put(agg.getName(), ((InternalSum)agg).getValue());
                    continue;
                }
                if (agg instanceof InternalMax) {
                    InternalMax max = (InternalMax)agg;
                    mapOfKeyValues.put(agg.getName(), Double.isInfinite(max.getValue()) ? null : Double.valueOf(max.getValue()));
                    continue;
                }
                if (agg instanceof InternalMin) {
                    InternalMin min = (InternalMin)agg;
                    mapOfKeyValues.put(agg.getName(), Double.isInfinite(min.getValue()) ? null : Double.valueOf(min.getValue()));
                    continue;
                }
                if (agg instanceof InternalValueCount) {
                    mapOfKeyValues.put(agg.getName(), ((InternalValueCount)agg).getValue());
                    continue;
                }
                if (agg instanceof InternalAvg) {
                    mapOfKeyValues.put(agg.getName(), ((InternalAvg)agg).getValue());
                    continue;
                }
                throw new IllegalStateException("Found aggregation in composite result that is not supported [" + agg.getType() + " - " + agg.getName() + "]");
            }
            String targetIndexResolvedName = RollupFieldValueExpressionResolver.resolve(job, job.getTargetIndex());
            IndexRequest indexRequest = new IndexRequest(targetIndexResolvedName).id(documentId).source(mapOfKeyValues, MediaTypeRegistry.JSON);
            requests.add((DocWriteRequest<?>)indexRequest);
        }
        return requests;
    }

    public RollupIndexResult indexRollupsSync(Rollup rollup, InternalComposite internalComposite) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        this.indexRollups(rollup, internalComposite, new ActionListener<RollupIndexResult>(){

            public void onResponse(RollupIndexResult result) {
                future.complete(result);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (RollupIndexResult)future.get();
        }
        catch (ExecutionException e) {
            throw (Exception)e.getCause();
        }
    }

    public static abstract class RollupIndexResult {

        public static class Failure
        extends RollupIndexResult {
            private final String message;
            private final Exception cause;

            public Failure(Exception cause) {
                this("An error occurred while indexing to the rollup target index", cause);
            }

            public Failure(String message, Exception cause) {
                this.message = message;
                this.cause = cause;
            }

            public String getMessage() {
                return this.message;
            }

            public Exception getCause() {
                return this.cause;
            }
        }

        public static class Success
        extends RollupIndexResult {
            private final RollupStats stats;

            public Success(RollupStats stats) {
                this.stats = stats;
            }

            public RollupStats getStats() {
                return this.stats;
            }
        }
    }
}

