/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.rollup.action.mapping.UpdateRollupMappingAction;
import io.lucenia.indexmanagement.rollup.action.mapping.UpdateRollupMappingRequest;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupJobValidationResult;
import io.lucenia.indexmanagement.rollup.settings.LegacyOpenDistroRollupSettings;
import io.lucenia.indexmanagement.rollup.settings.RollupSettings;
import io.lucenia.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteSecurityException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsResponse;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.admin.indices.settings.put.UpdateSettingsRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RollupMapperService {
    private static final Logger logger = LogManager.getLogger(RollupMapperService.class);
    public static final String ROLLUPS = "rollups";
    private final Client client;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public RollupMapperService(Client client, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.client = client;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    private void validateAndAttemptToUpdateTargetIndex(Rollup rollup, String targetIndexResolvedName, boolean hasLegacyPlugin, ActionListener<RollupJobValidationResult> listener) throws IOException {
        if (RollupUtils.isTargetIndexAlias(rollup)) {
            this.validateTargetIndexAlias(rollup, targetIndexResolvedName, (ActionListener<RollupJobValidationResult>)ActionListener.wrap(aliasValidationResult -> {
                if (!(aliasValidationResult instanceof RollupJobValidationResult.Valid)) {
                    listener.onResponse(aliasValidationResult);
                } else if (!RollupUtils.isRollupIndex(targetIndexResolvedName, this.clusterService.state())) {
                    this.prepareTargetIndex(rollup, targetIndexResolvedName, hasLegacyPlugin, listener);
                } else {
                    this.jobExistsInRollupIndex(rollup, targetIndexResolvedName, (ActionListener<RollupJobValidationResult>)ActionListener.wrap(jobExistsResult -> {
                        if (jobExistsResult instanceof RollupJobValidationResult.Valid) {
                            listener.onResponse(jobExistsResult);
                        } else if (jobExistsResult instanceof RollupJobValidationResult.Invalid) {
                            this.updateRollupIndexMappings(rollup, targetIndexResolvedName, listener);
                        } else {
                            listener.onResponse(jobExistsResult);
                        }
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else if (!RollupUtils.isRollupIndex(targetIndexResolvedName, this.clusterService.state())) {
            listener.onResponse((Object)new RollupJobValidationResult.Invalid("Target index [" + targetIndexResolvedName + "] is a non rollup index"));
        } else {
            this.jobExistsInRollupIndex(rollup, targetIndexResolvedName, (ActionListener<RollupJobValidationResult>)ActionListener.wrap(jobExistsResult -> {
                if (jobExistsResult instanceof RollupJobValidationResult.Valid) {
                    listener.onResponse(jobExistsResult);
                } else if (jobExistsResult instanceof RollupJobValidationResult.Invalid) {
                    this.updateRollupIndexMappings(rollup, targetIndexResolvedName, listener);
                } else {
                    listener.onResponse(jobExistsResult);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public void validateTargetIndexAlias(Rollup rollup, String targetIndexResolvedName, ActionListener<RollupJobValidationResult> listener) throws IOException {
        if (!RollupFieldValueExpressionResolver.getIndexAliasUtils().hasAlias(targetIndexResolvedName)) {
            logger.error("[{}] is not an alias!", (Object)rollup.getTargetIndex());
            listener.onResponse((Object)new RollupJobValidationResult.Failure("[" + rollup.getTargetIndex() + "] is not an alias!"));
            return;
        }
        List<Rollup> rollupJobs = RollupUtils.getRollupJobs(this.clusterService.state().metadata().index(targetIndexResolvedName));
        if (!(rollupJobs == null || rollupJobs.size() <= 1 && rollupJobs.get(0).getId().equals(rollup.getId()))) {
            String errorMessage = "More than one rollup jobs present on the backing index of the target alias, cannot perform rollup to this target alias [" + rollup.getTargetIndex() + "].";
            logger.error(errorMessage);
            listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage));
            return;
        }
        List<IndexMetadata> backingIndices = RollupFieldValueExpressionResolver.getIndexAliasUtils().getBackingIndicesForAlias(rollup.getTargetIndex());
        if (backingIndices != null) {
            for (IndexMetadata indexMetadata : backingIndices) {
                List<Rollup> allRollupJobs;
                RollupJobValidationResult validationResult;
                String backingIndexName = indexMetadata.getIndex().getName();
                if (backingIndexName.equals(targetIndexResolvedName) || (validationResult = this.validateNonWriteBackingIndex(backingIndexName, rollup, allRollupJobs = RollupUtils.getRollupJobs(this.clusterService.state().metadata().index(backingIndexName)))) instanceof RollupJobValidationResult.Valid) continue;
                listener.onResponse((Object)validationResult);
                return;
            }
        }
        listener.onResponse((Object)RollupJobValidationResult.Valid.getInstance());
    }

    public RollupJobValidationResult validateNonWriteBackingIndex(String backingIndex, Rollup currentRollupJob, List<Rollup> rollupJobs) {
        Object errorMessage = "";
        if (rollupJobs == null) {
            errorMessage = "Backing index [" + backingIndex + "] has to have owner rollup job with id:[" + currentRollupJob.getId() + "]";
        } else if (rollupJobs.size() == 1 && !rollupJobs.get(0).getId().equals(currentRollupJob.getId())) {
            errorMessage = "Backing index [" + backingIndex + "] has to have owner rollup job with id:[" + currentRollupJob.getId() + "]";
        } else if (rollupJobs.size() > 1) {
            errorMessage = "Backing index [" + backingIndex + "] has multiple rollup job owners";
        }
        if (!((String)errorMessage).isEmpty()) {
            logger.error((String)errorMessage);
            return new RollupJobValidationResult.Failure((String)errorMessage);
        }
        return RollupJobValidationResult.Valid.getInstance();
    }

    public void attemptCreateRollupTargetIndex(Rollup job, boolean hasLegacyPlugin, ActionListener<RollupJobValidationResult> listener) throws IOException {
        String targetIndexResolvedName = RollupFieldValueExpressionResolver.resolve(job, job.getTargetIndex());
        if (this.indexExists(targetIndexResolvedName)) {
            this.validateAndAttemptToUpdateTargetIndex(job, targetIndexResolvedName, hasLegacyPlugin, (ActionListener<RollupJobValidationResult>)ActionListener.wrap(validationResult -> {
                if (validationResult instanceof RollupJobValidationResult.Failure) {
                    logger.error(((RollupJobValidationResult.Failure)validationResult).getMessage());
                } else if (validationResult instanceof RollupJobValidationResult.Invalid) {
                    logger.error(((RollupJobValidationResult.Invalid)validationResult).getReason());
                }
                listener.onResponse(validationResult);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            String errorMessage = "Failed to create target index [" + targetIndexResolvedName + "]";
            try {
                this.createTargetIndex(targetIndexResolvedName, job.getTargetIndexSettings(), hasLegacyPlugin, (ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        this.updateRollupIndexMappings(job, targetIndexResolvedName, listener);
                    } else {
                        listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage));
                    }
                }, e -> {
                    Exception unwrappedException;
                    Exception exception = unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)((RemoteTransportException)((Object)((Object)e)))) : e;
                    if (e instanceof SkyliteSecurityException) {
                        logger.error(errorMessage + " because ", (Throwable)e);
                        listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage + " - missing required cluster permissions: " + e.getLocalizedMessage(), unwrappedException));
                    } else {
                        logger.error(errorMessage, (Throwable)unwrappedException);
                        listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage, unwrappedException));
                    }
                }));
            }
            catch (Exception e2) {
                logger.error(errorMessage + " because ", (Throwable)e2);
                listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage, e2));
            }
        }
    }

    public void addRollupSettingToIndex(String targetIndexResolvedName, boolean hasLegacyPlugin, ActionListener<Boolean> listener) {
        Settings.Builder settingsBuilder = Settings.builder();
        if (hasLegacyPlugin) {
            settingsBuilder.put(LegacyOpenDistroRollupSettings.ROLLUP_INDEX.getKey(), true);
        } else {
            settingsBuilder.put(RollupSettings.ROLLUP_INDEX.getKey(), true);
        }
        UpdateSettingsRequest request = new UpdateSettingsRequest(settingsBuilder.build(), new String[]{targetIndexResolvedName});
        this.client.admin().indices().updateSettings(request, ActionListener.wrap(response -> listener.onResponse((Object)response.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)));
    }

    public void prepareTargetIndex(Rollup rollup, String targetIndexResolvedName, boolean hasLegacyPlugin, ActionListener<RollupJobValidationResult> listener) {
        String errorMessage = "";
        try {
            this.addRollupSettingToIndex(targetIndexResolvedName, hasLegacyPlugin, (ActionListener<Boolean>)ActionListener.wrap(acknowledged -> {
                if (!acknowledged.booleanValue()) {
                    logger.error("Failed to update rollup settings for target index: [{}]", (Object)targetIndexResolvedName);
                    listener.onResponse((Object)new RollupJobValidationResult.Invalid("Failed to update rollup settings for target index: [" + targetIndexResolvedName + "]"));
                    return;
                }
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{targetIndexResolvedName}).source(IndexManagementIndices.rollupTargetMappings, MediaTypeRegistry.JSON);
                this.client.admin().indices().putMapping(putMappingRequest, ActionListener.wrap(respMappings -> {
                    if (!respMappings.isAcknowledged()) {
                        listener.onResponse((Object)new RollupJobValidationResult.Invalid("Failed to put initial rollup mappings for target index [" + targetIndexResolvedName + "]"));
                        return;
                    }
                    this.updateRollupIndexMappings(rollup, targetIndexResolvedName, listener);
                }, e -> this.handlePrepareTargetIndexError("Failed to update mappings for target index [" + targetIndexResolvedName + "]", (Throwable)e, listener)));
            }, e -> this.handlePrepareTargetIndexError("Failed to update rollup settings for target index [" + targetIndexResolvedName + "]", (Throwable)e, listener)));
        }
        catch (Exception e2) {
            this.handlePrepareTargetIndexError("Failed to prepare target index [" + targetIndexResolvedName + "]", e2, listener);
        }
    }

    private void handlePrepareTargetIndexError(String errorMessage, Throwable e, ActionListener<RollupJobValidationResult> listener) {
        Exception unwrappedException;
        Exception exception = unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e) : (Exception)e;
        if (e instanceof SkyliteSecurityException) {
            logger.error(errorMessage + " because ", e);
            listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage + " - missing required cluster permissions: " + e.getLocalizedMessage(), unwrappedException));
        } else {
            logger.error(errorMessage, (Throwable)unwrappedException);
            listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage, unwrappedException));
        }
    }

    private void createTargetIndex(String targetIndexName, Settings targetIndexSettings, boolean hasLegacyPlugin, ActionListener<CreateIndexResponse> listener) {
        Settings.Builder settingsBuilder = Settings.builder();
        if (targetIndexSettings != null) {
            settingsBuilder.put(targetIndexSettings);
        }
        if (hasLegacyPlugin) {
            settingsBuilder.put(LegacyOpenDistroRollupSettings.ROLLUP_INDEX.getKey(), true);
        } else {
            settingsBuilder.put(RollupSettings.ROLLUP_INDEX.getKey(), true);
        }
        CreateIndexRequest request = new CreateIndexRequest(targetIndexName).settings(settingsBuilder.build()).mapping(IndexManagementIndices.rollupTargetMappings);
        this.client.admin().indices().create(request, listener);
    }

    public void isSourceIndexValid(Rollup rollup, ActionListener<RollupJobValidationResult> listener) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpand(), true, new String[]{rollup.getSourceIndex()});
        if (concreteIndices.length == 0) {
            listener.onResponse((Object)new RollupJobValidationResult.Invalid("No indices found for [" + rollup.getSourceIndex() + "]"));
            return;
        }
        this.validateConcreteIndices(rollup, concreteIndices, 0, listener);
    }

    private void validateConcreteIndices(Rollup rollup, String[] concreteIndices, int index, ActionListener<RollupJobValidationResult> listener) {
        if (index >= concreteIndices.length) {
            listener.onResponse((Object)RollupJobValidationResult.Valid.getInstance());
            return;
        }
        this.isSourceIndexMappingsValid(concreteIndices[index], rollup, (ActionListener<RollupJobValidationResult>)ActionListener.wrap(sourceIndexMappingResult -> {
            if (sourceIndexMappingResult instanceof RollupJobValidationResult.Valid) {
                this.validateConcreteIndices(rollup, concreteIndices, index + 1, listener);
            } else {
                listener.onResponse(sourceIndexMappingResult);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void isSourceIndexMappingsValid(String index, Rollup rollup, ActionListener<RollupJobValidationResult> listener) {
        logger.debug("Validating source index mappings for index [{}] and rollup [{}]", (Object)index, (Object)rollup.getId());
        try {
            this.getMappings(index, (ActionListener<GetMappingsResult>)ActionListener.wrap(getMappingsResult -> {
                logger.debug("getMappings result for index [{}]: {}", (Object)index, (Object)getMappingsResult.getClass().getSimpleName());
                if (getMappingsResult instanceof GetMappingsResult.Success) {
                    GetMappingsResponse res = ((GetMappingsResult.Success)getMappingsResult).getResponse();
                    MappingMetadata indexTypeMappings = (MappingMetadata)res.getMappings().get(index);
                    if (indexTypeMappings == null) {
                        listener.onResponse((Object)new RollupJobValidationResult.Invalid("Source index [" + index + "] mappings are empty, cannot validate the job."));
                        return;
                    }
                    Map indexMappingSource = indexTypeMappings.getSourceAsMap();
                    StringBuilder issues = new StringBuilder();
                    rollup.getDimensions().forEach(dimension -> {
                        if (!this.isFieldInMappings(dimension.getSourceField(), indexMappingSource)) {
                            if (issues.length() > 0) {
                                issues.append(", ");
                            }
                            issues.append("missing field ").append(dimension.getSourceField());
                        }
                    });
                    rollup.getMetrics().forEach(metric -> {
                        if (!this.isFieldInMappings(metric.getSourceField(), indexMappingSource)) {
                            if (issues.length() > 0) {
                                issues.append(", ");
                            }
                            issues.append("missing field ").append(metric.getSourceField());
                        }
                    });
                    if (issues.length() > 0) {
                        listener.onResponse((Object)new RollupJobValidationResult.Invalid("Invalid mappings for index [" + index + "] because " + String.valueOf(issues)));
                    } else {
                        listener.onResponse((Object)RollupJobValidationResult.Valid.getInstance());
                    }
                } else {
                    GetMappingsResult.Failure failure = (GetMappingsResult.Failure)getMappingsResult;
                    listener.onResponse((Object)new RollupJobValidationResult.Failure(failure.getMessage(), failure.getCause()));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            String errorMessage = "Failed to validate the source index mappings";
            logger.error(errorMessage, (Throwable)e);
            listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage, e));
        }
    }

    private boolean isFieldInMappings(String fieldName, Map<?, ?> mappings) {
        return IndexUtils.getFieldFromMappings(fieldName, mappings) != null;
    }

    private void jobExistsInRollupIndex(Rollup rollup, String targetIndexResolvedName, ActionListener<RollupJobValidationResult> listener) {
        this.getMappings(targetIndexResolvedName, (ActionListener<GetMappingsResult>)ActionListener.wrap(getMappingsResult -> {
            if (getMappingsResult instanceof GetMappingsResult.Success) {
                Object rollupsObj;
                Map sourceAsMap;
                Object metaObj;
                GetMappingsResponse res = ((GetMappingsResult.Success)getMappingsResult).getResponse();
                MappingMetadata indexMapping = (MappingMetadata)res.getMappings().get(targetIndexResolvedName);
                if (indexMapping != null && (metaObj = (sourceAsMap = indexMapping.getSourceAsMap()).get("_meta")) instanceof Map && (rollupsObj = ((Map)metaObj).get(ROLLUPS)) instanceof Map && ((Map)rollupsObj).containsKey(rollup.getId())) {
                    listener.onResponse((Object)RollupJobValidationResult.Valid.getInstance());
                    return;
                }
                listener.onResponse((Object)new RollupJobValidationResult.Invalid("Rollup job [" + rollup.getId() + "] does not exist in rollup index [" + targetIndexResolvedName + "]"));
            } else {
                GetMappingsResult.Failure failure = (GetMappingsResult.Failure)getMappingsResult;
                listener.onResponse((Object)new RollupJobValidationResult.Failure(failure.getMessage(), failure.getCause()));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getMappings(String index, ActionListener<GetMappingsResult> listener) {
        String errorMessage = "Failed to get mappings for index [" + index + "]";
        ThreadContext tc = this.client.threadPool().getThreadContext();
        String userInfo = (String)tc.getTransient("_opendistro_security_user_info");
        logger.debug("getMappings for index [{}] - userInfo: {}", (Object)index, (Object)userInfo);
        try {
            GetMappingsRequest req = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{index});
            this.client.admin().indices().getMappings(req, ActionListener.wrap(res -> {
                if (res == null) {
                    listener.onResponse((Object)new GetMappingsResult.Failure(errorMessage, new IllegalStateException("GetMappingsResponse for index [" + index + "] was null")));
                } else {
                    listener.onResponse((Object)new GetMappingsResult.Success((GetMappingsResponse)res));
                }
            }, e -> {
                Exception unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e) : e;
                logger.debug("getMappings error for index [{}], original: {}, unwrapped: {}", (Object)index, (Object)e.getClass().getName(), (Object)unwrappedException.getClass().getName());
                if (unwrappedException instanceof SkyliteSecurityException) {
                    logger.error(errorMessage, (Throwable)unwrappedException);
                    listener.onResponse((Object)new GetMappingsResult.Failure(errorMessage + " - missing required index permissions: " + unwrappedException.getLocalizedMessage(), unwrappedException));
                } else {
                    logger.error(errorMessage, (Throwable)unwrappedException);
                    listener.onResponse((Object)new GetMappingsResult.Failure(errorMessage, unwrappedException));
                }
            }));
        }
        catch (Exception e2) {
            logger.error(errorMessage, (Throwable)e2);
            listener.onResponse((Object)new GetMappingsResult.Failure(errorMessage, e2));
        }
    }

    private boolean indexExists(String index) {
        return this.clusterService.state().getRoutingTable().hasIndex(index);
    }

    private void updateRollupIndexMappings(Rollup rollup, String targetIndexResolvedName, ActionListener<RollupJobValidationResult> listener) {
        String errorMessage = "Failed to update mappings of target index [" + targetIndexResolvedName + "] with rollup job";
        try {
            UpdateRollupMappingRequest request = new UpdateRollupMappingRequest(rollup);
            this.client.execute((ActionType)UpdateRollupMappingAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> {
                if (!response.isAcknowledged()) {
                    logger.error(errorMessage + " with no exception");
                    listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage));
                } else {
                    listener.onResponse((Object)RollupJobValidationResult.Valid.getInstance());
                }
            }, e -> {
                if (e instanceof SkyliteSecurityException) {
                    logger.error(errorMessage + " because ", (Throwable)e);
                    listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage + " - missing required index permissions: " + e.getLocalizedMessage(), (Exception)e));
                } else {
                    logger.error(errorMessage + " because ", (Throwable)e);
                    listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage, (Exception)e));
                }
            }));
        }
        catch (Exception e2) {
            logger.error(errorMessage + " because ", (Throwable)e2);
            listener.onResponse((Object)new RollupJobValidationResult.Failure(errorMessage, e2));
        }
    }

    public RollupJobValidationResult attemptCreateRollupTargetIndexSync(Rollup job, boolean hasLegacyPlugin) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        this.attemptCreateRollupTargetIndex(job, hasLegacyPlugin, new ActionListener<RollupJobValidationResult>(){

            public void onResponse(RollupJobValidationResult result) {
                future.complete(result);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (RollupJobValidationResult)future.get();
        }
        catch (ExecutionException e) {
            throw (Exception)e.getCause();
        }
    }

    public RollupJobValidationResult isSourceIndexValidSync(Rollup rollup) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        this.isSourceIndexValid(rollup, new ActionListener<RollupJobValidationResult>(this){

            public void onResponse(RollupJobValidationResult result) {
                future.complete(result);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (RollupJobValidationResult)future.get();
        }
        catch (ExecutionException e) {
            throw (Exception)e.getCause();
        }
    }

    public static abstract class GetMappingsResult {

        public static class Failure
        extends GetMappingsResult {
            private final String message;
            private final Exception cause;

            public Failure(String message, Exception cause) {
                this.message = message;
                this.cause = cause;
            }

            public String getMessage() {
                return this.message;
            }

            public Exception getCause() {
                return this.cause;
            }
        }

        public static class Success
        extends GetMappingsResult {
            private final GetMappingsResponse response;

            public Success(GetMappingsResponse response) {
                this.response = response;
            }

            public GetMappingsResponse getResponse() {
                return this.response;
            }
        }
    }
}

