/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.rollup.RollupMetadataException;
import io.lucenia.indexmanagement.rollup.model.ContinuousMetadata;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupMetadata;
import io.lucenia.indexmanagement.rollup.model.RollupStats;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.common.Rounding;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.time.DateFormatters;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;

public class RollupMetadataService {
    private final Logger logger = LogManager.getLogger(RollupMetadataService.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public RollupMetadataService(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    private static <T> ActionListener<T> toListener(final CompletableFuture<T> future) {
        return new ActionListener<T>(){

            public void onResponse(T t) {
                future.complete(t);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        };
    }

    private CompletableFuture<SearchResponse> searchAsync(SearchRequest request) {
        CompletableFuture<SearchResponse> future = new CompletableFuture<SearchResponse>();
        this.client.search(request, RollupMetadataService.toListener(future));
        return future;
    }

    private CompletableFuture<GetResponse> getAsync(GetRequest request) {
        CompletableFuture<GetResponse> future = new CompletableFuture<GetResponse>();
        this.client.get(request, RollupMetadataService.toListener(future));
        return future;
    }

    private CompletableFuture<IndexResponse> indexAsync(IndexRequest request) {
        CompletableFuture<IndexResponse> future = new CompletableFuture<IndexResponse>();
        this.client.index(request, RollupMetadataService.toListener(future));
        return future;
    }

    public CompletableFuture<MetadataResult> getExistingMetadataAsync(Rollup rollup) {
        String errorMessage = "Error when getting rollup metadata [" + rollup.getMetadataID() + "]";
        CompletableFuture<MetadataResult> future = new CompletableFuture<MetadataResult>();
        try {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", rollup.getMetadataID()).routing(rollup.getId());
            this.getAsync(getRequest).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    Exception unwrapped = throwable instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)throwable) : (Exception)throwable;
                    this.logger.error(errorMessage + ": " + String.valueOf(unwrapped));
                    future.complete(new MetadataResult.Failure(errorMessage, unwrapped));
                    return;
                }
                if (!response.isExists()) {
                    future.complete(MetadataResult.NO_METADATA);
                    return;
                }
                BytesReference metadataSource = response.getSourceAsBytesRef();
                if (metadataSource == null) {
                    future.complete(MetadataResult.NO_METADATA);
                    return;
                }
                try {
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)metadataSource, (MediaType)MediaTypeRegistry.JSON);
                    RollupMetadata rollupMetadata = LuceniaExtensions.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), RollupMetadata::parse);
                    future.complete(new MetadataResult.Success(rollupMetadata));
                }
                catch (IOException e) {
                    this.logger.error(errorMessage + ": " + String.valueOf(e));
                    future.complete(new MetadataResult.Failure(errorMessage, e));
                }
            });
        }
        catch (Exception e) {
            this.logger.error(errorMessage + ": " + String.valueOf(e));
            future.complete(new MetadataResult.Failure(errorMessage, e));
        }
        return future;
    }

    private CompletableFuture<MetadataResult> submitMetadataUpdateAsync(RollupMetadata metadata, boolean updating) {
        String errorMessage = "An error occurred when " + (updating ? "updating" : "creating") + " rollup metadata";
        CompletableFuture<MetadataResult> future = new CompletableFuture<MetadataResult>();
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("rollup_metadata", (ToXContent)metadata).endObject();
            IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").source(builder).routing(metadata.getRollupID());
            if (updating) {
                indexRequest.id(metadata.getId()).setIfSeqNo(metadata.getSeqNo()).setIfPrimaryTerm(metadata.getPrimaryTerm());
            } else {
                indexRequest.opType(DocWriteRequest.OpType.CREATE);
            }
            this.indexAsync(indexRequest).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    Exception unwrapped = throwable instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)throwable) : (Exception)throwable;
                    this.logger.error("Metadata update failed " + metadata.getRollupID(), (Throwable)unwrapped);
                    future.complete(new MetadataResult.Failure(errorMessage, unwrapped));
                    return;
                }
                RollupMetadata.Status status = metadata.getStatus();
                Object failureReason = metadata.getFailureReason();
                DocWriteResponse.Result result = response.getResult();
                if (result != DocWriteResponse.Result.CREATED && result != DocWriteResponse.Result.UPDATED) {
                    status = RollupMetadata.Status.FAILED;
                    failureReason = "The create metadata call failed with a " + result.getLowercase() + " result";
                }
                this.logger.debug("Metadata update successful {}", (Object)metadata);
                RollupMetadata updatedMetadata = new RollupMetadata.Builder(metadata).id(response.getId()).seqNo(response.getSeqNo()).primaryTerm(response.getPrimaryTerm()).status(status).failureReason((String)failureReason).build();
                future.complete(new MetadataResult.Success(updatedMetadata));
            });
        }
        catch (Exception e) {
            this.logger.error("Metadata update failed " + metadata.getRollupID(), (Throwable)e);
            future.complete(new MetadataResult.Failure(errorMessage, e));
        }
        return future;
    }

    public CompletableFuture<RollupMetadata> updateMetadataAsync(RollupMetadata metadata) {
        boolean updating = !"".equals(metadata.getId());
        return this.submitMetadataUpdateAsync(metadata, updating).thenCompose(result -> {
            if (result instanceof MetadataResult.Success) {
                return CompletableFuture.completedFuture(((MetadataResult.Success)result).getMetadata());
            }
            if (result instanceof MetadataResult.Failure) {
                CompletableFuture failed = new CompletableFuture();
                failed.completeExceptionally(new RollupMetadataException("Failed to update rollup metadata [" + metadata.getId() + "]", ((MetadataResult.Failure)result).getCause()));
                return failed;
            }
            CompletableFuture failed = new CompletableFuture();
            failed.completeExceptionally(new RollupMetadataException("Unexpected state when updating rollup metadata [" + metadata.getId() + "]", null));
            return failed;
        });
    }

    public CompletableFuture<RollupMetadata> updateMetadataAsync(Rollup rollup, RollupMetadata metadata, InternalComposite internalComposite) {
        RollupMetadata updatedMetadata = rollup.getContinuous() ? this.getUpdatedContinuousMetadata(rollup, metadata, internalComposite) : this.getUpdatedNonContinuousMetadata(metadata, internalComposite);
        return this.updateMetadataAsync(updatedMetadata);
    }

    public void init(Rollup rollup, ActionListener<MetadataResult> listener) {
        if (rollup.getMetadataID() != null) {
            this.getExistingMetadata(rollup, (ActionListener<MetadataResult>)ActionListener.wrap(getMetadataResult -> {
                if (getMetadataResult instanceof MetadataResult.Success) {
                    RollupMetadata existingMetadata = ((MetadataResult.Success)getMetadataResult).getMetadata();
                    if (existingMetadata.getStatus() == RollupMetadata.Status.RETRY) {
                        this.recoverRetryMetadata(rollup, existingMetadata, (ActionListener<MetadataResult>)ActionListener.wrap(recoverMetadataResult -> {
                            if (recoverMetadataResult instanceof MetadataResult.Success) {
                                RollupMetadata recoveredMetadata = ((MetadataResult.Success)recoverMetadataResult).getMetadata();
                                this.submitMetadataUpdate(recoveredMetadata, true, listener);
                            } else {
                                listener.onResponse(recoverMetadataResult);
                            }
                        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    } else {
                        listener.onResponse((Object)new MetadataResult.Success(existingMetadata));
                    }
                } else if (getMetadataResult instanceof MetadataResult.NoMetadata) {
                    RollupMetadata failedMetadata = new RollupMetadata("", -1L, -1L, rollup.getId(), null, Instant.now(), null, RollupMetadata.Status.FAILED, "Not able to get the rollup metadata [" + rollup.getMetadataID() + "]", new RollupStats(0L, 0L, 0L, 0L, 0L));
                    this.submitMetadataUpdate(failedMetadata, false, listener);
                } else {
                    listener.onResponse(getMetadataResult);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else if (rollup.getContinuous()) {
            this.createContinuousMetadata(rollup, (ActionListener<MetadataResult>)ActionListener.wrap(createdMetadataResult -> {
                if (createdMetadataResult instanceof MetadataResult.Success) {
                    RollupMetadata metadata = ((MetadataResult.Success)createdMetadataResult).getMetadata();
                    this.submitMetadataUpdate(metadata, false, listener);
                } else {
                    listener.onResponse(createdMetadataResult);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            MetadataResult createdMetadataResult2 = this.createNonContinuousMetadata(rollup);
            if (createdMetadataResult2 instanceof MetadataResult.Success) {
                RollupMetadata metadata = ((MetadataResult.Success)createdMetadataResult2).getMetadata();
                this.submitMetadataUpdate(metadata, false, listener);
            } else {
                listener.onResponse((Object)createdMetadataResult2);
            }
        }
    }

    private void recoverRetryMetadata(Rollup rollup, RollupMetadata metadata, ActionListener<MetadataResult> listener) {
        ContinuousMetadata continuousMetadata = metadata.getContinuous();
        if (rollup.getContinuous() && metadata.getContinuous() == null) {
            this.getInitialStartTime(rollup, (ActionListener<StartingTimeResult>)ActionListener.wrap(initStartTimeResult -> {
                if (initStartTimeResult instanceof StartingTimeResult.Success) {
                    Instant nextWindowStartTime = ((StartingTimeResult.Success)initStartTimeResult).getStartingTime();
                    Instant nextWindowEndTime = this.getShiftedTime(nextWindowStartTime, rollup);
                    ContinuousMetadata newContinuousMetadata = new ContinuousMetadata(nextWindowStartTime, nextWindowEndTime);
                    RollupMetadata recoveredMetadata = new RollupMetadata.Builder(metadata).status(RollupMetadata.Status.STARTED).continuous(newContinuousMetadata).build();
                    listener.onResponse((Object)new MetadataResult.Success(recoveredMetadata));
                } else if (initStartTimeResult == StartingTimeResult.NO_DOCUMENTS_FOUND) {
                    listener.onResponse((Object)MetadataResult.NO_METADATA);
                } else {
                    Exception e = ((StartingTimeResult.Failure)initStartTimeResult).getException();
                    listener.onResponse((Object)new MetadataResult.Failure("Failed to initialize start time for retried rollup job [" + rollup.getId() + "]", e));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            RollupMetadata recoveredMetadata = new RollupMetadata.Builder(metadata).status(RollupMetadata.Status.STARTED).continuous(continuousMetadata).build();
            listener.onResponse((Object)new MetadataResult.Success(recoveredMetadata));
        }
    }

    private MetadataResult createNonContinuousMetadata(Rollup rollup) {
        return new MetadataResult.Success(new RollupMetadata("", -1L, -1L, rollup.getId(), null, Instant.now(), null, RollupMetadata.Status.INIT, null, new RollupStats(0L, 0L, 0L, 0L, 0L)));
    }

    private RollupMetadata getUpdatedNonContinuousMetadata(RollupMetadata metadata, InternalComposite internalComposite) {
        Map afterKey = internalComposite.afterKey();
        return new RollupMetadata.Builder(metadata).lastUpdatedTime(Instant.now()).status(afterKey == null ? RollupMetadata.Status.FINISHED : RollupMetadata.Status.STARTED).afterKey(afterKey).build();
    }

    private void createContinuousMetadata(Rollup rollup, ActionListener<MetadataResult> listener) {
        this.getInitialStartTime(rollup, (ActionListener<StartingTimeResult>)ActionListener.wrap(initStartTimeResult -> {
            if (initStartTimeResult instanceof StartingTimeResult.Success) {
                Instant nextWindowStartTime = ((StartingTimeResult.Success)initStartTimeResult).getStartingTime();
                Instant nextWindowEndTime = this.getShiftedTime(nextWindowStartTime, rollup);
                RollupMetadata metadata = new RollupMetadata("", -1L, -1L, rollup.getId(), null, Instant.now(), new ContinuousMetadata(nextWindowStartTime, nextWindowEndTime), RollupMetadata.Status.INIT, null, new RollupStats(0L, 0L, 0L, 0L, 0L));
                listener.onResponse((Object)new MetadataResult.Success(metadata));
            } else if (initStartTimeResult == StartingTimeResult.NO_DOCUMENTS_FOUND) {
                listener.onResponse((Object)MetadataResult.NO_METADATA);
            } else {
                Exception e = ((StartingTimeResult.Failure)initStartTimeResult).getException();
                listener.onResponse((Object)new MetadataResult.Failure("Failed to initialize start time for rollup [" + rollup.getId() + "]", e));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getInitialStartTime(Rollup rollup, ActionListener<StartingTimeResult> listener) {
        try {
            DateHistogram dateHistogram = (DateHistogram)rollup.getDimensions().get(0);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(1).query((QueryBuilder)new MatchAllQueryBuilder()).sort(dateHistogram.getSourceField(), SortOrder.ASC).trackTotalHits(false).fetchSource(false).docValueField(dateHistogram.getSourceField(), "strict_date_optional_time");
            SearchRequest searchRequest = new SearchRequest(new String[]{rollup.getSourceIndex()}).source(searchSourceBuilder).allowPartialSearchResults(false);
            this.client.search(searchRequest, ActionListener.wrap(response -> {
                if (response.getHits().getHits().length == 0) {
                    listener.onResponse((Object)StartingTimeResult.NO_DOCUMENTS_FOUND);
                    return;
                }
                String firstHitTimestampAsString = (String)response.getHits().getHits()[0].field(dateHistogram.getSourceField()).getValue();
                if (firstHitTimestampAsString == null) {
                    listener.onResponse((Object)StartingTimeResult.NO_DOCUMENTS_FOUND);
                    return;
                }
                DateFormatter formatter = DateFormatter.forPattern((String)"strict_date_optional_time");
                long epochMillis = DateFormatters.from((TemporalAccessor)formatter.parse(firstHitTimestampAsString), (Locale)formatter.locale()).toInstant().toEpochMilli();
                listener.onResponse((Object)new StartingTimeResult.Success(this.getRoundedTime(epochMillis, dateHistogram)));
            }, e -> {
                Exception unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)((RemoteTransportException)((Object)((Object)e)))) : e;
                this.logger.error("Error when getting initial start time for rollup [{}]: {}", (Object)rollup.getId(), (Object)unwrappedException);
                listener.onResponse((Object)new StartingTimeResult.Failure(unwrappedException));
            }));
        }
        catch (Exception e2) {
            this.logger.error("Error when getting initial start time for rollup [{}]: {}", (Object)rollup.getId(), (Object)e2);
            listener.onResponse((Object)new StartingTimeResult.Failure(e2));
        }
    }

    private Instant getRoundedTime(long timestamp, DateHistogram dateHistogram) {
        Rounding roundingStrategy = this.getRoundingStrategy(dateHistogram);
        long roundedMillis = roundingStrategy.prepare(timestamp, timestamp).round(timestamp);
        return Instant.ofEpochMilli(roundedMillis);
    }

    private Instant getShiftedTime(Instant time, Rollup rollup) {
        DateHistogram dateHistogram = (DateHistogram)rollup.getDimensions().get(0);
        Rounding roundingStrategy = this.getRoundingStrategy(dateHistogram);
        long timeInMillis = time.toEpochMilli();
        long nextRoundedMillis = roundingStrategy.prepare(timeInMillis, timeInMillis).nextRoundingValue(timeInMillis);
        return Instant.ofEpochMilli(nextRoundedMillis);
    }

    private Rounding getRoundingStrategy(DateHistogram dateHistogram) {
        String intervalString;
        String string = intervalString = dateHistogram.getCalendarInterval() != null ? dateHistogram.getCalendarInterval() : dateHistogram.getFixedInterval();
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.containsKey(intervalString)) {
            Rounding.DateTimeUnit intervalUnit = (Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(intervalString);
            return Rounding.builder((Rounding.DateTimeUnit)intervalUnit).timeZone(dateHistogram.getTimezone()).build();
        }
        TimeValue timeValue = TimeValue.parseTimeValue((String)intervalString, (String)"RollupMetadataService#getRoundingStrategy");
        return Rounding.builder((TimeValue)timeValue).timeZone(dateHistogram.getTimezone()).build();
    }

    private RollupMetadata getUpdatedContinuousMetadata(Rollup rollup, RollupMetadata metadata, InternalComposite internalComposite) {
        Map afterKey = internalComposite.afterKey();
        ContinuousMetadata continuous = metadata.getContinuous();
        Instant nextStart = afterKey == null ? this.getShiftedTime(continuous.getNextWindowStartTime(), rollup) : continuous.getNextWindowStartTime();
        Instant nextEnd = afterKey == null ? this.getShiftedTime(continuous.getNextWindowEndTime(), rollup) : continuous.getNextWindowEndTime();
        return new RollupMetadata.Builder(metadata).lastUpdatedTime(Instant.now()).status(RollupMetadata.Status.STARTED).continuous(new ContinuousMetadata(nextStart, nextEnd)).afterKey(afterKey).build();
    }

    public void getExistingMetadata(Rollup rollup, ActionListener<MetadataResult> listener) {
        String errorMessage = "Error when getting rollup metadata [" + rollup.getMetadataID() + "]";
        try {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", rollup.getMetadataID()).routing(rollup.getId());
            this.client.get(getRequest, ActionListener.wrap(response -> {
                if (!response.isExists()) {
                    listener.onResponse((Object)MetadataResult.NO_METADATA);
                    return;
                }
                BytesReference metadataSource = response.getSourceAsBytesRef();
                if (metadataSource == null) {
                    listener.onResponse((Object)MetadataResult.NO_METADATA);
                    return;
                }
                try {
                    XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)metadataSource, (MediaType)MediaTypeRegistry.JSON);
                    RollupMetadata rollupMetadata = LuceniaExtensions.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), RollupMetadata::parse);
                    listener.onResponse((Object)new MetadataResult.Success(rollupMetadata));
                }
                catch (IOException e) {
                    this.logger.error(errorMessage + ": " + String.valueOf(e));
                    listener.onResponse((Object)new MetadataResult.Failure(errorMessage, e));
                }
            }, e -> {
                Exception unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)((RemoteTransportException)((Object)((Object)e)))) : e;
                this.logger.error(errorMessage + ": " + String.valueOf(unwrappedException));
                listener.onResponse((Object)new MetadataResult.Failure(errorMessage, unwrappedException));
            }));
        }
        catch (Exception e2) {
            this.logger.error(errorMessage + ": " + String.valueOf(e2));
            listener.onResponse((Object)new MetadataResult.Failure(errorMessage, e2));
        }
    }

    public void updateMetadata(Rollup rollup, RollupMetadata metadata, InternalComposite internalComposite, ActionListener<RollupMetadata> listener) {
        RollupMetadata updatedMetadata = rollup.getContinuous() ? this.getUpdatedContinuousMetadata(rollup, metadata, internalComposite) : this.getUpdatedNonContinuousMetadata(metadata, internalComposite);
        this.updateMetadata(updatedMetadata, listener);
    }

    public void updateMetadata(RollupMetadata metadata, ActionListener<RollupMetadata> listener) {
        this.submitMetadataUpdate(metadata, !metadata.getId().equals(""), (ActionListener<MetadataResult>)ActionListener.wrap(metadataUpdateResult -> {
            if (metadataUpdateResult instanceof MetadataResult.Success) {
                listener.onResponse((Object)((MetadataResult.Success)metadataUpdateResult).getMetadata());
            } else if (metadataUpdateResult instanceof MetadataResult.Failure) {
                MetadataResult.Failure failure = (MetadataResult.Failure)metadataUpdateResult;
                listener.onFailure((Exception)new RollupMetadataException("Failed to update rollup metadata [" + metadata.getId() + "]", failure.getCause()));
            } else {
                listener.onFailure((Exception)new RollupMetadataException("Unexpected state when updating rollup metadata [" + metadata.getId() + "]", null));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void setFailedMetadata(Rollup job, String reason, RollupMetadata existingMetadata, ActionListener<MetadataResult> listener) {
        RollupMetadata updatedMetadata;
        if (existingMetadata == null) {
            updatedMetadata = new RollupMetadata("", -1L, -1L, job.getId(), null, Instant.now(), null, RollupMetadata.Status.FAILED, reason, new RollupStats(0L, 0L, 0L, 0L, 0L));
        } else {
            String finalReason = existingMetadata.getFailureReason() != null && !existingMetadata.getFailureReason().isEmpty() ? existingMetadata.getFailureReason() : reason;
            updatedMetadata = new RollupMetadata.Builder(existingMetadata).lastUpdatedTime(Instant.now()).status(RollupMetadata.Status.FAILED).failureReason(finalReason).build();
        }
        this.submitMetadataUpdate(updatedMetadata, !updatedMetadata.getId().equals(""), listener);
    }

    private void submitMetadataUpdate(RollupMetadata metadata, boolean updating, ActionListener<MetadataResult> listener) {
        String errorMessage = "An error occurred when " + (updating ? "updating" : "creating") + " rollup metadata";
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().field("rollup_metadata", (ToXContent)metadata).endObject();
            IndexRequest indexRequest = new IndexRequest(".opendistro-ism-config").source(builder).routing(metadata.getRollupID());
            if (updating) {
                indexRequest.id(metadata.getId()).setIfSeqNo(metadata.getSeqNo()).setIfPrimaryTerm(metadata.getPrimaryTerm());
            } else {
                indexRequest.opType(DocWriteRequest.OpType.CREATE);
            }
            this.client.index(indexRequest, ActionListener.wrap(response -> {
                RollupMetadata.Status status = metadata.getStatus();
                Object failureReason = metadata.getFailureReason();
                DocWriteResponse.Result result = response.getResult();
                if (result != DocWriteResponse.Result.CREATED && result != DocWriteResponse.Result.UPDATED) {
                    status = RollupMetadata.Status.FAILED;
                    failureReason = "The create metadata call failed with a " + result.getLowercase() + " result";
                }
                this.logger.debug("Metadata update successful {}", (Object)metadata);
                RollupMetadata updatedMetadata = new RollupMetadata.Builder(metadata).id(response.getId()).seqNo(response.getSeqNo()).primaryTerm(response.getPrimaryTerm()).status(status).failureReason((String)failureReason).build();
                listener.onResponse((Object)new MetadataResult.Success(updatedMetadata));
            }, e -> {
                Exception unwrappedException = e instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e) : e;
                this.logger.error("Metadata update failed " + metadata.getRollupID(), (Throwable)unwrappedException);
                listener.onResponse((Object)new MetadataResult.Failure(errorMessage, unwrappedException));
            }));
        }
        catch (Exception e2) {
            this.logger.error("Metadata update failed " + metadata.getRollupID(), (Throwable)e2);
            listener.onResponse((Object)new MetadataResult.Failure(errorMessage, e2));
        }
    }

    public MetadataResult getExistingMetadataSync(Rollup rollup) throws Exception {
        try {
            return this.getExistingMetadataAsync(rollup).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public MetadataResult initSync(Rollup rollup) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        this.init(rollup, new ActionListener<MetadataResult>(){

            public void onResponse(MetadataResult result) {
                future.complete(result);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (MetadataResult)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public MetadataResult updateMetadataSync(RollupMetadata metadata, boolean isInit) throws Exception {
        try {
            return this.submitMetadataUpdateAsync(metadata, !isInit).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public MetadataResult setFailedMetadataSync(Rollup rollup, String reason, RollupMetadata existingMetadata) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        this.setFailedMetadata(rollup, reason, existingMetadata, new ActionListener<MetadataResult>(){

            public void onResponse(MetadataResult result) {
                future.complete(result);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (MetadataResult)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public RollupMetadata updateMetadataSync(Rollup rollup, RollupMetadata metadata, InternalComposite internalComposite) throws Exception {
        try {
            return this.updateMetadataAsync(rollup, metadata, internalComposite).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public RollupMetadata updateMetadataSync(RollupMetadata metadata) throws Exception {
        try {
            return this.updateMetadataAsync(metadata).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public static abstract class MetadataResult {
        public static final MetadataResult NO_METADATA = NoMetadata.INSTANCE;

        public static class NoMetadata
        extends MetadataResult {
            public static final NoMetadata INSTANCE = new NoMetadata();

            private NoMetadata() {
            }
        }

        public static class Failure
        extends MetadataResult {
            private final String message;
            private final Exception cause;

            public Failure(String message, Exception cause) {
                this.message = message;
                this.cause = cause;
            }

            public String getMessage() {
                return this.message;
            }

            public Exception getCause() {
                return this.cause;
            }
        }

        public static class Success
        extends MetadataResult {
            private final RollupMetadata metadata;

            public Success(RollupMetadata metadata) {
                this.metadata = metadata;
            }

            public RollupMetadata getMetadata() {
                return this.metadata;
            }
        }
    }

    public static abstract class StartingTimeResult {
        public static final StartingTimeResult NO_DOCUMENTS_FOUND = new StartingTimeResult(){};

        public static class Failure
        extends StartingTimeResult {
            private final Exception exception;

            public Failure(Exception exception) {
                this.exception = exception;
            }

            public Exception getException() {
                return this.exception;
            }
        }

        public static class Success
        extends StartingTimeResult {
            private final Instant startingTime;

            public Success(Instant startingTime) {
                this.startingTime = startingTime;
            }

            public Instant getStartingTime() {
                return this.startingTime;
            }
        }
    }
}

