/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup;

import io.lucenia.indexmanagement.indexstatemanagement.SkipExecution;
import io.lucenia.indexmanagement.luceniaapi.IndexManagementSecurityContext;
import io.lucenia.indexmanagement.rollup.RollupIndexer;
import io.lucenia.indexmanagement.rollup.RollupMapperService;
import io.lucenia.indexmanagement.rollup.RollupMetadataException;
import io.lucenia.indexmanagement.rollup.RollupMetadataService;
import io.lucenia.indexmanagement.rollup.RollupSearchService;
import io.lucenia.indexmanagement.rollup.action.get.GetRollupAction;
import io.lucenia.indexmanagement.rollup.action.get.GetRollupRequest;
import io.lucenia.indexmanagement.rollup.action.get.GetRollupResponse;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupAction;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupRequest;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupResponse;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupJobValidationResult;
import io.lucenia.indexmanagement.rollup.model.RollupMetadata;
import io.lucenia.indexmanagement.rollup.model.RollupStats;
import io.lucenia.indexmanagement.util.LockUtils;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.jobs.ScheduledJobRunner;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;

public class RollupRunner
implements ScheduledJobRunner {
    private static final Logger logger = LogManager.getLogger(RollupRunner.class);
    public static final RollupRunner INSTANCE = new RollupRunner();
    private final BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3);
    private ClusterService clusterService;
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ScriptService scriptService;
    private Settings settings;
    private ThreadPool threadPool;
    private RollupMapperService rollupMapperService;
    private RollupIndexer rollupIndexer;
    private RollupSearchService rollupSearchService;
    private RollupMetadataService rollupMetadataService;
    private SkipExecution clusterConfigurationProvider;

    private RollupRunner() {
    }

    public RollupRunner registerClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
        return this;
    }

    public RollupRunner registerClient(Client client) {
        this.client = client;
        return this;
    }

    public RollupRunner registerNamedXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
        return this;
    }

    public RollupRunner registerScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
        return this;
    }

    public RollupRunner registerSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public RollupRunner registerThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public RollupRunner registerMapperService(RollupMapperService rollupMapperService) {
        this.rollupMapperService = rollupMapperService;
        return this;
    }

    public RollupRunner registerIndexer(RollupIndexer rollupIndexer) {
        this.rollupIndexer = rollupIndexer;
        return this;
    }

    public RollupRunner registerSearcher(RollupSearchService rollupSearchService) {
        this.rollupSearchService = rollupSearchService;
        return this;
    }

    public RollupRunner registerMetadataServices(RollupMetadataService rollupMetadataService) {
        this.rollupMetadataService = rollupMetadataService;
        return this;
    }

    public RollupRunner registerClusterConfigurationProvider(SkipExecution clusterConfigurationProvider) {
        this.clusterConfigurationProvider = clusterConfigurationProvider;
        return this;
    }

    public RollupRunner registerConsumers() {
        return this;
    }

    public void runJob(ScheduledJobParameter job, JobExecutionContext context) {
        if (!(job instanceof Rollup)) {
            throw new IllegalArgumentException("Invalid job type, found " + job.getClass().getSimpleName() + " with id: " + context.getJobId());
        }
        Rollup rollup = (Rollup)job;
        this.threadPool.generic().execute(() -> {
            try {
                this.executeRollupJob(rollup, context);
            }
            catch (Exception e) {
                logger.error("Error running rollup job [" + rollup.getId() + "]", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRollupJob(Rollup rollup, JobExecutionContext context) {
        LockModel lock;
        RollupJobValidationResult jobValidity;
        RollupMetadata metadata = null;
        try {
            if (rollup.getMetadataID() != null) {
                RollupMetadataService.MetadataResult getMetadataResult = this.rollupMetadataService.getExistingMetadataSync(rollup);
                if (getMetadataResult instanceof RollupMetadataService.MetadataResult.Success) {
                    metadata = ((RollupMetadataService.MetadataResult.Success)getMetadataResult).getMetadata();
                } else if (getMetadataResult instanceof RollupMetadataService.MetadataResult.Failure) {
                    throw new RollupMetadataException("Failed to get existing rollup metadata [" + rollup.getMetadataID() + "]", ((RollupMetadataService.MetadataResult.Failure)getMetadataResult).getCause());
                }
            }
        }
        catch (RollupMetadataException e) {
            logger.error(e.getMessage(), e.getCause());
            return;
        }
        catch (Exception e) {
            logger.error("Error getting metadata for rollup [" + rollup.getId() + "]: " + e.getMessage(), (Throwable)e);
            return;
        }
        if (this.rollupSearchService.shouldProcessRollup(rollup, metadata)) {
            LockModel lock2 = LockUtils.acquireLockForScheduledJob(rollup, context, this.backoffPolicy);
            if (lock2 == null) {
                logger.debug("Could not acquire lock for " + rollup.getId());
            } else {
                this.runRollupJob(rollup, context, lock2);
                LockUtils.releaseLockForScheduledJob(context, lock2);
            }
        } else if (rollup.isEnabled() && (jobValidity = this.isJobValid(rollup)) instanceof RollupJobValidationResult.Invalid && (lock = LockUtils.acquireLockForScheduledJob(rollup, context, this.backoffPolicy)) != null) {
            try {
                this.setFailedMetadataAndDisableJob(rollup, ((RollupJobValidationResult.Invalid)jobValidity).getReason());
                logger.info("Updating metadata service to disable the job [" + rollup.getId() + "]");
            }
            catch (Exception e) {
                logger.error("Error disabling job [" + rollup.getId() + "]", (Throwable)e);
            }
            finally {
                LockUtils.releaseLockForScheduledJob(context, lock);
            }
        }
    }

    private void runRollupJob(Rollup job, JobExecutionContext context, LockModel lock) {
        logger.info("Running rollup job [" + job.getId() + "]");
        LockModel updatableLock = lock;
        try {
            List<RollupMetadata.Status> terminalStatuses;
            RollupJobValidationResult jobValidity = this.isJobValid(job);
            if (jobValidity instanceof RollupJobValidationResult.Invalid) {
                logger.error("Invalid job [" + job.getId() + "]: [" + ((RollupJobValidationResult.Invalid)jobValidity).getReason() + "]");
                this.setFailedMetadataAndDisableJob(job, ((RollupJobValidationResult.Invalid)jobValidity).getReason());
                return;
            }
            if (jobValidity instanceof RollupJobValidationResult.Failure) {
                logger.error("Failed to validate [" + job.getId() + "]: [" + ((RollupJobValidationResult.Failure)jobValidity).getMessage() + "]");
                this.setFailedMetadataAndDisableJob(job, ((RollupJobValidationResult.Failure)jobValidity).getMessage());
                return;
            }
            RollupMetadataService.MetadataResult initMetadataResult = this.rollupMetadataService.initSync(job);
            if (!(initMetadataResult instanceof RollupMetadataService.MetadataResult.Success)) {
                if (initMetadataResult instanceof RollupMetadataService.MetadataResult.NoMetadata) {
                    logger.info("Init metadata NoMetadata returning early");
                    return;
                }
                throw new RollupMetadataException("Failed to initialize rollup metadata", ((RollupMetadataService.MetadataResult.Failure)initMetadataResult).getCause());
            }
            RollupMetadata metadata = ((RollupMetadataService.MetadataResult.Success)initMetadataResult).getMetadata();
            if (metadata.getStatus() == RollupMetadata.Status.FAILED) {
                logger.info("Metadata status is FAILED, disabling job " + String.valueOf(metadata));
                this.disableJob(job, metadata);
                return;
            }
            Rollup updatableJob = job;
            if (updatableJob.getMetadataID() == null && metadata.getStatus() == RollupMetadata.Status.INIT) {
                RollupJobResult updateResult = this.updateRollupJob(new Rollup.Builder(updatableJob).metadataID(metadata.getId()).build(), metadata);
                if (updateResult instanceof RollupJobResult.Success) {
                    updatableJob = ((RollupJobResult.Success)updateResult).getRollup();
                } else {
                    logger.error("Failed to update the rollup job [" + updatableJob.getId() + "] with metadata id [" + metadata.getId() + "]", (Throwable)((RollupJobResult.Failure)updateResult).getCause());
                    return;
                }
            }
            try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(job.getId(), this.settings, this.threadPool.getThreadContext(), job.getUser());){
                RollupJobValidationResult result = this.rollupMapperService.attemptCreateRollupTargetIndexSync(updatableJob, this.clusterConfigurationProvider.getHasLegacyPlugin());
                if (result instanceof RollupJobValidationResult.Failure) {
                    this.setFailedMetadataAndDisableJob(updatableJob, ((RollupJobValidationResult.Failure)result).getMessage(), metadata);
                    return;
                }
                if (result instanceof RollupJobValidationResult.Invalid) {
                    this.setFailedMetadataAndDisableJob(updatableJob, ((RollupJobValidationResult.Invalid)result).getReason(), metadata);
                    return;
                }
            }
            RollupMetadata currentMetadata = metadata;
            logger.info("Starting processing loop for job [{}], shouldProcess={}, metadata status={}", (Object)job.getId(), (Object)this.rollupSearchService.shouldProcessRollup(updatableJob, currentMetadata), (Object)currentMetadata.getStatus());
            while (this.rollupSearchService.shouldProcessRollup(updatableJob, currentMetadata)) {
                logger.info("Entered processing loop for job [{}]", (Object)job.getId());
                do {
                    try {
                        block48: {
                            RollupResult rollupResult;
                            RollupSearchService.RollupSearchResult rollupSearchResult;
                            logger.info("Executing composite search for job [{}]", (Object)job.getId());
                            try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(job.getId(), this.settings, this.threadPool.getThreadContext(), job.getUser());){
                                rollupSearchResult = this.rollupSearchService.executeCompositeSearchSync(updatableJob, currentMetadata);
                            }
                            logger.info("Composite search completed for job [{}], success={}", (Object)job.getId(), (Object)(rollupSearchResult instanceof RollupSearchService.RollupSearchResult.Success));
                            if (rollupSearchResult instanceof RollupSearchService.RollupSearchResult.Success) {
                                RollupIndexer.RollupIndexResult rollupIndexResult;
                                RollupSearchService.RollupSearchResult.Success searchSuccess = (RollupSearchService.RollupSearchResult.Success)rollupSearchResult;
                                InternalComposite compositeRes = (InternalComposite)searchSuccess.getSearchResponse().getAggregations().get(updatableJob.getId());
                                logger.info("Got composite result for job [{}], buckets={}, afterKey={}", (Object)job.getId(), compositeRes != null ? Integer.valueOf(compositeRes.getBuckets().size()) : "null", compositeRes != null ? compositeRes.afterKey() : "null");
                                currentMetadata = currentMetadata.incrementStats(searchSuccess.getSearchResponse(), compositeRes);
                                logger.info("Indexing rollup documents for job [{}]", (Object)job.getId());
                                try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(job.getId(), this.settings, this.threadPool.getThreadContext(), job.getUser());){
                                    rollupIndexResult = this.rollupIndexer.indexRollupsSync(updatableJob, compositeRes);
                                }
                                logger.info("Indexing completed for job [{}], success={}", (Object)job.getId(), (Object)(rollupIndexResult instanceof RollupIndexer.RollupIndexResult.Success));
                                rollupResult = rollupIndexResult instanceof RollupIndexer.RollupIndexResult.Success ? new RollupResult.Success(compositeRes, ((RollupIndexer.RollupIndexResult.Success)rollupIndexResult).getStats()) : new RollupResult.Failure(((RollupIndexer.RollupIndexResult.Failure)rollupIndexResult).getMessage(), ((RollupIndexer.RollupIndexResult.Failure)rollupIndexResult).getCause());
                            } else {
                                RollupSearchService.RollupSearchResult.Failure searchFailure = (RollupSearchService.RollupSearchResult.Failure)rollupSearchResult;
                                rollupResult = new RollupResult.Failure(searchFailure.getMessage(), searchFailure.getCause());
                            }
                            if (rollupResult instanceof RollupResult.Success) {
                                RollupResult.Success success = (RollupResult.Success)rollupResult;
                                logger.info("Updating metadata for job [{}], current status={}", (Object)job.getId(), (Object)currentMetadata.getStatus());
                                currentMetadata = this.rollupMetadataService.updateMetadataSync(updatableJob, currentMetadata.mergeStats(success.getStats()), success.getInternalComposite());
                                logger.info("Metadata updated for job [{}], new status={}", (Object)job.getId(), (Object)currentMetadata.getStatus());
                                try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(job.getId(), this.settings, this.threadPool.getThreadContext(), null);){
                                    GetRollupResponse response = (GetRollupResponse)((Object)this.client.execute((ActionType)GetRollupAction.INSTANCE, (ActionRequest)new GetRollupRequest(updatableJob.getId(), null, "_local")).actionGet());
                                    updatableJob = response.getRollup();
                                    if (updatableJob == null) {
                                        throw new IllegalStateException("Unable to get rollup job");
                                    }
                                    break block48;
                                }
                            }
                            RollupResult.Failure failure = rollupResult;
                            this.rollupMetadataService.updateMetadataSync(new RollupMetadata.Builder(currentMetadata).status(RollupMetadata.Status.FAILED).failureReason(failure.getCause().getMessage()).build());
                        }
                        LockModel renewedLock = LockUtils.renewLockForScheduledJob(context, updatableLock, this.backoffPolicy);
                        if (renewedLock == null) {
                            LockUtils.releaseLockForScheduledJob(context, updatableLock);
                            return;
                        }
                        updatableLock = renewedLock;
                    }
                    catch (RollupMetadataException e) {
                        logger.info("RollupMetadataException being thrown", (Throwable)e);
                        throw e;
                    }
                    catch (Exception e) {
                        logger.error("Failed to rollup", (Throwable)e);
                        LockUtils.releaseLockForScheduledJob(context, updatableLock);
                        return;
                    }
                    logger.info("End of do-while iteration for job [{}], afterKey={}", (Object)job.getId(), currentMetadata.getAfterKey());
                } while (currentMetadata.getAfterKey() != null);
                logger.info("Exited do-while loop for job [{}], checking shouldProcess", (Object)job.getId());
            }
            logger.info("Exited processing loop for job [{}], metadata status={}", (Object)job.getId(), (Object)currentMetadata.getStatus());
            if (!updatableJob.getContinuous() && (terminalStatuses = List.of(RollupMetadata.Status.STOPPED, RollupMetadata.Status.FINISHED, RollupMetadata.Status.FAILED)).contains((Object)currentMetadata.getStatus())) {
                this.disableJob(updatableJob, currentMetadata);
            }
            LockUtils.releaseLockForScheduledJob(context, updatableLock);
        }
        catch (RollupMetadataException e) {
            logger.error(e.getMessage(), e.getCause());
            LockUtils.releaseLockForScheduledJob(context, updatableLock);
        }
        catch (Exception e) {
            logger.error("Unexpected error in rollup job", (Throwable)e);
            LockUtils.releaseLockForScheduledJob(context, updatableLock);
        }
    }

    private RollupJobResult updateRollupJob(Rollup job, RollupMetadata metadata) throws Exception {
        IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(job.getId(), this.settings, this.threadPool.getThreadContext(), null);
        try {
            IndexRollupRequest req = new IndexRollupRequest(job, WriteRequest.RefreshPolicy.IMMEDIATE);
            IndexRollupResponse res = (IndexRollupResponse)((Object)this.client.execute((ActionType)IndexRollupAction.INSTANCE, (ActionRequest)req).actionGet());
            RollupJobResult.Success success = new RollupJobResult.Success(res.getRollup());
            ignored.close();
            return success;
        }
        catch (Throwable req) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable res) {
                    req.addSuppressed(res);
                }
                throw req;
            }
            catch (Exception e) {
                String errorMessage = "An error occurred when updating rollup job [" + job.getId() + "]";
                RollupMetadataService.MetadataResult setFailedResult = this.rollupMetadataService.setFailedMetadataSync(job, errorMessage, metadata);
                if (setFailedResult instanceof RollupMetadataService.MetadataResult.Failure) {
                    throw new RollupMetadataException(((RollupMetadataService.MetadataResult.Failure)setFailedResult).getMessage(), ((RollupMetadataService.MetadataResult.Failure)setFailedResult).getCause());
                }
                if (setFailedResult instanceof RollupMetadataService.MetadataResult.NoMetadata) {
                    throw new RollupMetadataException("Unexpected state when updating metadata", null);
                }
                return new RollupJobResult.Failure(errorMessage, e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RollupJobValidationResult isJobValid(Rollup job) {
        try (IndexManagementSecurityContext ignored = new IndexManagementSecurityContext(job.getId(), this.settings, this.threadPool.getThreadContext(), job.getUser());){
            RollupMetadata metadata = null;
            if (job.getMetadataID() != null) {
                logger.debug("Fetching associated metadata for rollup job [" + job.getId() + "]");
                RollupMetadataService.MetadataResult getMetadataResult = this.rollupMetadataService.getExistingMetadataSync(job);
                if (getMetadataResult instanceof RollupMetadataService.MetadataResult.Success) {
                    metadata = ((RollupMetadataService.MetadataResult.Success)getMetadataResult).getMetadata();
                } else if (getMetadataResult instanceof RollupMetadataService.MetadataResult.Failure) {
                    throw new RollupMetadataException("Failed to get existing rollup metadata [" + job.getMetadataID() + "]", ((RollupMetadataService.MetadataResult.Failure)getMetadataResult).getCause());
                }
            }
            logger.debug("Validating source index [" + job.getSourceIndex() + "] for rollup job [" + job.getId() + "]");
            RollupJobValidationResult sourceIndexValidationResult = this.rollupMapperService.isSourceIndexValidSync(job);
            if (!(sourceIndexValidationResult instanceof RollupJobValidationResult.Valid)) {
                RollupJobValidationResult rollupJobValidationResult = sourceIndexValidationResult;
                return rollupJobValidationResult;
            }
            if (metadata != null) {
                logger.debug("Attempting to create/validate target index [" + job.getTargetIndex() + "] for rollup job [" + job.getId() + "]");
                RollupJobValidationResult rollupJobValidationResult = this.rollupMapperService.attemptCreateRollupTargetIndexSync(job, this.clusterConfigurationProvider.getHasLegacyPlugin());
                return rollupJobValidationResult;
            }
            RollupJobValidationResult.Valid valid = RollupJobValidationResult.Valid.getInstance();
            return valid;
        }
        catch (Exception e) {
            logger.error("Exception during job validation", (Throwable)e);
            return new RollupJobValidationResult.Failure("Validation failed: " + e.getMessage());
        }
    }

    private boolean setFailedMetadataAndDisableJob(Rollup job, String reason, RollupMetadata existingMetadata) throws Exception {
        RollupMetadataService.MetadataResult setFailedMetadataResult = this.rollupMetadataService.setFailedMetadataSync(job, reason, existingMetadata);
        if (!(setFailedMetadataResult instanceof RollupMetadataService.MetadataResult.Success)) {
            if (setFailedMetadataResult instanceof RollupMetadataService.MetadataResult.Failure) {
                throw new RollupMetadataException(((RollupMetadataService.MetadataResult.Failure)setFailedMetadataResult).getMessage(), ((RollupMetadataService.MetadataResult.Failure)setFailedMetadataResult).getCause());
            }
            throw new RollupMetadataException("Unexpected state when setting failed metadata", null);
        }
        RollupMetadata updatedMetadata = ((RollupMetadataService.MetadataResult.Success)setFailedMetadataResult).getMetadata();
        return this.disableJob(job, updatedMetadata);
    }

    private boolean setFailedMetadataAndDisableJob(Rollup job, String reason) throws Exception {
        return this.setFailedMetadataAndDisableJob(job, reason, null);
    }

    private boolean disableJob(Rollup job, RollupMetadata metadata) throws Exception {
        Rollup updatedRollupJob = !metadata.getId().equals(job.getMetadataID()) ? new Rollup.Builder(job).metadataID(metadata.getId()).enabled(false).jobEnabledTime(null).build() : new Rollup.Builder(job).enabled(false).jobEnabledTime(null).build();
        RollupJobResult updateRollupJobResult = this.updateRollupJob(updatedRollupJob, metadata);
        if (updateRollupJobResult instanceof RollupJobResult.Success) {
            return true;
        }
        logger.error("Failed to disable rollup job [" + job.getId() + "]", (Throwable)((RollupJobResult.Failure)updateRollupJobResult).getCause());
        return false;
    }

    public static abstract class RollupJobResult {

        public static class Failure
        extends RollupJobResult {
            private final String message;
            private final Exception cause;

            public Failure(String message, Exception cause) {
                this.message = message;
                this.cause = cause;
            }

            public String getMessage() {
                return this.message;
            }

            public Exception getCause() {
                return this.cause;
            }
        }

        public static class Success
        extends RollupJobResult {
            private final Rollup rollup;

            public Success(Rollup rollup) {
                this.rollup = rollup;
            }

            public Rollup getRollup() {
                return this.rollup;
            }
        }
    }

    public static abstract class RollupResult {

        public static class Failure
        extends RollupResult {
            private final String message;
            private final Exception cause;

            public Failure(String message, Exception cause) {
                this.message = message;
                this.cause = cause;
            }

            public String getMessage() {
                return this.message;
            }

            public Exception getCause() {
                return this.cause;
            }
        }

        public static class Success
        extends RollupResult {
            private final InternalComposite internalComposite;
            private final RollupStats stats;

            public Success(InternalComposite internalComposite, RollupStats stats) {
                this.internalComposite = internalComposite;
                this.stats = stats;
            }

            public InternalComposite getInternalComposite() {
                return this.internalComposite;
            }

            public RollupStats getStats() {
                return this.stats;
            }
        }
    }
}

