/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.delete;

import io.lucenia.indexmanagement.rollup.action.delete.DeleteRollupRequest;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeleteRollupAction
extends HandledTransportAction<DeleteRollupRequest, DeleteResponse> {
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile boolean filterByEnabled;
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public TransportDeleteRollupAction(TransportService transportService, Client client, ClusterService clusterService, Settings settings, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/rollup/delete", transportService, actionFilters, DeleteRollupRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, DeleteRollupRequest request, ActionListener<DeleteResponse> actionListener) {
        DeleteRollupHandler handler = new DeleteRollupHandler(this.client, actionListener, request);
        handler.start();
    }

    class DeleteRollupHandler {
        private final Client client;
        private final ActionListener<DeleteResponse> actionListener;
        private final DeleteRollupRequest request;
        private final User user;

        DeleteRollupHandler(Client client, ActionListener<DeleteResponse> actionListener, DeleteRollupRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext());
        }

        void start() {
            TransportDeleteRollupAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                this.getRollup();
            }
        }

        private void getRollup() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.id());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    Rollup rollup;
                    if (!response.isExists()) {
                        DeleteRollupHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup " + DeleteRollupHandler.this.request.id() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        rollup = RollupUtils.parseRollup(response, TransportDeleteRollupAction.this.xContentRegistry);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        DeleteRollupHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup " + DeleteRollupHandler.this.request.id() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    if (!SecurityUtils.userHasPermissionForResource(DeleteRollupHandler.this.user, rollup.getUser(), TransportDeleteRollupAction.this.filterByEnabled, "rollup", rollup.getId(), DeleteRollupHandler.this.actionListener)) {
                        return;
                    }
                    DeleteRollupHandler.this.delete();
                }

                public void onFailure(Exception e) {
                    DeleteRollupHandler.this.actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                }
            });
        }

        private void delete() {
            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-ism-config", this.request.id()).setRefreshPolicy(this.request.getRefreshPolicy());
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                this.client.delete(deleteRequest, this.actionListener);
            }
        }
    }
}

