/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.explain;

import io.lucenia.indexmanagement.luceniaapi.ContentParserUtils;
import io.lucenia.indexmanagement.rollup.action.explain.ExplainRollupRequest;
import io.lucenia.indexmanagement.rollup.action.explain.ExplainRollupResponse;
import io.lucenia.indexmanagement.rollup.model.ExplainRollup;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupMetadata;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.ResourceNotFoundException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.IdsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.WildcardQueryBuilder;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.transport.TransportService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportExplainRollupAction
extends HandledTransportAction<ExplainRollupRequest, ExplainRollupResponse> {
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final Logger log = LogManager.getLogger(TransportExplainRollupAction.class);
    private volatile boolean filterByEnabled;

    @Inject
    public TransportExplainRollupAction(TransportService transportService, Client client, Settings settings, ClusterService clusterService, ActionFilters actionFilters) {
        super("cluster:admin/lucenia/rollup/explain", transportService, actionFilters, ExplainRollupRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, ExplainRollupRequest request, final ActionListener<ExplainRollupResponse> actionListener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        final List<String> ids = request.getRollupIDs();
        final HashMap idsToExplain = new HashMap();
        ids.stream().filter(id -> !id.contains("*")).forEach(id -> idsToExplain.put(id, null));
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder().minimumShouldMatch(1);
        for (String id2 : ids) {
            queryBuilder.should((QueryBuilder)new WildcardQueryBuilder("rollup.rollup_id.keyword", "*" + id2 + "*"));
        }
        User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        SecurityUtils.addUserFilter(user, queryBuilder, this.filterByEnabled, "rollup.user");
        SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-ism-config"}).source(new SearchSourceBuilder().size(10000).query((QueryBuilder)queryBuilder));
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    try {
                        for (SearchHit hit : response.getHits().getHits()) {
                            Rollup rollup = ContentParserUtils.parseWithType(ContentParserUtils.contentParser(hit.getSourceRef()), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), Rollup::parse);
                            idsToExplain.put(rollup.getId(), new ExplainRollup(rollup.getMetadataID(), null));
                        }
                    }
                    catch (Exception e) {
                        TransportExplainRollupAction.this.log.error("Failed to parse explain response", (Throwable)e);
                        actionListener.onFailure(e);
                        return;
                    }
                    List<String> metadataIds = idsToExplain.values().stream().filter(explain -> explain != null && explain.getMetadataID() != null).map(ExplainRollup::getMetadataID).collect(Collectors.toList());
                    if (metadataIds.isEmpty()) {
                        actionListener.onResponse((Object)new ExplainRollupResponse(new HashMap<String, ExplainRollup>(idsToExplain)));
                        return;
                    }
                    SearchRequest metadataSearchRequest = new SearchRequest(new String[]{".opendistro-ism-config"}).source(new SearchSourceBuilder().size(10000).query((QueryBuilder)new IdsQueryBuilder().addIds(metadataIds.toArray(new String[0]))));
                    TransportExplainRollupAction.this.client.search(metadataSearchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                        public void onResponse(SearchResponse response) {
                            try {
                                for (SearchHit hit : response.getHits().getHits()) {
                                    RollupMetadata metadata = ContentParserUtils.parseWithType(ContentParserUtils.contentParser(hit.getSourceRef()), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), RollupMetadata::parse);
                                    idsToExplain.computeIfPresent(metadata.getRollupID(), (key, explainRollup) -> new ExplainRollup(explainRollup.getMetadataID(), metadata));
                                }
                                actionListener.onResponse((Object)new ExplainRollupResponse(new HashMap<String, ExplainRollup>(idsToExplain)));
                            }
                            catch (Exception e) {
                                TransportExplainRollupAction.this.log.error("Failed to parse rollup metadata", (Throwable)e);
                                actionListener.onFailure(e);
                            }
                        }

                        public void onFailure(Exception e) {
                            TransportExplainRollupAction.this.log.error("Failed to search rollup metadata", (Throwable)e);
                            if (e instanceof RemoteTransportException) {
                                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                            } else {
                                actionListener.onFailure(e);
                            }
                        }
                    });
                }

                public void onFailure(Exception e) {
                    TransportExplainRollupAction.this.log.error("Failed to search for rollups", (Throwable)e);
                    if (e instanceof ResourceNotFoundException) {
                        Map nonWildcardIds = ids.stream().filter(id -> !id.contains("*")).collect(Collectors.toMap(id -> id, id -> null, (a, b) -> b, HashMap::new));
                        actionListener.onResponse((Object)new ExplainRollupResponse(nonWildcardIds));
                    } else if (e instanceof RemoteTransportException) {
                        actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                    } else {
                        actionListener.onFailure(e);
                    }
                }
            });
        }
    }
}

