/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.get;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import java.io.IOException;

public class GetRollupRequest
extends ActionRequest {
    private String id;
    private final FetchSourceContext srcContext;
    private final String preference;

    public GetRollupRequest(String id, FetchSourceContext srcContext, String preference) {
        this.id = id;
        this.srcContext = srcContext;
        this.preference = preference;
    }

    public GetRollupRequest(String id) {
        this(id, null, null);
    }

    public GetRollupRequest(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.srcContext = sin.readBoolean() ? new FetchSourceContext(sin) : null;
        this.preference = sin.readOptionalString();
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id.isBlank()) {
            validationException = ValidateActions.addValidationError((String)"id is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        if (this.srcContext == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.srcContext.writeTo(out);
        }
        out.writeOptionalString(this.preference);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FetchSourceContext getSrcContext() {
        return this.srcContext;
    }

    public String getPreference() {
        return this.preference;
    }
}

