/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.get;

import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;

public class GetRollupsResponse
extends ActionResponse
implements ToXContentObject {
    private final List<Rollup> rollups;
    private final int totalRollups;
    private final RestStatus status;

    public GetRollupsResponse(List<Rollup> rollups, int totalRollups, RestStatus status) {
        this.rollups = rollups;
        this.totalRollups = totalRollups;
        this.status = status;
    }

    public GetRollupsResponse(StreamInput sin) throws IOException {
        this.rollups = sin.readList(Rollup::new);
        this.totalRollups = sin.readInt();
        this.status = (RestStatus)sin.readEnum(RestStatus.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.rollups);
        out.writeInt(this.totalRollups);
        out.writeEnum((Enum)this.status);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("total_rollups", this.totalRollups).startArray("rollups");
        for (Rollup rollup : this.rollups) {
            builder.startObject().field("_id", rollup.getId()).field("_seq_no", rollup.getSeqNo()).field("_primary_term", rollup.getPrimaryTerm()).field("rollup", (ToXContent)rollup, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITHOUT_TYPE_AND_USER).endObject();
        }
        return builder.endArray().endObject();
    }

    public List<Rollup> getRollups() {
        return this.rollups;
    }

    public int getTotalRollups() {
        return this.totalRollups;
    }

    public RestStatus getStatus() {
        return this.status;
    }
}

