/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.get;

import io.lucenia.indexmanagement.rollup.action.get.GetRollupRequest;
import io.lucenia.indexmanagement.rollup.action.get.GetRollupResponse;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportGetRollupAction
extends HandledTransportAction<GetRollupRequest, GetRollupResponse> {
    private final Client client;
    private final Settings settings;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log = LogManager.getLogger(TransportGetRollupAction.class);
    private volatile boolean filterByEnabled;

    @Inject
    public TransportGetRollupAction(TransportService transportService, Client client, ActionFilters actionFilters, Settings settings, ClusterService clusterService, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/rollup/get", transportService, actionFilters, GetRollupRequest::new);
        this.client = client;
        this.settings = settings;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, final GetRollupRequest request, final ActionListener<GetRollupResponse> listener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getId()).preference(request.getPreference());
        final User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    Rollup rollup;
                    if (!response.isExists()) {
                        listener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        rollup = RollupUtils.parseRollup(response, TransportGetRollupAction.this.xContentRegistry);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        listener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    if (!SecurityUtils.userHasPermissionForResource(user, rollup.getUser(), TransportGetRollupAction.this.filterByEnabled, "rollup", request.getId(), listener)) {
                        return;
                    }
                    GetRollupResponse rollupResponse = request.getSrcContext() != null && !request.getSrcContext().fetchSource() ? new GetRollupResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), RestStatus.OK, null) : new GetRollupResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), RestStatus.OK, rollup);
                    listener.onResponse((Object)rollupResponse);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }
}

