/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.get;

import io.lucenia.indexmanagement.luceniaapi.ContentParserUtils;
import io.lucenia.indexmanagement.rollup.action.get.GetRollupsRequest;
import io.lucenia.indexmanagement.rollup.action.get.GetRollupsResponse;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.action.search.ShardSearchFailure;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.WildcardQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportGetRollupsAction
extends HandledTransportAction<GetRollupsRequest, GetRollupsResponse> {
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log = LogManager.getLogger(TransportGetRollupsAction.class);
    private volatile boolean filterByEnabled;

    @Inject
    public TransportGetRollupsAction(TransportService transportService, Client client, ActionFilters actionFilters, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/rollup/search", transportService, actionFilters, GetRollupsRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, GetRollupsRequest request, final ActionListener<GetRollupsResponse> listener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        String searchString = request.getSearchString().trim();
        int from = request.getFrom();
        int size = request.getSize();
        String sortField = request.getSortField();
        String sortDirection = request.getSortDirection();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("rollup"));
        if (!searchString.isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)new WildcardQueryBuilder("rollup.rollup_id.keyword", "*" + searchString + "*"));
        }
        User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        SecurityUtils.addUserFilter(user, boolQueryBuilder, this.filterByEnabled, "rollup.user");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).from(from).size(size).seqNoAndPrimaryTerm(Boolean.valueOf(true)).sort(sortField, SortOrder.fromString((String)sortDirection));
        SearchRequest searchRequest = new SearchRequest(new String[]{".opendistro-ism-config"}).source(searchSourceBuilder);
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this){

                public void onResponse(SearchResponse response) {
                    long totalRollups;
                    long l = totalRollups = response.getHits().getTotalHits() != null ? response.getHits().getTotalHits().value() : 0L;
                    if (response.getShardFailures().length > 0) {
                        ShardSearchFailure failure = response.getShardFailures()[0];
                        for (ShardSearchFailure shardFailure : response.getShardFailures()) {
                            if (shardFailure.status().getStatus() <= failure.status().getStatus()) continue;
                            failure = shardFailure;
                        }
                        listener.onFailure((Exception)((Object)new SkyliteStatusException("Get rollups failed on some shards", failure.status(), failure.getCause(), new Object[0])));
                    } else {
                        try {
                            ArrayList<Rollup> rollups = new ArrayList<Rollup>();
                            for (SearchHit hit : response.getHits().getHits()) {
                                Rollup rollup = ContentParserUtils.parseWithType(ContentParserUtils.contentParser(hit.getSourceRef()), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), Rollup::parse);
                                rollups.add(rollup);
                            }
                            listener.onResponse((Object)new GetRollupsResponse(rollups, (int)totalRollups, RestStatus.OK));
                        }
                        catch (Exception e) {
                            listener.onFailure((Exception)((Object)new SkyliteStatusException("Failed to parse rollups", RestStatus.INTERNAL_SERVER_ERROR, SkyliteExceptionsHelper.unwrapCause((Throwable)e), new Object[0])));
                        }
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }
}

