/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.index;

import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class IndexRollupRequest
extends IndexRequest {
    private Rollup rollup;

    public IndexRollupRequest(StreamInput sin) throws IOException {
        super(sin);
        this.rollup = new Rollup(sin);
        super.setRefreshPolicy(WriteRequest.RefreshPolicy.readFrom((StreamInput)sin));
    }

    public IndexRollupRequest(Rollup rollup, WriteRequest.RefreshPolicy refreshPolicy) {
        this.rollup = rollup;
        if (rollup.getSeqNo() == -2L || rollup.getPrimaryTerm() == 0L) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else {
            this.setIfSeqNo(rollup.getSeqNo());
            this.setIfPrimaryTerm(rollup.getPrimaryTerm());
        }
        super.setRefreshPolicy(refreshPolicy);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.rollup.getId().isBlank()) {
            validationException = ValidateActions.addValidationError((String)"rollupID is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.rollup.writeTo(out);
        this.getRefreshPolicy().writeTo(out);
    }

    public Rollup getRollup() {
        return this.rollup;
    }

    public void setRollup(Rollup rollup) {
        this.rollup = rollup;
    }
}

